/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spout;

import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.TaskDiagnosticInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.dps.DpsRecord;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.dao.TaskDiagnosticInfoDAO;
import eu.europeana.cloud.service.dps.util.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TasksCache.class);
    private final LRUCache<Long, TaskInfo> cache = new LRUCache(50);
    private final LRUCache<Long, TaskDiagnosticInfo> diagnosticCache = new LRUCache(50);
    private CassandraTaskInfoDAO taskInfoDAO;
    private TaskDiagnosticInfoDAO taskDiagnosticInfoDAO;

    public TasksCache(CassandraConnectionProvider cassandraConnectionProvider) {
        this.taskInfoDAO = CassandraTaskInfoDAO.getInstance(cassandraConnectionProvider);
        this.taskDiagnosticInfoDAO = TaskDiagnosticInfoDAO.getInstance(cassandraConnectionProvider);
    }

    public TaskInfo getTaskInfo(DpsRecord message) throws TaskInfoDoesNotExistException {
        TaskInfo taskInfo = this.findTaskInCache(message);
        if (this.taskFoundInCache(taskInfo)) {
            LOGGER.trace("TaskInfo found in cache");
        } else {
            LOGGER.debug("TaskInfo NOT found in cache");
            taskInfo = this.readTaskFromDB(message.getTaskId());
            this.cache.put(message.getTaskId(), taskInfo);
        }
        return taskInfo;
    }

    private boolean taskFoundInCache(TaskInfo taskInfo) {
        return taskInfo != null;
    }

    private TaskInfo findTaskInCache(DpsRecord kafkaMessage) {
        return this.cache.get(kafkaMessage.getTaskId());
    }

    private TaskInfo readTaskFromDB(long taskId) throws TaskInfoDoesNotExistException {
        return this.findTaskInDb(taskId);
    }

    private TaskInfo findTaskInDb(long taskId) throws TaskInfoDoesNotExistException {
        return this.taskInfoDAO.findById(taskId).orElseThrow(TaskInfoDoesNotExistException::new);
    }

    public TaskDiagnosticInfo getDiagnosticInfo(long taskId) {
        TaskDiagnosticInfo info = this.diagnosticCache.get(taskId);
        if (info == null) {
            info = this.taskDiagnosticInfoDAO.findById(taskId).orElse(TaskDiagnosticInfo.builder().taskId(taskId).build());
            this.diagnosticCache.put(taskId, info);
        }
        return info;
    }
}

