/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.service;

import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.common.model.dps.GeneralStatistics;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.service.dps.ValidationStatisticsService;
import eu.europeana.cloud.service.dps.storm.dao.CassandraAttributeStatisticsDAO;
import eu.europeana.cloud.service.dps.storm.dao.CassandraNodeStatisticsDAO;
import eu.europeana.cloud.service.dps.storm.dao.GeneralStatisticsDAO;
import eu.europeana.cloud.service.dps.storm.dao.StatisticsReportDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ValidationStatisticsServiceImpl
implements ValidationStatisticsService {
    public static final int ELEMENTS_SAMPLE_MAX_SIZE = 100;
    public static final int ATTRIBUTES_SAMPLE_MAX_SIZE = 25;
    public static final int ATTRIBUTES_MAX_ALLOWED_VALUES = 15;
    private static ValidationStatisticsServiceImpl instance;
    private GeneralStatisticsDAO generalStatisticsDAO;
    private CassandraNodeStatisticsDAO cassandraNodeStatisticsDAO;
    private CassandraAttributeStatisticsDAO cassandraAttributeStatisticsDAO;
    private StatisticsReportDAO statisticsReportDAO;

    public static synchronized ValidationStatisticsServiceImpl getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new ValidationStatisticsServiceImpl(GeneralStatisticsDAO.getInstance(cassandra), CassandraNodeStatisticsDAO.getInstance(cassandra), CassandraAttributeStatisticsDAO.getInstance(cassandra), StatisticsReportDAO.getInstance(cassandra));
        }
        return instance;
    }

    public ValidationStatisticsServiceImpl() {
    }

    public ValidationStatisticsServiceImpl(GeneralStatisticsDAO generalStatisticsDAO, CassandraNodeStatisticsDAO cassandraNodeStatisticsDAO, CassandraAttributeStatisticsDAO cassandraAttributeStatisticsDAO, StatisticsReportDAO statisticsReportDAO) {
        this.generalStatisticsDAO = generalStatisticsDAO;
        this.cassandraNodeStatisticsDAO = cassandraNodeStatisticsDAO;
        this.cassandraAttributeStatisticsDAO = cassandraAttributeStatisticsDAO;
        this.statisticsReportDAO = statisticsReportDAO;
    }

    @Override
    public StatisticsReport getTaskStatisticsReport(long taskId) {
        StatisticsReport report = this.statisticsReportDAO.getStatisticsReport(taskId);
        if (report == null) {
            List<NodeStatistics> nodeStatistics = this.getNodeStatistics(taskId);
            if (nodeStatistics == null || nodeStatistics.isEmpty()) {
                return null;
            }
            report = new StatisticsReport(taskId, nodeStatistics);
            this.storeStatisticsReport(taskId, report);
        }
        return report;
    }

    @Override
    public List<NodeReport> getElementReport(long taskId, String nodeXpath) {
        ArrayList<NodeReport> result = new ArrayList<NodeReport>();
        for (NodeStatistics nodeStatistics : this.cassandraNodeStatisticsDAO.getNodeStatistics(taskId, null, nodeXpath, 100)) {
            String elementValue = nodeStatistics.getValue();
            ArrayList<AttributeStatistics> attributeStatistics = new ArrayList<AttributeStatistics>(this.cassandraAttributeStatisticsDAO.getAttributeStatistics(taskId, nodeXpath, elementValue, 25));
            NodeReport nodeValues = new NodeReport(elementValue, nodeStatistics.getOccurrence(), attributeStatistics);
            result.add(nodeValues);
        }
        return result;
    }

    public void insertNodeStatistics(long taskId, List<NodeStatistics> nodes) {
        for (NodeStatistics nodeStatistics : nodes) {
            this.insertNodeStatistics(taskId, nodeStatistics);
        }
    }

    private void insertNodeStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.generalStatisticsDAO.updateGeneralStatistics(taskId, nodeStatistics);
        if (nodeStatistics.getValue() != null) {
            this.cassandraNodeStatisticsDAO.updateNodeStatistics(taskId, nodeStatistics);
        }
        if (nodeStatistics.hasAttributes()) {
            this.insertAttributeStatistics(taskId, nodeStatistics.getXpath(), nodeStatistics.getValue(), nodeStatistics.getAttributesStatistics());
        }
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, Set<AttributeStatistics> attributes) {
        for (AttributeStatistics attributeStatistics : attributes) {
            long distinctValuesCount = this.cassandraAttributeStatisticsDAO.getAttributeDistinctValues(taskId, nodeXpath, nodeValue, attributeStatistics.getName());
            if (distinctValuesCount >= 15L) {
                long currentCount = this.cassandraAttributeStatisticsDAO.getSpecificAttributeValueCount(taskId, nodeXpath, nodeValue, attributeStatistics.getName(), attributeStatistics.getValue());
                if (currentCount <= 0L) continue;
                this.cassandraAttributeStatisticsDAO.insertAttributeStatistics(taskId, nodeXpath, nodeValue, attributeStatistics);
                continue;
            }
            this.cassandraAttributeStatisticsDAO.insertAttributeStatistics(taskId, nodeXpath, nodeValue, attributeStatistics);
        }
    }

    public List<NodeStatistics> getNodeStatistics(long taskId) {
        ArrayList<NodeStatistics> result = new ArrayList<NodeStatistics>();
        for (GeneralStatistics generalStatistics : this.generalStatisticsDAO.searchGeneralStatistics(taskId)) {
            List<NodeStatistics> nodeStatistics = this.getNodeStatistics(taskId, generalStatistics.getParentXpath(), generalStatistics.getNodeXpath());
            if (nodeStatistics.isEmpty()) {
                NodeStatistics node = new NodeStatistics(generalStatistics.getParentXpath(), generalStatistics.getNodeXpath(), "", generalStatistics.getOccurrence());
                node.setAttributesStatistics(this.cassandraAttributeStatisticsDAO.getAttributeStatistics(taskId, generalStatistics.getNodeXpath(), "", 2));
            }
            result.addAll(nodeStatistics);
        }
        return result;
    }

    private List<NodeStatistics> getNodeStatistics(long taskId, String parentXpath, String nodeXpath) {
        List<NodeStatistics> nodeStatisticsList = this.cassandraNodeStatisticsDAO.getNodeStatistics(taskId, parentXpath, nodeXpath, 2);
        nodeStatisticsList.forEach(nodeStatistics -> nodeStatistics.setAttributesStatistics(this.cassandraAttributeStatisticsDAO.getAttributeStatistics(taskId, nodeXpath, nodeStatistics.getValue(), 2)));
        return nodeStatisticsList;
    }

    void storeStatisticsReport(long taskId, StatisticsReport report) {
        if (this.statisticsReportDAO.isReportStored(taskId)) {
            return;
        }
        this.statisticsReportDAO.storeReport(taskId, report);
    }

    public void removeStatistics(long taskId) {
        this.removeGeneralStatistics(taskId);
        this.statisticsReportDAO.removeStatisticsReport(taskId);
    }

    private void removeGeneralStatistics(long taskId) {
        for (GeneralStatistics s2 : this.generalStatisticsDAO.searchGeneralStatistics(taskId)) {
            this.removeNodeStatistics(taskId, s2.getNodeXpath());
        }
        this.generalStatisticsDAO.removeGeneralStatistics(taskId);
    }

    private void removeNodeStatistics(long taskId, String nodeXpath) {
        for (String value : this.cassandraNodeStatisticsDAO.searchNodeStatisticsValues(taskId, nodeXpath)) {
            this.cassandraAttributeStatisticsDAO.removeAttributeStatistics(taskId, nodeXpath, value);
        }
        this.cassandraNodeStatisticsDAO.removeNodeStatistics(taskId, nodeXpath);
    }
}

