/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.notification.handler;

import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.storm.NotificationTuple;
import eu.europeana.cloud.service.dps.storm.notification.NotificationCacheEntry;
import eu.europeana.cloud.service.dps.storm.notification.handler.NotificationHandlerConfig;

public class NotificationHandlerConfigBuilder {
    private NotificationHandlerConfigBuilder() {
    }

    public static NotificationHandlerConfig prepareNotificationHandlerConfig(NotificationTuple notificationTuple, NotificationCacheEntry notificationCacheEntry, boolean needsPostprocessing) {
        NotificationHandlerConfig.NotificationHandlerConfigBuilder builder = NotificationHandlerConfig.builder();
        builder.recordStateToBeSet(NotificationHandlerConfigBuilder.isError(notificationTuple) ? RecordState.ERROR : RecordState.SUCCESS);
        builder.notificationCacheEntry(notificationCacheEntry);
        if (NotificationHandlerConfigBuilder.isLastOneTupleInTask(notificationCacheEntry.getExpectedRecordsNumber(), notificationCacheEntry.getProcessed())) {
            return builder.taskStateToBeSet(needsPostprocessing ? TaskState.READY_FOR_POST_PROCESSING : TaskState.PROCESSED).build();
        }
        return builder.build();
    }

    private static boolean isLastOneTupleInTask(int expectedSize, int processedRecordsCount) {
        return processedRecordsCount + 1 == expectedSize;
    }

    private static boolean isError(NotificationTuple notificationTuple) {
        return NotificationHandlerConfigBuilder.isErrorTuple(notificationTuple) || notificationTuple.getParameter("UNIFIED_ERROR_MESSAGE") != null;
    }

    private static boolean isErrorTuple(NotificationTuple notificationTuple) {
        return String.valueOf(notificationTuple.getParameters().get("state")).equalsIgnoreCase(RecordState.ERROR.toString());
    }
}

