/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.gson.Gson;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;

@Retryable(maxAttempts=7)
public class StatisticsReportDAO
extends CassandraDAO {
    private static StatisticsReportDAO instance = null;
    private final Gson gson = new Gson();
    private PreparedStatement getStatisticsReportStatement;
    private PreparedStatement removeStatisticsReportStatement;
    private PreparedStatement storeStatisticsReportStatement;
    private PreparedStatement checkStatisticsReportStatement;

    public static synchronized StatisticsReportDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new StatisticsReportDAO(cassandra));
        }
        return instance;
    }

    public StatisticsReportDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public StatisticsReportDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.storeStatisticsReportStatement = this.dbService.getSession().prepare("INSERT INTO statistics_reports (task_id,report_data) VALUES (?,textasblob(?))");
        this.storeStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.checkStatisticsReportStatement = this.dbService.getSession().prepare("SELECT task_id FROM statistics_reports WHERE task_id = ?");
        this.checkStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.getStatisticsReportStatement = this.dbService.getSession().prepare("SELECT blobastext(report_data) FROM statistics_reports WHERE task_id = ?");
        this.getStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeStatisticsReportStatement = this.dbService.getSession().prepare("DELETE  FROM statistics_reports WHERE task_id = ?");
        this.removeStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void storeReport(long taskId, StatisticsReport report) {
        String reportSerialized = this.gson.toJson(report);
        if (reportSerialized != null) {
            BoundStatement bs = this.storeStatisticsReportStatement.bind(taskId, reportSerialized);
            this.dbService.getSession().execute(bs);
        }
    }

    public boolean isReportStored(long taskId) {
        BoundStatement bs = this.checkStatisticsReportStatement.bind(taskId);
        ResultSet rs = this.dbService.getSession().execute(bs);
        return rs.iterator().hasNext();
    }

    public StatisticsReport getStatisticsReport(long taskId) {
        BoundStatement bs = this.getStatisticsReportStatement.bind(taskId);
        ResultSet rs = this.dbService.getSession().execute(bs);
        if (rs.iterator().hasNext()) {
            Row row = rs.one();
            String report = row.getString(0);
            return this.gson.fromJson(report, StatisticsReport.class);
        }
        return null;
    }

    public void removeStatisticsReport(long taskId) {
        this.dbService.getSession().execute(this.removeStatisticsReportStatement.bind(taskId));
    }
}

