/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.ProcessedRecord;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import eu.europeana.cloud.service.dps.storm.utils.BucketUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;

@Retryable(maxAttempts=7)
public class ProcessedRecordsDAO
extends CassandraDAO {
    private static final int BUCKETS_COUNT = 128;
    private PreparedStatement insertStatement;
    private PreparedStatement updateRecordStateStatement;
    private PreparedStatement updateRecordStartTime;
    private PreparedStatement updateAttemptNumberStatement;
    private PreparedStatement selectByPrimaryKeyStatement;
    private static ProcessedRecordsDAO instance = null;

    public ProcessedRecordsDAO() {
    }

    public static synchronized ProcessedRecordsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new ProcessedRecordsDAO(cassandra));
        }
        return instance;
    }

    public ProcessedRecordsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    protected void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO processed_records(task_id,record_id,bucket_number,attempt_number,dst_identifier,topology_name,state,start_time,info_text,additional_informations) VALUES (?,?,?,?,?,?,?,?,?,?)");
        this.updateRecordStateStatement = this.dbService.getSession().prepare("INSERT INTO processed_records(task_id,record_id,bucket_number,state) VALUES (?,?,?,?)");
        this.updateRecordStartTime = this.dbService.getSession().prepare("INSERT INTO processed_records(task_id,record_id,bucket_number,start_time) VALUES (?,?,?,?)");
        this.updateAttemptNumberStatement = this.dbService.getSession().prepare("INSERT INTO processed_records(task_id,record_id,bucket_number,attempt_number) VALUES (?,?,?,?)");
        this.selectByPrimaryKeyStatement = this.dbService.getSession().prepare("SELECT attempt_number,dst_identifier,topology_name,state,start_time,info_text,additional_informations FROM processed_records WHERE task_id = ? AND record_id = ? AND bucket_number = ?");
    }

    public void insert(long taskId, String recordId, int attemptNumber, String dstResource, String topologyName, String state, String infoText, String additionalInformations) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute(this.insertStatement.bind(taskId, recordId, BucketUtils.bucketNumber(recordId, 128), attemptNumber, dstResource, topologyName, state, Calendar.getInstance().getTime(), infoText, additionalInformations));
    }

    public void insert(ProcessedRecord theRecord) throws NoHostAvailableException, QueryExecutionException {
        this.insert(theRecord.getTaskId(), theRecord.getRecordId(), theRecord.getAttemptNumber(), theRecord.getDstIdentifier(), theRecord.getTopologyName(), theRecord.getState().toString(), theRecord.getInfoText(), theRecord.getAdditionalInformations());
    }

    public BoundStatement updateProcessedRecordStateStatement(long taskId, String recordId, RecordState state) {
        return this.updateRecordStateStatement.bind(taskId, recordId, BucketUtils.bucketNumber(recordId, 128), state.toString());
    }

    public void updateProcessedRecordState(long taskId, String recordId, RecordState state) {
        this.dbService.getSession().execute(this.updateProcessedRecordStateStatement(taskId, recordId, state));
    }

    public Optional<ProcessedRecord> selectByPrimaryKey(long taskId, String recordId) throws NoHostAvailableException, QueryExecutionException {
        ProcessedRecord result = null;
        ResultSet rs = this.dbService.getSession().execute(this.selectByPrimaryKeyStatement.bind(taskId, recordId, BucketUtils.bucketNumber(recordId, 128)));
        Row row = rs.one();
        if (row != null) {
            result = ProcessedRecord.builder().taskId(taskId).recordId(recordId).attemptNumber(row.getInt("attempt_number")).dstIdentifier(row.getString("dst_identifier")).topologyName(row.getString("topology_name")).state(RecordState.valueOf(row.getString("state"))).starTime(row.getTimestamp("start_time")).infoText(row.getString("info_text")).additionalInformations(row.getString("additional_informations")).build();
        }
        return Optional.ofNullable(result);
    }

    public void updateStartTime(long taskId, String recordId, Date startTime) {
        this.dbService.getSession().execute(this.updateRecordStartTime.bind(taskId, recordId, BucketUtils.bucketNumber(recordId, 128), startTime));
    }

    public void updateAttempNumber(long taskId, String recordId, int attempNumber) {
        this.dbService.getSession().execute(this.updateAttemptNumberStatement.bind(taskId, recordId, BucketUtils.bucketNumber(recordId, 128), attempNumber));
    }
}

