/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.GeneralStatistics;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.List;
import java.util.stream.Collectors;

@Retryable(maxAttempts=7)
public class GeneralStatisticsDAO
extends CassandraDAO {
    private static GeneralStatisticsDAO instance = null;
    private PreparedStatement updateStatement;
    private PreparedStatement removeGeneralStatisticsStatement;
    private PreparedStatement searchGeneralStatistcsByTaskIdStatement;

    public static synchronized GeneralStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new GeneralStatisticsDAO(cassandra));
        }
        return instance;
    }

    public GeneralStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public GeneralStatisticsDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.updateStatement = this.dbService.getSession().prepare("UPDATE general_statistics SET occurrence = occurrence + 1 WHERE task_id = ? AND parent_xpath = ? AND node_xpath = ?");
        this.updateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeGeneralStatisticsStatement = this.dbService.getSession().prepare("DELETE  FROM general_statistics WHERE task_id = ?");
        this.removeGeneralStatisticsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchGeneralStatistcsByTaskIdStatement = this.dbService.getSession().prepare("SELECT * FROM general_statistics WHERE task_id = ?");
        this.searchGeneralStatistcsByTaskIdStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void updateGeneralStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute(this.updateStatement.bind(taskId, nodeStatistics.getParentXpath(), nodeStatistics.getXpath()));
    }

    public void removeGeneralStatistics(long taskId) {
        this.dbService.getSession().execute(this.removeGeneralStatisticsStatement.bind(taskId));
    }

    public List<GeneralStatistics> searchGeneralStatistics(long taskId) {
        return this.dbService.getSession().execute(this.searchGeneralStatistcsByTaskIdStatement.bind(taskId)).all().stream().map(this::createGeneralStatistics).collect(Collectors.toList());
    }

    private GeneralStatistics createGeneralStatistics(Row row) {
        return GeneralStatistics.builder().parentXpath(row.getString("parent_xpath")).nodeXpath(row.getString("node_xpath")).occurrence(row.getLong("occurrence")).build();
    }
}

