/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.Notification;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;

@Retryable(maxAttempts=7)
public class CassandraSubTaskInfoDAO
extends CassandraDAO {
    public static final int BUCKET_SIZE = 10000;
    private PreparedStatement subtaskInsertStatement;
    private PreparedStatement processedFilesCountStatement;
    private PreparedStatement removeNotificationsByTaskId;
    private static CassandraSubTaskInfoDAO instance = null;

    public static synchronized CassandraSubTaskInfoDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new CassandraSubTaskInfoDAO(cassandra));
        }
        return instance;
    }

    public CassandraSubTaskInfoDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraSubTaskInfoDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.subtaskInsertStatement = this.dbService.getSession().prepare("INSERT INTO notifications(task_id,bucket_number,resource_num,topology_name,resource,state,info_text,additional_informations,result_resource) VALUES (?,?,?,?,?,?,?,?,?)");
        this.subtaskInsertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.processedFilesCountStatement = this.dbService.getSession().prepare("SELECT resource_num FROM notifications WHERE task_id = ? AND bucket_number = ? ORDER BY resource_num DESC limit 1");
        this.processedFilesCountStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeNotificationsByTaskId = this.dbService.getSession().prepare("delete from notifications WHERE task_id = ? AND bucket_number = ?");
    }

    public void insert(int resourceNum, long taskId, String topologyName, String resource, String state, String infoTxt, String additionalInformations, String resultResource) {
        this.dbService.getSession().execute(this.subtaskInsertStatement.bind(taskId, CassandraSubTaskInfoDAO.bucketNumber(resourceNum), resourceNum, topologyName, resource, state, infoTxt, additionalInformations, resultResource));
    }

    public BoundStatement insertNotificationStatement(Notification notification) {
        return this.subtaskInsertStatement.bind(notification.getTaskId(), CassandraSubTaskInfoDAO.bucketNumber(notification.getResourceNum()), notification.getResourceNum(), notification.getTopologyName(), notification.getResource(), notification.getState(), notification.getInfoText(), notification.getAdditionalInformation(), notification.getResultResource());
    }

    public int getProcessedFilesCount(long taskId) {
        Row row;
        int bucketNumber = 0;
        int filesCount = 0;
        do {
            ResultSet rs;
            if ((row = (rs = this.dbService.getSession().execute(this.processedFilesCountStatement.bind(taskId, bucketNumber))).one()) == null) continue;
            filesCount = row.getInt("resource_num");
            ++bucketNumber;
        } while (row != null);
        return filesCount;
    }

    public void removeNotifications(long taskId) {
        int lastBucket;
        for (int i = lastBucket = CassandraSubTaskInfoDAO.bucketNumber(this.getProcessedFilesCount(taskId) - 1); i >= 0; --i) {
            this.dbService.getSession().execute(this.removeNotificationsByTaskId.bind(taskId, i));
        }
    }

    public static int bucketNumber(int resourceNum) {
        return resourceNum / 10000;
    }
}

