/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.cloud.service.dps.DpsRecord;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsRecordSerializer
implements Serializer<DpsRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DpsRecordSerializer.class);

    @Override
    public void configure(Map<String, ?> parameters, boolean b) {
    }

    @Override
    public byte[] serialize(String s2, DpsRecord dpsRecord) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            return objectMapper.writeValueAsString(dpsRecord).getBytes();
        }
        catch (JsonProcessingException e) {
            LOGGER.error(String.format("Json processing failed for object: %s", dpsRecord.getClass().getName()), e);
        }
        catch (IOException e) {
            LOGGER.error("Exception happened because of {} for the object {} ", (Object)e.getMessage(), (Object)dpsRecord.getClass().getName());
        }
        return "".getBytes();
    }

    @Override
    public void close() {
    }
}

