/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model;

import eu.europeana.cloud.service.mcs.Storage;
import java.net.URI;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class File {
    private String fileName;
    private String mimeType;
    private String md5;
    private String date;
    private long contentLength;
    private URI contentUri;
    private Storage fileStorage;

    public File() {
        this.fileStorage = Storage.OBJECT_STORAGE;
    }

    public File(String fileName, String mimeType, String md5, String date, long contentLength, URI contentUri, Storage fileStorage) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.md5 = md5;
        this.date = date;
        this.contentLength = contentLength;
        this.contentUri = contentUri;
        this.fileStorage = fileStorage;
    }

    public File(String fileName, String mimeType, String md5, String date, long contentLength, URI contentUri) {
        this(fileName, mimeType, md5, date, contentLength, contentUri, Storage.OBJECT_STORAGE);
    }

    public File(File file) {
        this(file.getFileName(), file.getMimeType(), file.getMd5(), file.getDate(), file.getContentLength(), file.getContentUri(), file.fileStorage);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public URI getContentUri() {
        return this.contentUri;
    }

    public void setContentUri(URI contentUri) {
        this.contentUri = contentUri;
    }

    public Storage getFileStorage() {
        return this.fileStorage;
    }

    public void setFileStorage(Storage fileStorage) {
        this.fileStorage = fileStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File file = (File)o;
        if (this.contentLength != file.contentLength) {
            return false;
        }
        if (this.fileStorage != file.fileStorage) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(file.fileName) : file.fileName != null) {
            return false;
        }
        if (this.mimeType != null ? !this.mimeType.equals(file.mimeType) : file.mimeType != null) {
            return false;
        }
        if (this.md5 != null ? !this.md5.equals(file.md5) : file.md5 != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(file.date) : file.date != null) {
            return false;
        }
        return this.contentUri != null ? this.contentUri.equals(file.contentUri) : file.contentUri == null;
    }

    public int hashCode() {
        int result = this.fileName != null ? this.fileName.hashCode() : 0;
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.md5 != null ? this.md5.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (int)(this.contentLength ^ this.contentLength >>> 32);
        result = 31 * result + (this.contentUri != null ? this.contentUri.hashCode() : 0);
        result = 31 * result + (this.fileStorage != null ? this.fileStorage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "File{fileName='" + this.fileName + "', mimeType='" + this.mimeType + "', md5='" + this.md5 + "', date='" + this.date + "', contentLength=" + this.contentLength + ", contentUri=" + this.contentUri + ", fileStorage=" + this.fileStorage + "}";
    }
}

