/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.web.StaticUrlProvider;
import eu.europeana.cloud.client.uis.rest.web.UrlProvider;
import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.LocalId;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.uis.status.IdentifierErrorTemplate;
import java.util.function.Supplier;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UISClient
implements AutoCloseable {
    private static final String CLOUD_IDS_PATH = "/cloudIds";
    private static final String P_CLOUD_ID = "CLOUD_ID";
    private static final String P_PROVIDER_ID = "PROVIDER_ID";
    private static final String DATA_PROVIDERS_PATH_WITH_PROVIDER_ID = "/data-providers/{PROVIDER_ID}";
    private static final String P_LOCAL_ID = "LOCAL_ID";
    private static final String DATA_PROVIDERS_PATH = "/data-providers";
    private static final String CLOUD_IDS_PATH_WITH_CLOUD_ID = "/cloudIds/{CLOUD_ID}";
    private static final String OTHER_CLIENT_MESSAGE = "Other client error";
    private UrlProvider urlProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(UISClient.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 20000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MILLIS = 60000;
    protected final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();

    public UISClient(String uisUrl, String username, String password) {
        this(uisUrl, username, password, 20000, 60000);
    }

    public UISClient(String uisUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        LOGGER.info("UISClient starting...");
        if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basic(username, password));
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        try {
            this.urlProvider = new StaticUrlProvider(uisUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(String uisUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this(uisUrl, null, null, connectTimeoutInMillis, readTimeoutInMillis);
    }

    public UISClient(String uisUrl) {
        this(uisUrl, 20000, 60000);
    }

    public CloudId createCloudId(String providerId, String recordId) throws CloudException {
        return this.manageResponse(new ResponseParams<CloudId>(CloudId.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH).queryParam("providerId", providerId).queryParam("recordId", recordId).request().post(null));
    }

    public CloudId createCloudId(String providerId, String recordId, String key, String value) throws CloudException {
        return this.manageResponse(new ResponseParams<CloudId>(CloudId.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH).queryParam("providerId", providerId).queryParam("recordId", recordId).request().header(key, value).accept("application/json").post(null));
    }

    public CloudId createCloudId(String providerId) throws CloudException {
        return this.manageResponse(new ResponseParams<CloudId>(CloudId.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH).queryParam("providerId", providerId).request().post(null));
    }

    public CloudId getCloudId(String providerId, String recordId) throws CloudException {
        return this.manageResponse(new ResponseParams<CloudId>(CloudId.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH).queryParam("providerId", providerId).queryParam("recordId", recordId).request().get());
    }

    public CloudId getCloudId(String providerId, String recordId, String key, String value) throws CloudException {
        return this.manageResponse(new ResponseParams<CloudId>(CloudId.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH).queryParam("providerId", providerId).queryParam("recordId", recordId).request().header(key, value).get());
    }

    public ResultSlice<CloudId> getRecordId(String cloudId) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH_WITH_CLOUD_ID).resolveTemplate(P_CLOUD_ID, cloudId).request().get());
    }

    public ResultSlice<LocalId> getRecordIdsByProvider(String providerId) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/localIds").resolveTemplate(P_PROVIDER_ID, providerId).request().get());
    }

    public ResultSlice<CloudId> getCloudIdsByProvider(String providerId) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/cloudIds").resolveTemplate(P_PROVIDER_ID, providerId).request().get());
    }

    public ResultSlice<LocalId> getRecordIdsByProviderWithPagination(String providerId, String startRecordId, int limit) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/localIds").resolveTemplate(P_PROVIDER_ID, providerId).queryParam("from", startRecordId).queryParam("limit", limit).request().get());
    }

    public ResultSlice<CloudId> getCloudIdsByProviderWithPagination(String providerId, String startRecordId, int limit) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/cloudIds").resolveTemplate(P_PROVIDER_ID, providerId).queryParam("from", startRecordId).queryParam("limit", limit).request().get());
    }

    public boolean createMapping(String cloudId, String providerId, String recordId) throws CloudException {
        return this.manageResponse(new ResponseParams<Boolean>(Boolean.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/cloudIds/{CLOUD_ID}").resolveTemplate(P_PROVIDER_ID, providerId).resolveTemplate(P_CLOUD_ID, cloudId).queryParam("recordId", recordId).request().post(null));
    }

    public boolean createMapping(String cloudId, String providerId, String recordId, String key, String value) throws CloudException {
        return this.manageResponse(new ResponseParams<Boolean>(Boolean.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/cloudIds/{CLOUD_ID}").resolveTemplate(P_PROVIDER_ID, providerId).resolveTemplate(P_CLOUD_ID, cloudId).queryParam("recordId", recordId).request().post(null));
    }

    public boolean removeMappingByLocalId(String providerId, String recordId) throws CloudException {
        return this.manageResponse(new ResponseParams<Boolean>(Boolean.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path("/data-providers/{PROVIDER_ID}/localIds/{LOCAL_ID}").resolveTemplate(P_PROVIDER_ID, providerId).resolveTemplate(P_LOCAL_ID, recordId).request().delete());
    }

    public boolean deleteCloudId(String cloudId) throws CloudException {
        return this.manageResponse(new ResponseParams<Boolean>(Boolean.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(CLOUD_IDS_PATH_WITH_CLOUD_ID).resolveTemplate(P_CLOUD_ID, cloudId).request().delete());
    }

    public String createProvider(String providerId, DataProviderProperties dp) throws CloudException {
        return this.manageResponse(new ResponseParams<String>(String.class, Response.Status.CREATED), () -> this.client.target(this.urlProvider.getBaseUrl()).path(DATA_PROVIDERS_PATH).queryParam("providerId", providerId).request().post(Entity.json(dp)));
    }

    public boolean updateProvider(String providerId, DataProviderProperties dp) throws CloudException {
        return this.manageResponse(new ResponseParams<Boolean>(Boolean.class, Response.Status.NO_CONTENT), () -> this.client.target(this.urlProvider.getBaseUrl()).path(DATA_PROVIDERS_PATH_WITH_PROVIDER_ID).resolveTemplate(P_PROVIDER_ID, providerId).request().put(Entity.json(dp)));
    }

    public ResultSlice<DataProvider> getDataProviders(String from) throws CloudException {
        return this.manageResponse(new ResponseParams<ResultSlice>(ResultSlice.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(DATA_PROVIDERS_PATH).queryParam("from", from).request().get());
    }

    public DataProvider getDataProvider(String providerId) throws CloudException {
        return this.manageResponse(new ResponseParams<DataProvider>(DataProvider.class), () -> this.client.target(this.urlProvider.getBaseUrl()).path(DATA_PROVIDERS_PATH_WITH_PROVIDER_ID).resolveTemplate(P_PROVIDER_ID, providerId).request().get());
    }

    protected <T> T manageResponse(ResponseParams<T> responseParameters, Supplier<Response> responseSupplier) throws CloudException {
        Response response = responseSupplier.get();
        try {
            response.bufferEntity();
            if (response.getStatus() == responseParameters.getValidStatus().getStatusCode()) {
                Boolean bl = responseParameters.getExpectedClass() == Boolean.class ? Boolean.TRUE : response.readEntity(responseParameters.getExpectedClass());
                return (T)bl;
            }
            try {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                IdentifierErrorTemplate error = IdentifierErrorTemplate.valueOf(errorInfo.getErrorCode());
                throw this.createException(errorInfo.getDetails(), errorInfo.getErrorCode(), (Exception)error.getException(errorInfo));
            }
            catch (CloudException cloudException) {
                throw cloudException;
            }
            catch (ProcessingException processingException) {
                String message = String.format("Could not deserialize response with statusCode: %d; message: %s", response.getStatus(), response.readEntity(String.class));
                throw this.createException(message, message, processingException);
            }
            catch (Exception otherExceptions) {
                throw this.createException(OTHER_CLIENT_MESSAGE, OTHER_CLIENT_MESSAGE, otherExceptions);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    private CloudException createException(String errorMessage, String errorCode, Exception causeException) {
        LOGGER.error(errorMessage, causeException);
        return new CloudException(errorCode, causeException);
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    @Deprecated(forRemoval=true)
    protected void finalize() throws Throwable {
        LOGGER.warn("'{}.finalize()' called!!!\n{}", (Object)this.getClass().getSimpleName(), (Object)Thread.currentThread().getStackTrace());
        this.client.close();
    }

    protected static class ResponseParams<T> {
        private final Class<T> expectedClass;
        private final Response.Status validStatus;

        public ResponseParams(Class<T> expectedClass) {
            this(expectedClass, Response.Status.OK);
        }

        private ResponseParams(Class<T> expectedClass, Response.Status validStatus) {
            this.expectedClass = expectedClass;
            this.validStatus = validStatus;
        }

        public Class<T> getExpectedClass() {
            return this.expectedClass;
        }

        public Response.Status getValidStatus() {
            return this.validStatus;
        }
    }
}

