/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.util.UUID;

public abstract class AbstractUuidCreator {
    protected final int version;
    protected final long versionBits;

    protected AbstractUuidCreator() {
        this.version = 0;
        this.versionBits = 0L;
    }

    public AbstractUuidCreator(int version) {
        if (version < 0 || version > 15) {
            throw new IllegalArgumentException("Invalid UUID version");
        }
        this.version = version;
        this.versionBits = version << 12;
    }

    public AbstractUuidCreator(UuidVersion version) {
        this(version.getValue());
    }

    public int getVersion() {
        return this.version;
    }

    protected UUID getUuid(byte[] bytes) {
        long msb = 0L;
        long lsb = 0L;
        msb |= ((long)bytes[0] & 0xFFL) << 56;
        msb |= ((long)bytes[1] & 0xFFL) << 48;
        msb |= ((long)bytes[2] & 0xFFL) << 40;
        msb |= ((long)bytes[3] & 0xFFL) << 32;
        msb |= ((long)bytes[4] & 0xFFL) << 24;
        msb |= ((long)bytes[5] & 0xFFL) << 16;
        msb |= ((long)bytes[6] & 0xFFL) << 8;
        msb |= (long)bytes[7] & 0xFFL;
        lsb |= ((long)bytes[8] & 0xFFL) << 56;
        lsb |= ((long)bytes[9] & 0xFFL) << 48;
        lsb |= ((long)bytes[10] & 0xFFL) << 40;
        lsb |= ((long)bytes[11] & 0xFFL) << 32;
        lsb |= ((long)bytes[12] & 0xFFL) << 24;
        lsb |= ((long)bytes[13] & 0xFFL) << 16;
        lsb |= ((long)bytes[14] & 0xFFL) << 8;
        lsb |= (long)bytes[15] & 0xFFL;
        msb = msb & 0xFFFFFFFFFFFF0FFFL | this.versionBits;
        lsb = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }

    protected UUID getUuid(long msb, long lsb) {
        msb = msb & 0xFFFFFFFFFFFF0FFFL | this.versionBits;
        lsb = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }
}

