/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class CountingEntity
extends HttpEntityWrapper {
    private long count = 0L;

    public CountingEntity(HttpEntity wrapped) {
        super(wrapped);
    }

    public InputStream getContent() throws IOException {
        return new FilterInputStream(super.getContent()){

            @Override
            public int read() throws IOException {
                int read = super.read();
                if (read >= 0) {
                    CountingEntity countingEntity = CountingEntity.this;
                    countingEntity.count = countingEntity.count + 1L;
                }
                return read;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int read = super.read(b);
                if (read > 0) {
                    CountingEntity countingEntity = CountingEntity.this;
                    countingEntity.count = countingEntity.count + (long)read;
                }
                return read;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int read = super.read(b, off, len);
                if (read > 0) {
                    CountingEntity countingEntity = CountingEntity.this;
                    countingEntity.count = countingEntity.count + (long)read;
                }
                return read;
            }
        };
    }

    public long getByteCount() {
        return this.count;
    }
}

