/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.utils;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class CloudIdReader {
    private String filename;
    private LineNumberReader reader = null;

    public CloudIdReader(String filename) {
        this.filename = filename;
    }

    public List<String> getNextCloudId(int fetchSize) throws IOException {
        String cloudId;
        if (this.reader == null) {
            this.reader = new LineNumberReader(new FileReader(this.filename));
        }
        ArrayList<String> result = new ArrayList<String>(fetchSize);
        do {
            if ((cloudId = this.reader.readLine()) == null) continue;
            result.add(cloudId);
        } while (--fetchSize > 0 && cloudId != null);
        return result;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

