/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.util.matcher;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public final class PathPatternParserServerWebExchangeMatcher
implements ServerWebExchangeMatcher {
    private static final PathPatternParser DEFAULT_PATTERN_PARSER = new PathPatternParser();
    private final PathPattern pattern;
    private final HttpMethod method;

    public PathPatternParserServerWebExchangeMatcher(PathPattern pattern) {
        this(pattern, null);
    }

    public PathPatternParserServerWebExchangeMatcher(PathPattern pattern, HttpMethod method) {
        Assert.notNull((Object)pattern, "pattern cannot be null");
        this.pattern = pattern;
        this.method = method;
    }

    public PathPatternParserServerWebExchangeMatcher(String pattern, HttpMethod method) {
        Assert.notNull((Object)pattern, "pattern cannot be null");
        this.pattern = DEFAULT_PATTERN_PARSER.parse(pattern);
        this.method = method;
    }

    public PathPatternParserServerWebExchangeMatcher(String pattern) {
        this(pattern, null);
    }

    @Override
    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
        ServerHttpRequest request = exchange2.getRequest();
        if (this.method != null && !this.method.equals((Object)request.getMethod())) {
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }
        PathContainer path = request.getPath().pathWithinApplication();
        boolean match = this.pattern.matches(path);
        if (!match) {
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }
        Map<String, String> pathVariables = this.pattern.matchAndExtract(path).getUriVariables();
        HashMap<String, Object> variables = new HashMap<String, Object>(pathVariables);
        return ServerWebExchangeMatcher.MatchResult.match(variables);
    }

    public String toString() {
        return "PathMatcherServerWebExchangeMatcher{pattern='" + this.pattern + '\'' + ", method=" + (Object)((Object)this.method) + '}';
    }
}

