/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.core.userdetails;

import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.core.userdetails.UserDetailsMapFactoryBean;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.util.InMemoryResource;
import org.springframework.util.Assert;

public class UserDetailsResourceFactoryBean
implements ResourceLoaderAware,
FactoryBean<Collection<UserDetails>> {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private String resourceLocation;
    private Resource resource;

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "resourceLoader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Collection<UserDetails> getObject() throws Exception {
        Properties userProperties = new Properties();
        Resource resource = this.getPropertiesResource();
        try (InputStream in = resource.getInputStream();){
            userProperties.load(in);
        }
        return new UserDetailsMapFactoryBean(userProperties).getObject();
    }

    @Override
    public Class<?> getObjectType() {
        return Collection.class;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    private Resource getPropertiesResource() {
        Resource result = this.resource;
        if (result == null && this.resourceLocation != null) {
            result = this.resourceLoader.getResource(this.resourceLocation);
        }
        Assert.notNull((Object)result, "resource cannot be null if resourceLocation is null");
        return result;
    }

    public static UserDetailsResourceFactoryBean fromResourceLocation(String resourceLocation) {
        UserDetailsResourceFactoryBean result = new UserDetailsResourceFactoryBean();
        result.setResourceLocation(resourceLocation);
        return result;
    }

    public static UserDetailsResourceFactoryBean fromResource(Resource propertiesResource) {
        UserDetailsResourceFactoryBean result = new UserDetailsResourceFactoryBean();
        result.setResource(propertiesResource);
        return result;
    }

    public static UserDetailsResourceFactoryBean fromString(String users) {
        InMemoryResource resource = new InMemoryResource(users);
        return UserDetailsResourceFactoryBean.fromResource(resource);
    }
}

