/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.debug.DebugFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class WebSecurity
extends AbstractConfiguredSecurityBuilder<Filter, WebSecurity>
implements SecurityBuilder<Filter>,
ApplicationContextAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RequestMatcher> ignoredRequests = new ArrayList<RequestMatcher>();
    private final List<SecurityBuilder<? extends SecurityFilterChain>> securityFilterChainBuilders = new ArrayList<SecurityBuilder<? extends SecurityFilterChain>>();
    private IgnoredRequestConfigurer ignoredRequestRegistry;
    private FilterSecurityInterceptor filterSecurityInterceptor;
    private HttpFirewall httpFirewall;
    private boolean debugEnabled;
    private WebInvocationPrivilegeEvaluator privilegeEvaluator;
    private DefaultWebSecurityExpressionHandler defaultWebSecurityExpressionHandler;
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = this.defaultWebSecurityExpressionHandler = new DefaultWebSecurityExpressionHandler();
    private Runnable postBuildAction = () -> {};

    public WebSecurity(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public IgnoredRequestConfigurer ignoring() {
        return this.ignoredRequestRegistry;
    }

    public WebSecurity httpFirewall(HttpFirewall httpFirewall) {
        this.httpFirewall = httpFirewall;
        return this;
    }

    public WebSecurity debug(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public WebSecurity addSecurityFilterChainBuilder(SecurityBuilder<? extends SecurityFilterChain> securityFilterChainBuilder) {
        this.securityFilterChainBuilders.add(securityFilterChainBuilder);
        return this;
    }

    public WebSecurity privilegeEvaluator(WebInvocationPrivilegeEvaluator privilegeEvaluator) {
        this.privilegeEvaluator = privilegeEvaluator;
        return this;
    }

    public WebSecurity expressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        Assert.notNull(expressionHandler, "expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
        return this;
    }

    public SecurityExpressionHandler<FilterInvocation> getExpressionHandler() {
        return this.expressionHandler;
    }

    public WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() {
        if (this.privilegeEvaluator != null) {
            return this.privilegeEvaluator;
        }
        return this.filterSecurityInterceptor == null ? null : new DefaultWebInvocationPrivilegeEvaluator(this.filterSecurityInterceptor);
    }

    public WebSecurity securityInterceptor(FilterSecurityInterceptor securityInterceptor) {
        this.filterSecurityInterceptor = securityInterceptor;
        return this;
    }

    public WebSecurity postBuildAction(Runnable postBuildAction) {
        this.postBuildAction = postBuildAction;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Filter performBuild() throws Exception {
        void var4_9;
        Assert.state(!this.securityFilterChainBuilders.isEmpty(), () -> "At least one SecurityBuilder<? extends SecurityFilterChain> needs to be specified. Typically this done by adding a @Configuration that extends WebSecurityConfigurerAdapter. More advanced users can invoke " + WebSecurity.class.getSimpleName() + ".addSecurityFilterChainBuilder directly");
        int chainSize = this.ignoredRequests.size() + this.securityFilterChainBuilders.size();
        ArrayList<SecurityFilterChain> securityFilterChains = new ArrayList<SecurityFilterChain>(chainSize);
        for (RequestMatcher requestMatcher : this.ignoredRequests) {
            securityFilterChains.add(new DefaultSecurityFilterChain(requestMatcher, new Filter[0]));
        }
        for (SecurityBuilder securityBuilder : this.securityFilterChainBuilders) {
            securityFilterChains.add((SecurityFilterChain)securityBuilder.build());
        }
        FilterChainProxy filterChainProxy = new FilterChainProxy(securityFilterChains);
        if (this.httpFirewall != null) {
            filterChainProxy.setFirewall(this.httpFirewall);
        }
        filterChainProxy.afterPropertiesSet();
        FilterChainProxy filterChainProxy2 = filterChainProxy;
        if (this.debugEnabled) {
            this.logger.warn("\n\n********************************************************************\n**********        Security debugging is enabled.       *************\n**********    This may include sensitive information.  *************\n**********      Do not use in a production system!     *************\n********************************************************************\n\n");
            DebugFilter debugFilter = new DebugFilter(filterChainProxy);
        }
        this.postBuildAction.run();
        return var4_9;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.defaultWebSecurityExpressionHandler.setApplicationContext(applicationContext);
        try {
            this.defaultWebSecurityExpressionHandler.setRoleHierarchy(applicationContext.getBean(RoleHierarchy.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.defaultWebSecurityExpressionHandler.setPermissionEvaluator(applicationContext.getBean(PermissionEvaluator.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        this.ignoredRequestRegistry = new IgnoredRequestConfigurer(applicationContext);
        try {
            this.httpFirewall = applicationContext.getBean(HttpFirewall.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    public class IgnoredRequestConfigurer
    extends AbstractRequestMatcherRegistry<IgnoredRequestConfigurer> {
        private IgnoredRequestConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersIgnoredRequestConfigurer mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            List<MvcRequestMatcher> mvcMatchers = this.createMvcMatchers(method, mvcPatterns);
            WebSecurity.this.ignoredRequests.addAll(mvcMatchers);
            return new MvcMatchersIgnoredRequestConfigurer(this.getApplicationContext(), mvcMatchers);
        }

        @Override
        public MvcMatchersIgnoredRequestConfigurer mvcMatchers(String ... mvcPatterns) {
            return this.mvcMatchers((HttpMethod)null, mvcPatterns);
        }

        @Override
        protected IgnoredRequestConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            WebSecurity.this.ignoredRequests.addAll(requestMatchers);
            return this;
        }

        public WebSecurity and() {
            return WebSecurity.this;
        }
    }

    public final class MvcMatchersIgnoredRequestConfigurer
    extends IgnoredRequestConfigurer {
        private final List<MvcRequestMatcher> mvcMatchers;

        private MvcMatchersIgnoredRequestConfigurer(ApplicationContext context, List<MvcRequestMatcher> mvcMatchers) {
            super(context);
            this.mvcMatchers = mvcMatchers;
        }

        public IgnoredRequestConfigurer servletPath(String servletPath) {
            for (MvcRequestMatcher matcher : this.mvcMatchers) {
                matcher.setServletPath(servletPath);
            }
            return this;
        }
    }
}

