/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityAspectJAutoProxyRegistrar;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.config.annotation.method.configuration.Jsr250MetadataSourceConfiguration;
import org.springframework.security.config.annotation.method.configuration.MethodSecurityMetadataSourceAdvisorRegistrar;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class GlobalMethodSecuritySelector
implements ImportSelector {
    GlobalMethodSecuritySelector() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class<EnableGlobalMethodSecurity> annoType = EnableGlobalMethodSecurity.class;
        Map<String, Object> annotationAttributes = importingClassMetadata.getAnnotationAttributes(annoType.getName(), false);
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(annotationAttributes);
        Assert.notNull((Object)attributes, () -> String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        Class<?> importingClass = ClassUtils.resolveClassName(importingClassMetadata.getClassName(), ClassUtils.getDefaultClassLoader());
        boolean skipMethodSecurityConfiguration = GlobalMethodSecurityConfiguration.class.isAssignableFrom(importingClass);
        AdviceMode mode = (AdviceMode)((Object)attributes.getEnum("mode"));
        boolean isProxy = AdviceMode.PROXY == mode;
        String autoProxyClassName = isProxy ? AutoProxyRegistrar.class.getName() : GlobalMethodSecurityAspectJAutoProxyRegistrar.class.getName();
        boolean jsr250Enabled = attributes.getBoolean("jsr250Enabled");
        ArrayList<String> classNames = new ArrayList<String>(4);
        if (isProxy) {
            classNames.add(MethodSecurityMetadataSourceAdvisorRegistrar.class.getName());
        }
        classNames.add(autoProxyClassName);
        if (!skipMethodSecurityConfiguration) {
            classNames.add(GlobalMethodSecurityConfiguration.class.getName());
        }
        if (jsr250Enabled) {
            classNames.add(Jsr250MetadataSourceConfiguration.class.getName());
        }
        return classNames.toArray(new String[0]);
    }
}

