/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.storm.kafka.bolt.mapper.FieldNameBasedTupleToKafkaMapper;
import org.apache.storm.kafka.bolt.mapper.TupleToKafkaMapper;
import org.apache.storm.kafka.bolt.selector.DefaultTopicSelector;
import org.apache.storm.kafka.bolt.selector.KafkaTopicSelector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBolt<K, V>
extends BaseTickTupleAwareRichBolt {
    private static final long serialVersionUID = -5205886631877033478L;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBolt.class);
    public static final String TOPIC = "topic";
    private KafkaProducer<K, V> producer;
    private OutputCollector collector;
    private TupleToKafkaMapper<K, V> mapper;
    private KafkaTopicSelector topicSelector;
    private Properties boltSpecifiedProperties = new Properties();
    private boolean fireAndForget = false;
    private boolean async = true;

    public KafkaBolt<K, V> withTupleToKafkaMapper(TupleToKafkaMapper<K, V> mapper) {
        this.mapper = mapper;
        return this;
    }

    public KafkaBolt<K, V> withTopicSelector(String topic) {
        return this.withTopicSelector(new DefaultTopicSelector(topic));
    }

    public KafkaBolt<K, V> withTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public KafkaBolt<K, V> withProducerProperties(Properties producerProperties) {
        this.boltSpecifiedProperties = producerProperties;
        return this;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        LOG.info("Preparing bolt with configuration {}", (Object)this);
        if (this.mapper == null) {
            LOG.info("Mapper not specified. Setting default mapper to {}", (Object)FieldNameBasedTupleToKafkaMapper.class.getSimpleName());
            this.mapper = new FieldNameBasedTupleToKafkaMapper();
        }
        if (this.topicSelector == null) {
            if (stormConf.containsKey(TOPIC)) {
                LOG.info("TopicSelector not specified. Using [{}] for topic [{}] specified in bolt configuration,", (Object)DefaultTopicSelector.class.getSimpleName(), stormConf.get(TOPIC));
                this.topicSelector = new DefaultTopicSelector((String)stormConf.get(TOPIC));
            } else {
                throw new IllegalStateException("topic should be specified in bolt's configuration");
            }
        }
        this.producer = this.mkProducer(this.boltSpecifiedProperties);
        this.collector = collector;
    }

    protected KafkaProducer<K, V> mkProducer(Properties props) {
        return new KafkaProducer(props);
    }

    protected void process(final Tuple input) {
        Object key = null;
        Object message = null;
        String topic = null;
        try {
            key = this.mapper.getKeyFromTuple(input);
            message = this.mapper.getMessageFromTuple(input);
            topic = this.topicSelector.getTopic(input);
            if (topic != null) {
                Callback callback = null;
                if (!this.fireAndForget && this.async) {
                    callback = new Callback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onCompletion(RecordMetadata ignored, Exception e) {
                            OutputCollector outputCollector = KafkaBolt.this.collector;
                            synchronized (outputCollector) {
                                if (e != null) {
                                    KafkaBolt.this.collector.reportError((Throwable)e);
                                    KafkaBolt.this.collector.fail(input);
                                } else {
                                    KafkaBolt.this.collector.ack(input);
                                }
                            }
                        }
                    };
                }
                Future<RecordMetadata> result = this.producer.send(new ProducerRecord<Object, Object>(topic, key, message), callback);
                if (!this.async) {
                    try {
                        result.get();
                        this.collector.ack(input);
                    }
                    catch (ExecutionException err) {
                        this.collector.reportError((Throwable)err);
                        this.collector.fail(input);
                    }
                } else if (this.fireAndForget) {
                    this.collector.ack(input);
                }
            } else {
                LOG.warn("skipping key = " + key + ", topic selector returned null.");
                this.collector.ack(input);
            }
        }
        catch (Exception ex) {
            this.collector.reportError((Throwable)ex);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    public void cleanup() {
        this.producer.close();
    }

    public void setFireAndForget(boolean fireAndForget) {
        this.fireAndForget = fireAndForget;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String toString() {
        return "KafkaBolt: {mapper: " + this.mapper + " topicSelector: " + this.topicSelector + " fireAndForget: " + this.fireAndForget + " async: " + this.async + " proerties: " + this.boltSpecifiedProperties;
    }
}

