/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.storm.utils.RevisionIdentifier;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class SubmitTaskParameters {
    private TaskInfo taskInfo;
    private DpsTask task;
    private String topicName;
    private boolean restarted;
    private Date currentHarvestDate;
    private AtomicInteger sentRecordsCounter;

    public int incrementAndGetPerformedRecordCounter() {
        return this.sentRecordsCounter.incrementAndGet();
    }

    public String getTaskParameter(String parameterKey) {
        return this.task.getParameter(parameterKey);
    }

    public boolean getUseAlternativeEnvironment() {
        return Boolean.parseBoolean(this.task.getParameter("USE_ALT_INDEXING_ENV"));
    }

    public String getSchemaName() {
        return this.task.getParameter("SCHEMA_NAME");
    }

    public String getRepresentationName() {
        return this.task.getParameter("REPRESENTATION_NAME");
    }

    public Integer getMaxRecordsCount() {
        return Optional.ofNullable(this.task.getParameter("SAMPLE_SIZE")).map(Integer::parseInt).orElse(Integer.MAX_VALUE);
    }

    public RevisionIdentifier getInputRevision() {
        return new RevisionIdentifier(this.task.getParameter("REVISION_NAME"), this.task.getParameter("REVISION_PROVIDER"), DateHelper.parseISODate(this.task.getParameter("REVISION_TIMESTAMP")));
    }

    public boolean hasInputRevision() {
        return this.getInputRevision().getRevisionName() != null && this.getInputRevision().getRevisionProviderId() != null;
    }

    SubmitTaskParameters(TaskInfo taskInfo, DpsTask task, String topicName, boolean restarted, Date currentHarvestDate, AtomicInteger sentRecordsCounter) {
        this.taskInfo = taskInfo;
        this.task = task;
        this.topicName = topicName;
        this.restarted = restarted;
        this.currentHarvestDate = currentHarvestDate;
        this.sentRecordsCounter = sentRecordsCounter;
    }

    public static SubmitTaskParametersBuilder builder() {
        return new SubmitTaskParametersBuilder();
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public DpsTask getTask() {
        return this.task;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean isRestarted() {
        return this.restarted;
    }

    public Date getCurrentHarvestDate() {
        return this.currentHarvestDate;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public void setTask(DpsTask task) {
        this.task = task;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setRestarted(boolean restarted) {
        this.restarted = restarted;
    }

    public void setCurrentHarvestDate(Date currentHarvestDate) {
        this.currentHarvestDate = currentHarvestDate;
    }

    public String toString() {
        return "SubmitTaskParameters(taskInfo=" + this.getTaskInfo() + ", task=" + this.getTask() + ", topicName=" + this.getTopicName() + ", restarted=" + this.isRestarted() + ", currentHarvestDate=" + this.getCurrentHarvestDate() + ", sentRecordsCounter=" + this.sentRecordsCounter + ")";
    }

    public static class SubmitTaskParametersBuilder {
        private TaskInfo taskInfo;
        private DpsTask task;
        private String topicName;
        private boolean restarted;
        private AtomicInteger sentRecordsCounter = new AtomicInteger();
        private Date currentHarvestDate = new Date();

        SubmitTaskParametersBuilder() {
        }

        public SubmitTaskParametersBuilder taskInfo(TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
            return this;
        }

        public SubmitTaskParametersBuilder task(DpsTask task) {
            this.task = task;
            return this;
        }

        public SubmitTaskParametersBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public SubmitTaskParametersBuilder restarted(boolean restarted) {
            this.restarted = restarted;
            return this;
        }

        public SubmitTaskParametersBuilder currentHarvestDate(Date currentHarvestDate) {
            this.currentHarvestDate = currentHarvestDate;
            return this;
        }

        public SubmitTaskParametersBuilder sentRecordsCounter(AtomicInteger sentRecordsCounter) {
            this.sentRecordsCounter = sentRecordsCounter;
            return this;
        }

        public SubmitTaskParameters build() {
            return new SubmitTaskParameters(this.taskInfo, this.task, this.topicName, this.restarted, this.currentHarvestDate, this.sentRecordsCounter);
        }

        public String toString() {
            return "SubmitTaskParameters.SubmitTaskParametersBuilder(taskInfo=" + this.taskInfo + ", task=" + this.task + ", topicName=" + this.topicName + ", restarted=" + this.restarted + ", currentHarvestDate=" + this.currentHarvestDate + ", sentRecordsCounter=" + this.sentRecordsCounter + ")";
        }
    }
}

