/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.service;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.cassandra.CassandraConnectionProviderSingleton;
import eu.europeana.cloud.common.model.dps.ErrorDetails;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.conversion.TaskInfoConverter;
import eu.europeana.cloud.service.dps.storm.dao.CassandraSubTaskInfoDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ReportService
implements TaskExecutionReportService {
    private CassandraConnectionProvider cassandra;
    private static final int FETCH_ONE = 1;
    private PreparedStatement selectErrorsStatement;
    private PreparedStatement selectErrorStatement;
    private PreparedStatement selectErrorCounterStatement;
    private PreparedStatement checkErrorExistStatement;
    private PreparedStatement checkIfTaskExistsStatement;

    public ReportService(String hosts, int port, String keyspaceName, String userName, String password) {
        this.cassandra = CassandraConnectionProviderSingleton.getCassandraConnectionProvider(hosts, port, keyspaceName, userName, password);
        this.prepareStatements();
    }

    private void prepareStatements() {
        this.selectErrorsStatement = this.cassandra.getSession().prepare("SELECT * FROM error_counters WHERE task_id = ?");
        this.selectErrorsStatement.setConsistencyLevel(this.cassandra.getConsistencyLevel());
        this.selectErrorStatement = this.cassandra.getSession().prepare("SELECT * FROM error_notifications WHERE task_id = ? AND error_type = ? LIMIT ?");
        this.selectErrorStatement.setConsistencyLevel(this.cassandra.getConsistencyLevel());
        this.selectErrorCounterStatement = this.cassandra.getSession().prepare("SELECT * FROM error_counters WHERE task_id = ? AND error_type = ?");
        this.selectErrorCounterStatement.setConsistencyLevel(this.cassandra.getConsistencyLevel());
        this.checkIfTaskExistsStatement = this.cassandra.getSession().prepare("SELECT * FROM task_info WHERE task_id = ?");
        this.checkIfTaskExistsStatement.setConsistencyLevel(this.cassandra.getConsistencyLevel());
        this.checkErrorExistStatement = this.cassandra.getSession().prepare("SELECT * FROM error_counters WHERE task_id = ? LIMIT 1");
        this.checkErrorExistStatement.setConsistencyLevel(this.cassandra.getConsistencyLevel());
    }

    @Override
    public TaskInfo getTaskProgress(String taskId) throws AccessDeniedOrObjectDoesNotExistException {
        long taskIdValue = Long.parseLong(taskId);
        Select.Where selectFromTaskInfo = QueryBuilder.select().all().from("task_info").where(QueryBuilder.eq("task_id", taskIdValue));
        Row taskInfo = this.cassandra.getSession().execute(selectFromTaskInfo).one();
        if (taskInfo != null) {
            return TaskInfoConverter.fromDBRow(taskInfo);
        }
        throw new AccessDeniedOrObjectDoesNotExistException("The task with the provided id doesn't exist!");
    }

    @Override
    public List<SubTaskInfo> getDetailedTaskReport(String taskId, int from, int to) {
        ArrayList<SubTaskInfo> result = new ArrayList<SubTaskInfo>();
        for (int i = CassandraSubTaskInfoDAO.bucketNumber(to); i >= CassandraSubTaskInfoDAO.bucketNumber(from); --i) {
            Select.Where selectFromNotification = QueryBuilder.select().from("notifications").where(QueryBuilder.eq("task_id", Long.parseLong(taskId))).and(QueryBuilder.eq("bucket_number", i)).and(QueryBuilder.gte("resource_num", from)).and(QueryBuilder.lte("resource_num", to));
            ResultSet detailedTaskReportResultSet = this.cassandra.getSession().execute(selectFromNotification);
            result.addAll(this.convertDetailedTaskReportToListOfSubTaskInfo(detailedTaskReportResultSet));
        }
        return result;
    }

    private List<SubTaskInfo> convertDetailedTaskReportToListOfSubTaskInfo(ResultSet data) {
        ArrayList<SubTaskInfo> subTaskInfoList = new ArrayList<SubTaskInfo>();
        for (Row row : data) {
            SubTaskInfo subTaskInfo = new SubTaskInfo(row.getInt("resource_num"), row.getString("resource"), RecordState.valueOf(row.getString("state")), row.getString("info_text"), row.getString("additional_informations"), row.getString("result_resource"));
            subTaskInfoList.add(subTaskInfo);
        }
        return subTaskInfoList;
    }

    @Override
    public TaskErrorsInfo getGeneralTaskErrorReport(String task, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        long taskId = Long.parseLong(task);
        ArrayList<TaskErrorInfo> errors = new ArrayList<TaskErrorInfo>();
        TaskErrorsInfo result = new TaskErrorsInfo(taskId, errors);
        ResultSet rs = this.cassandra.getSession().execute(this.selectErrorsStatement.bind(taskId));
        if (!rs.iterator().hasNext()) {
            return result;
        }
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            String errorType = row.getUUID("error_type").toString();
            String message = this.getErrorMessage(taskId, errorMessages, errorType);
            int occurrences = (int)row.getLong("error_count");
            List<ErrorDetails> errorDetails = this.retrieveErrorDetails(taskId, errorType, idsCount);
            errors.add(new TaskErrorInfo(errorType, message, occurrences, errorDetails));
        }
        return result;
    }

    private List<ErrorDetails> retrieveErrorDetails(long taskId, String errorType, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        ArrayList<ErrorDetails> errorDetails = new ArrayList<ErrorDetails>();
        if (idsCount == 0) {
            return errorDetails;
        }
        ResultSet rs = this.cassandra.getSession().execute(this.selectErrorStatement.bind(taskId, UUID.fromString(errorType), idsCount));
        if (!rs.iterator().hasNext()) {
            throw new AccessDeniedOrObjectDoesNotExistException("Specified task or error type does not exist!");
        }
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            errorDetails.add(new ErrorDetails(row.getString("resource"), row.getString("additional_informations")));
        }
        return errorDetails;
    }

    private String getErrorMessage(long taskId, Map<String, String> errorMessages, String errorType) throws AccessDeniedOrObjectDoesNotExistException {
        String message = errorMessages.get(errorType);
        if (message == null) {
            ResultSet rs = this.cassandra.getSession().execute(this.selectErrorStatement.bind(taskId, UUID.fromString(errorType), 1));
            if (!rs.iterator().hasNext()) {
                throw new AccessDeniedOrObjectDoesNotExistException("Specified task or error type does not exist!");
            }
            message = rs.one().getString("error_message");
            errorMessages.put(errorType, message);
        }
        return message;
    }

    @Override
    public TaskErrorsInfo getSpecificTaskErrorReport(String task, String errorType, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        long taskId = Long.parseLong(task);
        TaskErrorInfo taskErrorInfo = this.getTaskErrorInfo(taskId, errorType);
        taskErrorInfo.setErrorDetails(this.retrieveErrorDetails(taskId, errorType, idsCount));
        String message = this.getErrorMessage(taskId, new HashMap<String, String>(), errorType);
        taskErrorInfo.setMessage(message);
        return new TaskErrorsInfo(taskId, Arrays.asList(taskErrorInfo));
    }

    private TaskErrorInfo getTaskErrorInfo(long taskId, String errorType) throws AccessDeniedOrObjectDoesNotExistException {
        ResultSet rs = this.cassandra.getSession().execute(this.selectErrorCounterStatement.bind(taskId, UUID.fromString(errorType)));
        if (!rs.iterator().hasNext()) {
            throw new AccessDeniedOrObjectDoesNotExistException("Specified task or error type does not exist!");
        }
        TaskErrorInfo taskErrorInfo = new TaskErrorInfo();
        taskErrorInfo.setErrorType(errorType);
        Row row = rs.one();
        taskErrorInfo.setOccurrences((int)row.getLong("error_count"));
        return taskErrorInfo;
    }

    @Override
    public void checkIfTaskExists(String taskId, String topologyName) throws AccessDeniedOrObjectDoesNotExistException {
        Row taskInfo = this.cassandra.getSession().execute(this.checkIfTaskExistsStatement.bind(Long.parseLong(taskId))).one();
        if (taskInfo == null || !taskInfo.getString("topology_name").equals(topologyName)) {
            throw new AccessDeniedOrObjectDoesNotExistException("The specified task does not exist in this service!");
        }
    }

    @Override
    public Boolean checkIfReportExists(String taskId) throws AccessDeniedOrObjectDoesNotExistException {
        ResultSet rs = this.cassandra.getSession().execute(this.checkErrorExistStatement.bind(Long.parseLong(taskId)));
        if (rs.iterator().hasNext()) {
            return true;
        }
        throw new AccessDeniedOrObjectDoesNotExistException("No statistic report");
    }
}

