/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import eu.europeana.cloud.service.dps.storm.utils.BucketRecordIterator;
import eu.europeana.cloud.service.dps.storm.utils.BucketUtils;
import eu.europeana.cloud.service.dps.storm.utils.HarvestedRecord;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;

public class HarvestedRecordsDAO
extends CassandraDAO {
    private static final int MAX_NUMBER_OF_BUCKETS = 64;
    private static final String DB_COMMUNICATION_FAILURE_MESSAGE = "Database communication failure";
    private static HarvestedRecordsDAO instance;
    private PreparedStatement insertHarvestedRecordStatement;
    private PreparedStatement updateLatestHarvestDateStatement;
    private PreparedStatement updateLatestHarvestDateAndMd5Statement;
    private PreparedStatement updatePreviewHarvestDateStatement;
    private PreparedStatement updatePublishedHarvestDateStatement;
    private PreparedStatement findRecordStatement;
    private PreparedStatement findAllRecordInDatasetStatement;
    private PreparedStatement deleteRecordStatement;

    public static synchronized HarvestedRecordsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new HarvestedRecordsDAO(cassandra));
        }
        return instance;
    }

    public HarvestedRecordsDAO() {
    }

    public HarvestedRecordsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    protected void prepareStatements() {
        this.insertHarvestedRecordStatement = this.dbService.getSession().prepare("INSERT INTO harvested_records(metis_dataset_id,bucket_number,record_local_id,latest_harvest_date,latest_harvest_md5,preview_harvest_date,preview_harvest_md5,published_harvest_date,published_harvest_md5) VALUES(?,?,?,?,?,?,?,?,?);");
        this.insertHarvestedRecordStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateLatestHarvestDateStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET latest_harvest_date = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.updateLatestHarvestDateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateLatestHarvestDateAndMd5Statement = this.dbService.getSession().prepare("UPDATE harvested_records SET latest_harvest_date = ? ,latest_harvest_md5 = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.updateLatestHarvestDateAndMd5Statement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updatePreviewHarvestDateStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET preview_harvest_date = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.updatePreviewHarvestDateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updatePublishedHarvestDateStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET published_harvest_date = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.updatePublishedHarvestDateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.findRecordStatement = this.dbService.getSession().prepare("SELECT * FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.findRecordStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.findAllRecordInDatasetStatement = this.dbService.getSession().prepare("SELECT * FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ? ");
        this.findAllRecordInDatasetStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteRecordStatement = this.dbService.getSession().prepare("DELETE FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.deleteRecordStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    @Retryable(maxAttempts=7)
    public void insertHarvestedRecord(HarvestedRecord harvestedRecord) {
        this.dbService.getSession().execute(this.prepareInsertStatement(harvestedRecord));
    }

    public BoundStatement prepareInsertStatement(HarvestedRecord harvestedRecord) {
        return this.insertHarvestedRecordStatement.bind(harvestedRecord.getMetisDatasetId(), this.bucketNoFor(harvestedRecord.getRecordLocalId()), harvestedRecord.getRecordLocalId(), harvestedRecord.getLatestHarvestDate(), harvestedRecord.getLatestHarvestMd5(), harvestedRecord.getPreviewHarvestDate(), harvestedRecord.getPreviewHarvestMd5(), harvestedRecord.getPublishedHarvestDate(), harvestedRecord.getPublishedHarvestMd5());
    }

    @Retryable(maxAttempts=7)
    public void updateLatestHarvestDate(String metisDatasetId, String recordId, Date harvestDate) {
        this.dbService.getSession().execute(this.updateLatestHarvestDateStatement.bind(harvestDate, metisDatasetId, this.bucketNoFor(recordId), recordId));
    }

    @Retryable(maxAttempts=7)
    public void updateLatestHarvestDateAndMd5(String metisDatasetId, String recordId, Date harvestDate, UUID harvestMd5) {
        this.dbService.getSession().execute(this.updateLatestHarvestDateAndMd5Statement.bind(harvestDate, harvestMd5, metisDatasetId, this.bucketNoFor(recordId), recordId));
    }

    @Retryable(maxAttempts=7)
    public void updatePreviewHarvestDate(String metisDatasetId, String recordId, Date indexingDate) {
        this.dbService.getSession().execute(this.updatePreviewHarvestDateStatement.bind(indexingDate, metisDatasetId, this.bucketNoFor(recordId), recordId));
    }

    @Retryable(maxAttempts=7)
    public void updatePublishedHarvestDate(String metisDatasetId, String recordId, Date indexingDate) {
        this.dbService.getSession().execute(this.updatePublishedHarvestDateStatement.bind(indexingDate, metisDatasetId, this.bucketNoFor(recordId), recordId));
    }

    @Retryable(maxAttempts=7)
    public void deleteRecord(String metisDatasetId, String recordId) {
        this.dbService.getSession().execute(this.deleteRecordStatement.bind(metisDatasetId, this.bucketNoFor(recordId), recordId));
    }

    @Retryable(maxAttempts=7)
    public Optional<HarvestedRecord> findRecord(String metisDatasetId, String recordId) {
        return Optional.ofNullable(this.dbService.getSession().execute(this.findRecordStatement.bind(metisDatasetId, this.bucketNoFor(recordId), recordId)).one()).map(HarvestedRecord::from);
    }

    public Iterator<HarvestedRecord> findDatasetRecords(String metisDatasetId) {
        return new BucketRecordIterator<HarvestedRecord>(64, bucketNumber -> this.queryBucket(metisDatasetId, bucketNumber), HarvestedRecord::from);
    }

    private Iterator<Row> queryBucket(String metisDatasetId, Integer bucketNumber) {
        return RetryableMethodExecutor.execute(DB_COMMUNICATION_FAILURE_MESSAGE, 7, 10000, () -> this.dbService.getSession().execute(this.findAllRecordInDatasetStatement.bind(metisDatasetId, bucketNumber)).iterator());
    }

    private int bucketNoFor(String recordId) {
        return BucketUtils.bucketNumber(recordId, 64);
    }
}

