/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.collect.Iterators;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;

@Retryable(maxAttempts=7)
public class CassandraTaskErrorsDAO
extends CassandraDAO {
    private PreparedStatement insertErrorStatement;
    private PreparedStatement updateErrorCounterStatement;
    private PreparedStatement selectErrorCountsStatement;
    private PreparedStatement selectErrorCountsForErrorTypeStatement;
    private PreparedStatement removeErrorCountsStatement;
    private PreparedStatement removeErrorNotifications;
    private PreparedStatement selectErrorTypeStatement;
    private PreparedStatement selectErrorsStatement;
    private static CassandraTaskErrorsDAO instance = null;
    private PreparedStatement selectErrorStatement;

    public static synchronized CassandraTaskErrorsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new CassandraTaskErrorsDAO(cassandra));
        }
        return instance;
    }

    public CassandraTaskErrorsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraTaskErrorsDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.insertErrorStatement = this.dbService.getSession().prepare("INSERT INTO error_notifications(task_id,error_type,error_message,resource,additional_informations) VALUES (?,?,?,?,?)");
        this.insertErrorStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateErrorCounterStatement = this.dbService.getSession().prepare("UPDATE error_counters SET error_count = error_count + 1 WHERE task_id = ? AND error_type = ?");
        this.updateErrorCounterStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorCountsStatement = this.dbService.getSession().prepare("SELECT error_count FROM error_counters WHERE task_id = ? ");
        this.selectErrorCountsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorCountsForErrorTypeStatement = this.dbService.getSession().prepare("SELECT error_count FROM error_counters WHERE task_id = ? AND error_type = ?");
        this.selectErrorCountsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorTypeStatement = this.dbService.getSession().prepare("SELECT error_type FROM error_counters WHERE task_id = ? ");
        this.selectErrorTypeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorsStatement = this.dbService.getSession().prepare("SELECT * FROM error_counters WHERE task_id = ?");
        this.selectErrorsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorStatement = this.dbService.getSession().prepare("SELECT * FROM error_notifications WHERE task_id = ? AND error_type = ? LIMIT 1");
        this.selectErrorStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeErrorCountsStatement = this.dbService.getSession().prepare("DELETE  FROM error_counters WHERE task_id = ? ");
        this.removeErrorCountsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeErrorNotifications = this.dbService.getSession().prepare("DELETE  FROM error_notifications WHERE task_id = ? and error_type = ?");
        this.removeErrorNotifications.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void updateErrorCounter(long taskId, String errorType) {
        this.dbService.getSession().execute(this.updateErrorCounterStatement.bind(taskId, UUID.fromString(errorType)));
    }

    public void insertError(long taskId, String errorType, String errorMessage, String resource, String additionalInformations) {
        this.dbService.getSession().execute(this.insertErrorStatement.bind(taskId, UUID.fromString(errorType), errorMessage, resource, additionalInformations));
    }

    public int getErrorCount(long taskId) {
        ResultSet rs = this.dbService.getSession().execute(this.selectErrorCountsStatement.bind(taskId));
        int count = 0;
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            count = (int)((long)count + row.getLong("error_count"));
        }
        return count;
    }

    public long selectErrorCountsForErrorType(long taskId, UUID errorType) {
        ResultSet rs = this.dbService.getSession().execute(this.selectErrorCountsForErrorTypeStatement.bind(taskId, errorType));
        Row result = rs.one();
        if (result != null) {
            return result.getLong("error_count");
        }
        return 0L;
    }

    public Iterator<String> getMessagesUuids(long taskId) {
        return Iterators.transform(this.dbService.getSession().execute(this.selectErrorsStatement.bind(taskId)).iterator(), row -> row.getUUID("error_type").toString());
    }

    public Optional<String> getErrorMessage(long taskId, String errorType) {
        ResultSet rs = this.dbService.getSession().execute(this.selectErrorStatement.bind(taskId, UUID.fromString(errorType)));
        if (!rs.iterator().hasNext()) {
            return Optional.empty();
        }
        String message = rs.one().getString("error_message");
        return Optional.of(message);
    }

    public void removeErrors(long taskId) {
        ResultSet rs = this.dbService.getSession().execute(this.selectErrorTypeStatement.bind(taskId));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            UUID errorType = row.getUUID("error_type");
            this.dbService.getSession().execute(this.removeErrorNotifications.bind(taskId, errorType));
        }
        this.dbService.getSession().execute(this.removeErrorCountsStatement.bind(taskId));
    }
}

