/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.Set;
import java.util.stream.Collectors;

@Retryable(maxAttempts=7)
public class CassandraAttributeStatisticsDAO
extends CassandraDAO {
    private static CassandraAttributeStatisticsDAO instance = null;
    private PreparedStatement updateAttributeStatement;
    private PreparedStatement selectAttributesStatement;
    private PreparedStatement deleteAttributesStatement;
    private PreparedStatement countDistinctAttributeValues;
    private PreparedStatement countSpecificAttributeValue;

    public static synchronized CassandraAttributeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = RetryableMethodExecutor.createRetryProxy(new CassandraAttributeStatisticsDAO(cassandra));
        }
        return instance;
    }

    public CassandraAttributeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraAttributeStatisticsDAO() {
    }

    @Override
    protected void prepareStatements() {
        this.updateAttributeStatement = this.dbService.getSession().prepare("UPDATE attribute_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ? AND attribute_value = ?");
        this.updateAttributeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectAttributesStatement = this.dbService.getSession().prepare("SELECT * FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? LIMIT ?");
        this.selectAttributesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteAttributesStatement = this.dbService.getSession().prepare("DELETE FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ?");
        this.deleteAttributesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.countDistinctAttributeValues = this.dbService.getSession().prepare("SELECT count(*) FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ?");
        this.countDistinctAttributeValues.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.countSpecificAttributeValue = this.dbService.getSession().prepare("SELECT count(*) FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ? AND attribute_value = ?");
        this.countSpecificAttributeValue.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public long getAttributeDistinctValues(long taskId, String nodePath, String nodeValue, String attributeName) {
        ResultSet rs = this.dbService.getSession().execute(this.countDistinctAttributeValues.bind(taskId, nodePath, nodeValue, attributeName));
        return rs.one().getLong(0);
    }

    public long getSpecificAttributeValueCount(long taskId, String nodePath, String nodeValue, String attributeName, String attributeValue) {
        ResultSet rs = this.dbService.getSession().execute(this.countSpecificAttributeValue.bind(taskId, nodePath, nodeValue, attributeName, attributeValue));
        return rs.one().getLong(0);
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, AttributeStatistics attributeStatistics) {
        this.dbService.getSession().execute(this.updateAttributeStatement.bind(attributeStatistics.getOccurrence(), taskId, nodeXpath, nodeValue, attributeStatistics.getName(), attributeStatistics.getValue()));
    }

    public Set<AttributeStatistics> getAttributeStatistics(long taskId, String nodeXpath, String nodeValue, int limit) {
        return this.dbService.getSession().execute(this.selectAttributesStatement.bind(taskId, nodeXpath, nodeValue, limit)).all().stream().map(this::createAttributeStatistics).collect(Collectors.toSet());
    }

    private AttributeStatistics createAttributeStatistics(Row row) {
        return new AttributeStatistics(row.getString("attribute_name"), row.getString("attribute_value"), row.getLong("occurrence"));
    }

    public void removeAttributeStatistics(long taskId, String nodeXpath, String nodeValue) {
        BoundStatement bs = this.deleteAttributesStatement.bind(taskId, nodeXpath, nodeValue);
        this.dbService.getSession().execute(bs);
    }
}

