/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.kafka;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.TaskExecutionSubmitService;
import eu.europeana.cloud.service.dps.service.kafka.util.DpsTaskSerializer;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class TaskKafkaSubmitService
implements TaskExecutionSubmitService {
    private Producer<String, DpsTask> producer;

    public TaskKafkaSubmitService(String kafkaBroker) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", kafkaBroker);
        properties.put("value.serializer", DpsTaskSerializer.class.getName());
        properties.put("key.serializer", StringSerializer.class.getName());
        properties.put("acks", "1");
        this.producer = new KafkaProducer<String, DpsTask>(properties);
    }

    @Override
    public void submitTask(DpsTask task, String topology) {
        ProducerRecord<String, DpsTask> data = new ProducerRecord<String, DpsTask>(topology, String.valueOf(task.getTaskId()), task);
        this.producer.send(data);
    }
}

