/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.metis.indexing;

import com.google.common.base.Objects;
import eu.europeana.cloud.common.utils.DateAdapter;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataSetCleanerParameters
implements Serializable {
    private static final long serialVersionUID = 123456789L;
    private String dataSetId;
    private boolean usingAltEnv;
    private String targetIndexingEnv;
    @XmlElement(name="cleaningDate", required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date cleaningDate;

    public DataSetCleanerParameters(String dataSetId, boolean usingAltEnv, String targetIndexingEnv, Date cleaningDate) {
        this.dataSetId = dataSetId;
        this.usingAltEnv = usingAltEnv;
        this.targetIndexingEnv = targetIndexingEnv;
        this.cleaningDate = cleaningDate;
    }

    public DataSetCleanerParameters() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSetCleanerParameters)) {
            return false;
        }
        DataSetCleanerParameters cleanerParameters = (DataSetCleanerParameters)o;
        return Objects.equal(this.dataSetId, cleanerParameters.dataSetId) && this.usingAltEnv == cleanerParameters.usingAltEnv && Objects.equal(this.targetIndexingEnv, cleanerParameters.targetIndexingEnv) && Objects.equal(this.cleaningDate, cleanerParameters.cleaningDate);
    }

    public int hashCode() {
        return Objects.hashCode(this.dataSetId, this.usingAltEnv, this.targetIndexingEnv, this.cleaningDate);
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public boolean isUsingAltEnv() {
        return this.usingAltEnv;
    }

    public String getTargetIndexingEnv() {
        return this.targetIndexingEnv;
    }

    public Date getCleaningDate() {
        return this.cleaningDate;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public void setUsingAltEnv(boolean usingAltEnv) {
        this.usingAltEnv = usingAltEnv;
    }

    public void setTargetIndexingEnv(String targetIndexingEnv) {
        this.targetIndexingEnv = targetIndexingEnv;
    }

    public void setCleaningDate(Date cleaningDate) {
        this.cleaningDate = cleaningDate;
    }

    public String toString() {
        return "DataSetCleanerParameters(dataSetId=" + this.getDataSetId() + ", usingAltEnv=" + this.isUsingAltEnv() + ", targetIndexingEnv=" + this.getTargetIndexingEnv() + ", cleaningDate=" + this.getCleaningDate() + ")";
    }
}

