/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.persisted;

import eu.europeana.cloud.api.Remover;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.cassandra.CassandraConnectionProviderSingleton;
import eu.europeana.cloud.service.dps.storm.dao.CassandraSubTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskErrorsDAO;
import eu.europeana.cloud.service.dps.storm.service.ValidationStatisticsServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoverImpl
implements Remover {
    static final Logger LOGGER = LoggerFactory.getLogger(RemoverImpl.class);
    private final CassandraSubTaskInfoDAO subTaskInfoDAO;
    private final CassandraTaskErrorsDAO taskErrorDAO;
    private final ValidationStatisticsServiceImpl statisticsService;
    private static final int DEFAULT_RETRIES = 5;
    private static final int SLEEP_TIME = 3000;

    public RemoverImpl(String hosts, int port, String keyspaceName, String userName, String password) {
        CassandraConnectionProvider cassandraConnectionProvider = CassandraConnectionProviderSingleton.getCassandraConnectionProvider(hosts, port, keyspaceName, userName, password);
        this.subTaskInfoDAO = CassandraSubTaskInfoDAO.getInstance(cassandraConnectionProvider);
        this.taskErrorDAO = CassandraTaskErrorsDAO.getInstance(cassandraConnectionProvider);
        this.statisticsService = ValidationStatisticsServiceImpl.getInstance(cassandraConnectionProvider);
    }

    RemoverImpl(CassandraSubTaskInfoDAO subTaskInfoDAO, CassandraTaskErrorsDAO taskErrorDAO, ValidationStatisticsServiceImpl statisticsService) {
        this.subTaskInfoDAO = subTaskInfoDAO;
        this.taskErrorDAO = taskErrorDAO;
        this.statisticsService = statisticsService;
    }

    @Override
    public void removeNotifications(long taskId) {
        int retries = 5;
        while (true) {
            try {
                this.subTaskInfoDAO.removeNotifications(taskId);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while removing the logs. Retries left: {}", (Object)retries);
                    this.waitForTheNextCall();
                    continue;
                }
                LOGGER.error("Error while removing the logs.");
                throw e;
            }
            break;
        }
    }

    @Override
    public void removeErrorReports(long taskId) {
        int retries = 5;
        while (true) {
            try {
                this.taskErrorDAO.removeErrors(taskId);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while removing the error reports. Retries left: {}", (Object)retries);
                    this.waitForTheNextCall();
                    continue;
                }
                LOGGER.error("Error while removing the error reports.");
                throw e;
            }
            break;
        }
    }

    @Override
    public void removeStatistics(long taskId) {
        int retries = 5;
        while (true) {
            try {
                this.statisticsService.removeStatistics(taskId);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while removing the validation statistics. Retries left: {}", (Object)retries);
                    this.waitForTheNextCall();
                    continue;
                }
                LOGGER.error("Error while removing the validation statistics.");
                throw e;
            }
            break;
        }
    }

    private void waitForTheNextCall() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            LOGGER.error(e1.getMessage());
        }
    }
}

