/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class RevisionServiceClient
extends MCSClient {
    private final Client client;

    public RevisionServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).build();
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public RevisionServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, username, password, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build())).build();
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String tag) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}/tag/{tag}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).resolveTemplate("tag", tag);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            URI uRI = this.handleAddRevisionResponse(response);
            return uRI;
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, Revision revision) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.accept("application/json").post(Entity.json(revision));
            URI uRI = this.handleAddRevisionResponse(response);
            this.closeResponse(response);
            return uRI;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, Revision revision, String key, String value) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version);
        Invocation.Builder request = target.request().header(key, value);
        Response response = null;
        try {
            response = request.accept("application/json").post(Entity.json(revision));
            URI uRI = this.handleAddRevisionResponse(response);
            this.closeResponse(response);
            return uRI;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, Set<Tags> tags) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}/tags").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId);
        Form tagsForm = new Form();
        for (Tags tag : tags) {
            tagsForm.param("tags", tag.getTag());
        }
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(Entity.form(tagsForm));
            URI uRI = this.handleAddRevisionResponse(response);
            return uRI;
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String revisionTimestamp, String key, String value) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp);
        Invocation.Builder request = target.request().header(key, value);
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public void close() {
        this.client.close();
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private URI handleAddRevisionResponse(Response response) throws MCSException {
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }
}

