/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class DataSetServiceClient
extends MCSClient {
    private final Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).build();

    public DataSetServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public DataSetServiceClient(String baseUrl, String authorization) {
        this(baseUrl, authorization, null, null, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register(new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public ResultSlice<DataSet> getDataSetsForProviderChunk(String providerId, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", providerId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", startFrom);
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<DataSet> getDataSetsForProvider(String providerId) throws MCSException {
        ResultSlice<DataSet> resultSlice;
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetsForProviderChunk(providerId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public DataSetIterator getDataSetIteratorForProvider(String providerId) {
        return new DataSetIterator(this, providerId);
    }

    public URI createDataSet(String providerId, String dataSetId, String description) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", providerId);
        Form form = new Form();
        form.param("dataSetId", dataSetId);
        form.param("description", description);
        try (Response response = null;){
            response = target.request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public ResultSlice<Representation> getDataSetRepresentationsChunk(String providerId, String dataSetId, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", startFrom);
        }
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<Representation> getDataSetRepresentations(String providerId, String dataSetId) throws MCSException {
        ResultSlice<Representation> resultSlice;
        ArrayList<Representation> resultList = new ArrayList<Representation>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRepresentationsChunk(providerId, dataSetId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public RepresentationIterator getRepresentationIterator(String providerId, String dataSetId) {
        return new RepresentationIterator(this, providerId, dataSetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDescriptionOfDataSet(String providerId, String dataSetId, String description) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId);
        Form form = new Form();
        form.param("description", description);
        try (Response response = null;){
            response = target.request().put(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataSet(String providerId, String dataSetId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId);
        try (Response response = null;){
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId);
        Form form = this.getForm(cloudId, representationName, version);
        try (Response response = null;){
            response = target.request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    private Form getForm(String cloudId, String representationName, String version) {
        Form form = new Form();
        form.param("cloudId", cloudId);
        form.param("representationName", representationName);
        form.param("version", version);
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version, String key, String value) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId);
        Form form = this.getForm(cloudId, representationName, version);
        try (Response response = null;){
            response = target.request().header(key, value).post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassignRepresentationFromDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).queryParam("cloudId", cloudId).queryParam("representationName", representationName).queryParam("version", version);
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<CloudTagsResponse> getRevisionsWithDeletedFlagSetToFalse(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, int limit) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp).queryParam("existingOnly", true).queryParam("limit", limit);
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List<CloudTagsResponse> list = response.readEntity(ResultSlice.class).getResults();
                return list;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisionsChunk(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, String startFrom, Integer limit) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("providerId", providerId).resolveTemplate("dataSetId", dataSetId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revisionName).resolveTemplate("revisionProviderId", revisionProviderId).queryParam("revisionTimestamp", revisionTimestamp).queryParam("startFrom", startFrom);
        target = target.queryParam("limit", limit != null ? limit : 0);
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<CloudTagsResponse> getDataSetRevisions(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        ResultSlice<CloudTagsResponse> resultSlice;
        ArrayList<CloudTagsResponse> resultList = new ArrayList<CloudTagsResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRevisionsChunk(providerId, dataSetId, representationName, revisionName, revisionProviderId, revisionTimestamp, startFrom, null)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    public void close() {
        this.client.close();
    }

    private ResultSlice prepareResultSliceResponse(WebTarget target) throws MCSException {
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }
}

