/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import com.github.f4b6a3.uuid.util.internal.immutable.CharArray;
import com.github.f4b6a3.uuid.util.internal.immutable.LongArray;
import java.util.UUID;

public class StringCodec
implements UuidCodec<String> {
    public static final StringCodec INSTANCE = new StringCodec();
    private static final CharArray ALPHABET = BaseN.BASE_16.getAlphabet();
    private static final LongArray MAP = BaseN.BASE_16.getMap();
    private static final String URN_PREFIX = "urn:uuid:";
    private static final boolean JAVA_VERSION_GREATER_THAN_8 = StringCodec.getJavaVersion() > 8;

    @Override
    public String encode(UUID uuid) {
        if (JAVA_VERSION_GREATER_THAN_8) {
            return uuid.toString();
        }
        char[] chars = new char[36];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        chars[0] = ALPHABET.get((int)(msb >>> 60 & 0xFL));
        chars[1] = ALPHABET.get((int)(msb >>> 56 & 0xFL));
        chars[2] = ALPHABET.get((int)(msb >>> 52 & 0xFL));
        chars[3] = ALPHABET.get((int)(msb >>> 48 & 0xFL));
        chars[4] = ALPHABET.get((int)(msb >>> 44 & 0xFL));
        chars[5] = ALPHABET.get((int)(msb >>> 40 & 0xFL));
        chars[6] = ALPHABET.get((int)(msb >>> 36 & 0xFL));
        chars[7] = ALPHABET.get((int)(msb >>> 32 & 0xFL));
        chars[8] = 45;
        chars[9] = ALPHABET.get((int)(msb >>> 28 & 0xFL));
        chars[10] = ALPHABET.get((int)(msb >>> 24 & 0xFL));
        chars[11] = ALPHABET.get((int)(msb >>> 20 & 0xFL));
        chars[12] = ALPHABET.get((int)(msb >>> 16 & 0xFL));
        chars[13] = 45;
        chars[14] = ALPHABET.get((int)(msb >>> 12 & 0xFL));
        chars[15] = ALPHABET.get((int)(msb >>> 8 & 0xFL));
        chars[16] = ALPHABET.get((int)(msb >>> 4 & 0xFL));
        chars[17] = ALPHABET.get((int)(msb & 0xFL));
        chars[18] = 45;
        chars[19] = ALPHABET.get((int)(lsb >>> 60 & 0xFL));
        chars[20] = ALPHABET.get((int)(lsb >>> 56 & 0xFL));
        chars[21] = ALPHABET.get((int)(lsb >>> 52 & 0xFL));
        chars[22] = ALPHABET.get((int)(lsb >>> 48 & 0xFL));
        chars[23] = 45;
        chars[24] = ALPHABET.get((int)(lsb >>> 44 & 0xFL));
        chars[25] = ALPHABET.get((int)(lsb >>> 40 & 0xFL));
        chars[26] = ALPHABET.get((int)(lsb >>> 36 & 0xFL));
        chars[27] = ALPHABET.get((int)(lsb >>> 32 & 0xFL));
        chars[28] = ALPHABET.get((int)(lsb >>> 28 & 0xFL));
        chars[29] = ALPHABET.get((int)(lsb >>> 24 & 0xFL));
        chars[30] = ALPHABET.get((int)(lsb >>> 20 & 0xFL));
        chars[31] = ALPHABET.get((int)(lsb >>> 16 & 0xFL));
        chars[32] = ALPHABET.get((int)(lsb >>> 12 & 0xFL));
        chars[33] = ALPHABET.get((int)(lsb >>> 8 & 0xFL));
        chars[34] = ALPHABET.get((int)(lsb >>> 4 & 0xFL));
        chars[35] = ALPHABET.get((int)(lsb & 0xFL));
        return new String(chars);
    }

    @Override
    public UUID decode(String string) {
        if (string == null) {
            throw new InvalidUuidException("Invalid UUID: null");
        }
        char[] chars = string.toCharArray();
        if (chars.length != 32 && chars.length != 36) {
            char[] substring;
            if (string.startsWith(URN_PREFIX)) {
                substring = new char[chars.length - 9];
                System.arraycopy(chars, 9, substring, 0, substring.length);
                chars = substring;
            } else if (chars.length > 0 && chars[0] == '{' && chars[chars.length - 1] == '}') {
                substring = new char[chars.length - 2];
                System.arraycopy(chars, 1, substring, 0, substring.length);
                chars = substring;
            }
        }
        UuidValidator.validate(chars);
        long msb = 0L;
        long lsb = 0L;
        if (chars.length == 32) {
            msb |= MAP.get(chars[0]) << 60;
            msb |= MAP.get(chars[1]) << 56;
            msb |= MAP.get(chars[2]) << 52;
            msb |= MAP.get(chars[3]) << 48;
            msb |= MAP.get(chars[4]) << 44;
            msb |= MAP.get(chars[5]) << 40;
            msb |= MAP.get(chars[6]) << 36;
            msb |= MAP.get(chars[7]) << 32;
            msb |= MAP.get(chars[8]) << 28;
            msb |= MAP.get(chars[9]) << 24;
            msb |= MAP.get(chars[10]) << 20;
            msb |= MAP.get(chars[11]) << 16;
            msb |= MAP.get(chars[12]) << 12;
            msb |= MAP.get(chars[13]) << 8;
            msb |= MAP.get(chars[14]) << 4;
            msb |= MAP.get(chars[15]);
            lsb |= MAP.get(chars[16]) << 60;
            lsb |= MAP.get(chars[17]) << 56;
            lsb |= MAP.get(chars[18]) << 52;
            lsb |= MAP.get(chars[19]) << 48;
            lsb |= MAP.get(chars[20]) << 44;
            lsb |= MAP.get(chars[21]) << 40;
            lsb |= MAP.get(chars[22]) << 36;
            lsb |= MAP.get(chars[23]) << 32;
            lsb |= MAP.get(chars[24]) << 28;
            lsb |= MAP.get(chars[25]) << 24;
            lsb |= MAP.get(chars[26]) << 20;
            lsb |= MAP.get(chars[27]) << 16;
            lsb |= MAP.get(chars[28]) << 12;
            lsb |= MAP.get(chars[29]) << 8;
            lsb |= MAP.get(chars[30]) << 4;
            lsb |= MAP.get(chars[31]);
        } else {
            msb |= MAP.get(chars[0]) << 60;
            msb |= MAP.get(chars[1]) << 56;
            msb |= MAP.get(chars[2]) << 52;
            msb |= MAP.get(chars[3]) << 48;
            msb |= MAP.get(chars[4]) << 44;
            msb |= MAP.get(chars[5]) << 40;
            msb |= MAP.get(chars[6]) << 36;
            msb |= MAP.get(chars[7]) << 32;
            msb |= MAP.get(chars[9]) << 28;
            msb |= MAP.get(chars[10]) << 24;
            msb |= MAP.get(chars[11]) << 20;
            msb |= MAP.get(chars[12]) << 16;
            msb |= MAP.get(chars[14]) << 12;
            msb |= MAP.get(chars[15]) << 8;
            msb |= MAP.get(chars[16]) << 4;
            msb |= MAP.get(chars[17]);
            lsb |= MAP.get(chars[19]) << 60;
            lsb |= MAP.get(chars[20]) << 56;
            lsb |= MAP.get(chars[21]) << 52;
            lsb |= MAP.get(chars[22]) << 48;
            lsb |= MAP.get(chars[24]) << 44;
            lsb |= MAP.get(chars[25]) << 40;
            lsb |= MAP.get(chars[26]) << 36;
            lsb |= MAP.get(chars[27]) << 32;
            lsb |= MAP.get(chars[28]) << 28;
            lsb |= MAP.get(chars[29]) << 24;
            lsb |= MAP.get(chars[30]) << 20;
            lsb |= MAP.get(chars[31]) << 16;
            lsb |= MAP.get(chars[32]) << 12;
            lsb |= MAP.get(chars[33]) << 8;
            lsb |= MAP.get(chars[34]) << 4;
            lsb |= MAP.get(chars[35]);
        }
        return new UUID(msb, lsb);
    }

    protected static int getJavaVersion() {
        try {
            String[] version = System.getProperty("java.version").split("\\.");
            if (version[0].equals("1")) {
                return Integer.parseInt(version[1]);
            }
            return Integer.parseInt(version[0]);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            return 8;
        }
    }
}

