/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.creator.nonstandard.PrefixCombCreator;
import com.github.f4b6a3.uuid.creator.nonstandard.ShortPrefixCombCreator;
import com.github.f4b6a3.uuid.creator.nonstandard.ShortSuffixCombCreator;
import com.github.f4b6a3.uuid.creator.nonstandard.SuffixCombCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.DceSecurityUuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.NameBasedMd5UuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.NameBasedSha1UuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.RandomBasedUuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.TimeOrderedUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import java.time.Instant;
import java.util.UUID;

public final class UuidCreator {
    public static final UuidNamespace NAMESPACE_DNS = UuidNamespace.NAMESPACE_DNS;
    public static final UuidNamespace NAMESPACE_URL = UuidNamespace.NAMESPACE_URL;
    public static final UuidNamespace NAMESPACE_ISO_OID = UuidNamespace.NAMESPACE_ISO_OID;
    public static final UuidNamespace NAMESPACE_X500_DN = UuidNamespace.NAMESPACE_X500_DN;
    public static final UuidLocalDomain LOCAL_DOMAIN_PERSON = UuidLocalDomain.LOCAL_DOMAIN_PERSON;
    public static final UuidLocalDomain LOCAL_DOMAIN_GROUP = UuidLocalDomain.LOCAL_DOMAIN_GROUP;
    public static final UuidLocalDomain LOCAL_DOMAIN_ORG = UuidLocalDomain.LOCAL_DOMAIN_ORG;
    private static final UUID UUID_NIL = new UUID(0L, 0L);

    private UuidCreator() {
    }

    public static byte[] toBytes(UUID uuid) {
        return BinaryCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromBytes(byte[] uuid) {
        return BinaryCodec.INSTANCE.decode(uuid);
    }

    public static String toString(UUID uuid) {
        return StringCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromString(String uuid) {
        return StringCodec.INSTANCE.decode(uuid);
    }

    public static UUID getNil() {
        return UUID_NIL;
    }

    public static UUID getRandomBased() {
        return RandomCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeBased() {
        return TimeBasedCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithMac() {
        return TimeBasedWithMacCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithHash() {
        return TimeBasedWithHashCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithRandom() {
        return TimeBasedWithRandomCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeBased(Instant instant, Integer clockseq, Long nodeid) {
        return TimeBasedCreatorHolder.INSTANCE.create(instant, clockseq, nodeid);
    }

    public static UUID getTimeBasedWithMac(Instant instant, Integer clockseq) {
        return TimeBasedWithMacCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getTimeBasedWithHash(Instant instant, Integer clockseq) {
        return TimeBasedWithHashCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getTimeBasedWithRandom(Instant instant, Integer clockseq) {
        return TimeBasedWithRandomCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getTimeOrdered() {
        return TimeOrderedCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithMac() {
        return TimeOrderedWithMacCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithHash() {
        return TimeOrderedWithHashCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithRandom() {
        return TimeOrderedWithRandomCreatorHolder.INSTANCE.create();
    }

    public static UUID getTimeOrdered(Instant instant, Integer clockseq, Long nodeid) {
        return TimeOrderedCreatorHolder.INSTANCE.create(instant, clockseq, nodeid);
    }

    public static UUID getTimeOrderedWithMac(Instant instant, Integer clockseq) {
        return TimeOrderedWithMacCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getTimeOrderedWithHash(Instant instant, Integer clockseq) {
        return TimeOrderedWithHashCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getTimeOrderedWithRandom(Instant instant, Integer clockseq) {
        return TimeOrderedWithRandomCreatorHolder.INSTANCE.create(instant, clockseq, null);
    }

    public static UUID getNameBasedMd5(String name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(byte[] name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(UUID namespace, String name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UUID namespace, byte[] name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(String namespace, String name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(String namespace, byte[] name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, String name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, byte[] name) {
        return NameBasedMd5CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(byte[] name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(UUID namespace, String name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UUID namespace, byte[] name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String namespace, String name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String namespace, byte[] name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, String name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, byte[] name) {
        return NameBasedSha1CreatorHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        return DceSecurityCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        return DceSecurityWithMacCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithHash(byte localDomain, int localIdentifier) {
        return DceSecurityWithHashCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithRandom(byte localDomain, int localIdentifier) {
        return DceSecurityWithRandomCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurity(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithMacCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithHash(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithHashCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithRandom(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithRandomCreatorHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getPrefixComb() {
        return PrefixCombCreatorHolder.INSTANCE.create();
    }

    public static UUID getSuffixComb() {
        return SuffixCombCreatorHolder.INSTANCE.create();
    }

    public static UUID getShortPrefixComb() {
        return ShortPrefixCombCreatorHolder.INSTANCE.create();
    }

    public static UUID getShortSuffixComb() {
        return ShortSuffixCombCreatorHolder.INSTANCE.create();
    }

    public static RandomBasedUuidCreator getRandomBasedCreator() {
        return new RandomBasedUuidCreator();
    }

    public static TimeBasedUuidCreator getTimeBasedCreator() {
        return new TimeBasedUuidCreator();
    }

    public static TimeOrderedUuidCreator getTimeOrderedCreator() {
        return new TimeOrderedUuidCreator();
    }

    public static NameBasedMd5UuidCreator getNameBasedMd5Creator() {
        return new NameBasedMd5UuidCreator();
    }

    public static NameBasedSha1UuidCreator getNameBasedSha1Creator() {
        return new NameBasedSha1UuidCreator();
    }

    public static DceSecurityUuidCreator getDceSecurityCreator() {
        return new DceSecurityUuidCreator();
    }

    public static SuffixCombCreator getSuffixCombCreator() {
        return new SuffixCombCreator();
    }

    public static PrefixCombCreator getPrefixCombCreator() {
        return new PrefixCombCreator();
    }

    public static ShortPrefixCombCreator getShortPrefixCombCreator() {
        return new ShortPrefixCombCreator();
    }

    public static ShortSuffixCombCreator getShortSuffixCombCreator() {
        return new ShortSuffixCombCreator();
    }

    private static class ShortSuffixCombCreatorHolder {
        static final ShortSuffixCombCreator INSTANCE = UuidCreator.getShortSuffixCombCreator();

        private ShortSuffixCombCreatorHolder() {
        }
    }

    private static class ShortPrefixCombCreatorHolder {
        static final ShortPrefixCombCreator INSTANCE = UuidCreator.getShortPrefixCombCreator();

        private ShortPrefixCombCreatorHolder() {
        }
    }

    private static class PrefixCombCreatorHolder {
        static final PrefixCombCreator INSTANCE = UuidCreator.getPrefixCombCreator();

        private PrefixCombCreatorHolder() {
        }
    }

    private static class SuffixCombCreatorHolder {
        static final SuffixCombCreator INSTANCE = UuidCreator.getSuffixCombCreator();

        private SuffixCombCreatorHolder() {
        }
    }

    private static class DceSecurityWithRandomCreatorHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withRandomNodeIdentifier();

        private DceSecurityWithRandomCreatorHolder() {
        }
    }

    private static class DceSecurityWithHashCreatorHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withHashNodeIdentifier();

        private DceSecurityWithHashCreatorHolder() {
        }
    }

    private static class DceSecurityWithMacCreatorHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withMacNodeIdentifier();

        private DceSecurityWithMacCreatorHolder() {
        }
    }

    private static class DceSecurityCreatorHolder {
        static final DceSecurityUuidCreator INSTANCE = UuidCreator.getDceSecurityCreator();

        private DceSecurityCreatorHolder() {
        }
    }

    private static class NameBasedSha1CreatorHolder {
        static final NameBasedSha1UuidCreator INSTANCE = UuidCreator.getNameBasedSha1Creator();

        private NameBasedSha1CreatorHolder() {
        }
    }

    private static class NameBasedMd5CreatorHolder {
        static final NameBasedMd5UuidCreator INSTANCE = UuidCreator.getNameBasedMd5Creator();

        private NameBasedMd5CreatorHolder() {
        }
    }

    private static class TimeBasedWithRandomCreatorHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withRandomNodeIdentifier();

        private TimeBasedWithRandomCreatorHolder() {
        }
    }

    private static class TimeBasedWithHashCreatorHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withHashNodeIdentifier();

        private TimeBasedWithHashCreatorHolder() {
        }
    }

    private static class TimeBasedWithMacCreatorHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withMacNodeIdentifier();

        private TimeBasedWithMacCreatorHolder() {
        }
    }

    private static class TimeBasedCreatorHolder {
        static final TimeBasedUuidCreator INSTANCE = UuidCreator.getTimeBasedCreator();

        private TimeBasedCreatorHolder() {
        }
    }

    private static class TimeOrderedWithRandomCreatorHolder {
        static final TimeOrderedUuidCreator INSTANCE = (TimeOrderedUuidCreator)UuidCreator.getTimeOrderedCreator().withRandomNodeIdentifier();

        private TimeOrderedWithRandomCreatorHolder() {
        }
    }

    private static class TimeOrderedWithHashCreatorHolder {
        static final TimeOrderedUuidCreator INSTANCE = (TimeOrderedUuidCreator)UuidCreator.getTimeOrderedCreator().withHashNodeIdentifier();

        private TimeOrderedWithHashCreatorHolder() {
        }
    }

    private static class TimeOrderedWithMacCreatorHolder {
        static final TimeOrderedUuidCreator INSTANCE = (TimeOrderedUuidCreator)UuidCreator.getTimeOrderedCreator().withMacNodeIdentifier();

        private TimeOrderedWithMacCreatorHolder() {
        }
    }

    private static class TimeOrderedCreatorHolder {
        static final TimeOrderedUuidCreator INSTANCE = UuidCreator.getTimeOrderedCreator();

        private TimeOrderedCreatorHolder() {
        }
    }

    private static class RandomCreatorHolder {
        static final RandomBasedUuidCreator INSTANCE = UuidCreator.getRandomBasedCreator();

        private RandomCreatorHolder() {
        }
    }
}

