/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import java.net.URI;
import java.util.BitSet;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReEncodingRedirectStrategy
extends DefaultRedirectStrategy {
    private Logger log = LoggerFactory.getLogger(ReEncodingRedirectStrategy.class);
    private BitSet dontNeedEncoding = new BitSet(128);

    public ReEncodingRedirectStrategy() {
        this.dontNeedEncoding.set(97, 123);
        this.dontNeedEncoding.set(65, 91);
        this.dontNeedEncoding.set(48, 58);
        String x = "!#$%&'()*+,-./:;=?@_~";
        int i = 0;
        while (i < x.length()) {
            this.dontNeedEncoding.set(x.charAt(i));
            ++i;
        }
    }

    public URI createLocationURI(String location) throws ProtocolException {
        return super.createLocationURI(this.reEncode(location));
    }

    public String reEncode(String location) {
        String out = location;
        if (location != null) {
            boolean needsReEncoding = false;
            int i = 0;
            while (i < location.length()) {
                if (!this.dontNeedEncoding.get(location.charAt(i))) {
                    needsReEncoding = true;
                    break;
                }
                ++i;
            }
            if (needsReEncoding) {
                StringBuilder builder = new StringBuilder(location.length() + 9);
                int i2 = 0;
                while (i2 < location.length()) {
                    char c = location.charAt(i2);
                    if (this.dontNeedEncoding.get(c)) {
                        builder.append(c);
                    } else {
                        this.encode(c, builder);
                    }
                    ++i2;
                }
                out = builder.toString();
            }
        }
        if (out != location) {
            this.log.info("rewrote {} to {}", (Object)location, (Object)out);
        }
        return out;
    }

    private void encode(int c, StringBuilder builder) {
        char[] buf;
        if (c < 128) {
            buf = new char[]{(char)c};
        } else if (c < 2048) {
            buf = new char[2];
            buf[0] = (char)(c >> 6 | 0xC0);
        } else if (c < 65536) {
            buf = new char[3];
            buf[0] = (char)(c >> 12 | 0xE0);
        } else {
            buf = new char[4];
            buf[0] = (char)(c >> 18 | 0xF0);
        }
        int i = buf.length - 1;
        while (i > 0) {
            buf[i] = (char)(c & 0x3F | 0x80);
            c >>= 6;
            --i;
        }
        int j = 0;
        while (j < buf.length) {
            builder.append('%').append(Character.toUpperCase(Character.forDigit(buf[j] >> 4 & 0xF, 16))).append(Character.toUpperCase(Character.forDigit(buf[j] & 0xF, 16)));
            ++j;
        }
    }
}

