/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executable
implements RunnableFuture<Executable>,
Serializable {
    private static final long serialVersionUID = 8L;
    private transient Logger log;
    private transient Logger outputLog;
    private transient Logger errorLog;
    private transient FutureTask<Executable> future;
    private volatile transient boolean running;
    private File workingDirectory;
    private Iterable<?> commands;
    private Map<String, Object> substitutions = new ConcurrentSkipListMap<String, Object>();
    private String encoding = Charset.defaultCharset().name();
    private ThreadFactory threadFactory;
    private StreamPumper<?> stdoutPumper = new QueueStreamPumper();
    private StreamPumper<?> stderrPumper = new QueueStreamPumper();
    private List<Object> exitValues;
    private boolean stopOnFailure = false;
    private int[] expectedExitValues = new int[1];

    public Executable(Object ... commands) {
        this(commands == null ? null : Arrays.asList(commands));
    }

    public Executable(Iterable<?> commands) {
        this.commands = commands == null ? Collections.EMPTY_LIST : commands;
        this.init();
    }

    private void init() {
        this.future = new FutureTask<Executable>(new ExecuteStreamHandlerImpl(), this);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.outputLog = LoggerFactory.getLogger(this.getClass().getName().concat("Output"));
        this.errorLog = LoggerFactory.getLogger(this.getClass().getName().concat("Error"));
        this.exitValues = new ArrayList<Object>(this.commands instanceof Collection ? ((Collection)this.commands).size() : 3);
    }

    public Executable in(Object workingDirectory) {
        if (workingDirectory != null) {
            this.workingDirectory = workingDirectory instanceof File ? (File)workingDirectory : new File(workingDirectory.toString());
            this.workingDirectory.mkdirs();
        }
        return this;
    }

    public Executable encoding(String encoding) {
        assert (encoding != null);
        assert (Charset.availableCharsets().containsKey(encoding));
        this.encoding = encoding;
        return this;
    }

    public Executable stdout(StreamPumper pumper) {
        this.stdoutPumper = pumper == null ? new NullStreamPumper() : pumper;
        return this;
    }

    public Executable stderr(StreamPumper pumper) {
        this.stderrPumper = pumper == null ? new NullStreamPumper() : pumper;
        return this;
    }

    public Executable ignoreStdout() {
        return this.stdout(null);
    }

    public Executable ignoreStderr() {
        return this.stderr(null);
    }

    public Executable bufferStdout() {
        return this.stdout(new BufferStreamPumper());
    }

    public Executable bufferStderr() {
        return this.stderr(new BufferStreamPumper());
    }

    public Executable bufferStdout(int maxBufferLength) {
        return this.stdout(new BufferStreamPumper(maxBufferLength));
    }

    public Executable bufferStderr(int maxBufferLength) {
        return this.stderr(new BufferStreamPumper(maxBufferLength));
    }

    public Executable queueStdout() {
        return this.stdout(new QueueStreamPumper());
    }

    public Executable queueStderr() {
        return this.stderr(new QueueStreamPumper());
    }

    public Executable queueStdout(int maxLines) {
        return this.stdout(new QueueStreamPumper(maxLines));
    }

    public Executable queueStderr(int maxLines) {
        return this.stderr(new QueueStreamPumper(maxLines));
    }

    public Executable queueStdout(int maxLines, int maxLineLength) {
        return this.stdout(new QueueStreamPumper(maxLines, maxLineLength));
    }

    public Executable queueStderr(int maxLines, int maxLineLength) {
        return this.stderr(new QueueStreamPumper(maxLines, maxLineLength));
    }

    public Executable substitute(String key, Object value) {
        if (key != null && value != null) {
            this.substitutions.put(key, value);
        }
        return this;
    }

    public Executable substitute(Map<String, Object> substitutions) {
        if (substitutions != null) {
            for (Map.Entry<String, Object> e : substitutions.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                this.substitutions.put(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public Executable expect(Object values) {
        if (values instanceof int[]) {
            this.expectedExitValues = (int[])((int[])values).clone();
        } else if (values instanceof Iterable) {
            ArrayList<Integer> tempList = new ArrayList<Integer>();
            for (Object o : (Iterable)values) {
                if (o instanceof Number) {
                    tempList.add(((Number)o).intValue());
                    continue;
                }
                if (o == null) continue;
                String oString = String.valueOf(o).trim();
                try {
                    tempList.add(Integer.parseInt(oString));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.expectedExitValues = new int[tempList.size()];
            int i = 0;
            while (i < this.expectedExitValues.length) {
                this.expectedExitValues[i] = (Integer)tempList.get(i);
                ++i;
            }
        } else if (values instanceof Number) {
            this.expectedExitValues = new int[]{((Number)values).intValue()};
        } else if (values != null) {
            String valueString = String.valueOf(values).trim();
            try {
                this.expectedExitValues = new int[]{Integer.parseInt(valueString)};
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this;
    }

    public Executable expect(int value) {
        this.expectedExitValues = new int[]{value};
        return this;
    }

    public Object getOutput() {
        return this.stdoutPumper != null ? this.stdoutPumper.output : null;
    }

    public Object getError() {
        return this.stderrPumper != null ? this.stderrPumper.output : null;
    }

    public List<Object> getExitValues() {
        return Collections.unmodifiableList(this.exitValues);
    }

    public Executable stopOnFailure() {
        this.stopOnFailure = true;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public Executable withThreadFactory(ThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    public boolean isRunning() {
        return this.running && !this.isDone();
    }

    @Override
    public void run() {
        this.future.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public Executable get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public Executable get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public class BufferStreamPumper
    extends StreamPumper<StringBuffer> {
        private static final long serialVersionUID = -8699014458525194564L;
        private final int maxBufferLength;

        public BufferStreamPumper() {
            this(-1);
        }

        public BufferStreamPumper(int maxBufferLength) {
            super(new StringBuffer());
            this.maxBufferLength = maxBufferLength;
        }

        @Override
        public void run() {
            if (this.stream == null) {
                return;
            }
            char[] buf = new char[256];
            try {
                int b;
                InputStreamReader reader = new InputStreamReader(this.stream, Executable.this.encoding);
                while (this.stream != null && (b = reader.read(buf)) != -1) {
                    ((StringBuffer)this.output).append(buf, 0, b);
                    if (this.maxBufferLength <= -1 || ((StringBuffer)this.output).length() <= this.maxBufferLength) continue;
                    ((StringBuffer)this.output).delete(0, ((StringBuffer)this.output).length() - this.maxBufferLength);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class ExecuteStreamHandlerImpl
    implements ExecuteStreamHandler,
    Runnable {
        private Thread errorThread;
        private Thread outputThread;

        private ExecuteStreamHandlerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Executable.this.running = true;
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValues(Executable.this.expectedExitValues);
            executor.setStreamHandler((ExecuteStreamHandler)this);
            executor.setWorkingDirectory(Executable.this.workingDirectory);
            Iterator it = Executable.this.commands.iterator();
            while (it.hasNext() && !Executable.this.isCancelled()) {
                List list;
                Object command = it.next();
                if (command == null) continue;
                CommandLine line = CommandLine.parse((String)command.toString(), (Map)Executable.this.substitutions);
                long then = Executable.this.currentTimeMillis();
                try {
                    Executable.this.log.trace("executing {}", (Object)line);
                    int exitValue = executor.execute(line);
                    list = Executable.this.exitValues;
                    synchronized (list) {
                        Executable.this.exitValues.add(exitValue);
                    }
                    Executable.this.log.trace("executed  {}", (Object)line);
                    if (!Executable.this.log.isDebugEnabled() || Executable.this.log.isTraceEnabled()) continue;
                    Executable.this.log.debug("{} ms: {}", (Object)this.delta(then), (Object)StringUtils.join((Object[])line.toStrings(), " "));
                }
                catch (IOException ex) {
                    list = Executable.this.exitValues;
                    synchronized (list) {
                        Executable.this.exitValues.add(ex);
                    }
                    Executable.this.log.warn("{} exited after {} ms with {}", StringUtils.join((Object[])line.toStrings(), " "), this.delta(then), ExceptionUtils.getRootCauseMessage(ex));
                    if (!Executable.this.stopOnFailure) continue;
                    Executable.this.cancel(false);
                }
            }
            this.logOutput();
            this.logError();
        }

        private void logError() {
            String output;
            if (Executable.this.errorLog.isDebugEnabled() && Executable.this.stderrPumper != null && ((Executable)Executable.this).stderrPumper.output != null && StringUtils.isNotBlank(output = this.toString(((Executable)Executable.this).stderrPumper.output))) {
                Executable.this.errorLog.debug(output);
            }
        }

        private void logOutput() {
            String output;
            if (Executable.this.outputLog.isDebugEnabled() && Executable.this.stdoutPumper != null && ((Executable)Executable.this).stdoutPumper.output != null && StringUtils.isNotBlank(output = this.toString(((Executable)Executable.this).stdoutPumper.output))) {
                Executable.this.outputLog.debug(output);
            }
        }

        public void setProcessErrorStream(InputStream stream) {
            ((Executable)Executable.this).stderrPumper.stream = stream;
        }

        public void setProcessOutputStream(InputStream stream) {
            ((Executable)Executable.this).stdoutPumper.stream = stream;
        }

        public void setProcessInputStream(OutputStream stream) {
        }

        public void start() {
            this.errorThread = Executable.this.threadFactory == null ? new Thread(Executable.this.stderrPumper) : Executable.this.threadFactory.newThread(Executable.this.stderrPumper);
            this.errorThread.start();
            this.outputThread = Executable.this.threadFactory == null ? new Thread(Executable.this.stdoutPumper) : Executable.this.threadFactory.newThread(Executable.this.stdoutPumper);
            this.outputThread.start();
        }

        public void stop() {
            try {
                this.errorThread.join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.outputThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.outputThread = null;
            this.errorThread = null;
            ((Executable)Executable.this).stderrPumper.stream = null;
            ((Executable)Executable.this).stdoutPumper.stream = null;
        }

        long delta(long then) {
            return Executable.this.currentTimeMillis() - then;
        }

        String toString(Object output) {
            if (output instanceof Iterable) {
                return StringUtils.join(((Iterable)output).iterator(), StringUtils.defaultString(SystemUtils.LINE_SEPARATOR, "\n"));
            }
            if (output instanceof Object[]) {
                return StringUtils.join((Object[])output, StringUtils.defaultString(SystemUtils.LINE_SEPARATOR, "\n"));
            }
            return String.valueOf(output);
        }
    }

    private static class NullStreamPumper
    extends StreamPumper<Object> {
        private static final long serialVersionUID = 6790148206019003388L;
        private static final byte[] buf = new byte[256];

        NullStreamPumper() {
            super(null);
        }

        @Override
        public void run() {
            try {
                while (this.stream != null && this.stream.read(buf) != -1) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class QueueStreamPumper
    extends StreamPumper<ConcurrentLinkedQueue<String>> {
        private static final long serialVersionUID = -8753895328547724538L;
        private final int maxLines;
        private final int maxLineLength;

        public QueueStreamPumper() {
            this(-1, -1);
        }

        public QueueStreamPumper(int maxLines) {
            this(maxLines, -1);
        }

        public QueueStreamPumper(int maxLines, int maxLineLength) {
            super(new ConcurrentLinkedQueue());
            this.maxLines = maxLines;
            this.maxLineLength = maxLineLength;
        }

        @Override
        public void run() {
            if (this.stream == null) {
                return;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream, Executable.this.encoding), 256);
                while ((line = reader.readLine()) != null) {
                    if (this.maxLineLength > -1 && line.length() > this.maxLineLength) {
                        ((ConcurrentLinkedQueue)this.output).add(new String(line.substring(0, this.maxLineLength).toCharArray()));
                    } else {
                        ((ConcurrentLinkedQueue)this.output).add(line);
                    }
                    if (this.maxLines <= -1 || ((ConcurrentLinkedQueue)this.output).size() <= this.maxLines) continue;
                    ((ConcurrentLinkedQueue)this.output).poll();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static abstract class StreamPumper<T>
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = -2282419048545498727L;
        protected transient InputStream stream;
        protected T output;

        public StreamPumper(T output) {
            this.output = output;
        }
    }
}

