/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.migrator.provider.FilePaths;
import eu.europeana.cloud.migrator.provider.ResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class DefaultResourceProvider
implements ResourceProvider {
    public static final String ORGANISATION_NAME_KEY = "organisationName";
    public static final String OFFICIAL_ADDRESS_KEY = "officialAddress";
    public static final String ORGANISATION_WEBSITE_KEY = "organisationWebsite";
    public static final String ORGANISATION_WEBSITE_URL_KEY = "organisationWebsiteURL";
    public static final String DIGITAL_LIBRARY_WEBSITE_KEY = "digitalLibraryWebsite";
    public static final String DIGITAL_LIBRARY_WEBSITE_URL_KEY = "digitalLibraryURL";
    public static final String CONTACT_PERSON_KEY = "contactPerson";
    public static final String REMARKS_KEY = "remarks";
    public static final String DEFAULT_ORGANISATION_NAME = "Example Organisation";
    public static final String DEFAULT_OFFICIAL_ADDRESS = "Example Address";
    public static final String DEFAULT_ORGANISATION_WEBSITE = "Example Website";
    public static final String DEFAULT_ORGANISATION_WEBSITE_URL = "http://www.example.com";
    public static final String DEFAULT_DIGITAL_LIBRARY_WEBSITE = "Example DL Website";
    public static final String DEFAULT_DIGITAL_LIBRARY_WEBSITE_URL = "http://www.example.com/digital";
    public static final String DEFAULT_CONTACT_PERSON = "John Example";
    public static final String DEFAULT_REMARKS = "Example remarks";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final int DEFAULT_LIST_SIZE = 500;
    private static final Logger logger = Logger.getLogger(DefaultResourceProvider.class);
    protected String representationName;
    protected String mappingFile;
    protected List<URI> locations;
    protected boolean local;
    private Map<String, URI> providersLocation;
    protected String dataProviderId;

    protected DefaultResourceProvider(String representationName, String mappingFile, String locations, String dataProviderId) {
        if (representationName == null) {
            throw new IllegalArgumentException("Representation name cannot be null!");
        }
        this.representationName = representationName;
        this.mappingFile = mappingFile;
        this.locations = new ArrayList<URI>();
        this.providersLocation = new HashMap<String, URI>();
        this.local = this.detectLocations(locations);
        this.dataProviderId = dataProviderId != null ? (dataProviderId.isEmpty() ? null : dataProviderId) : null;
    }

    private boolean detectLocations(String locations) {
        String[] locs;
        boolean allLocal = true;
        boolean firstChange = true;
        for (String loc : locs = locations.split(";")) {
            boolean locationLocal;
            URI location;
            try {
                location = new URI(loc);
                this.locations.add(location);
            }
            catch (URISyntaxException e) {
                logger.error((Object)("URI " + loc + " is not valid."), (Throwable)e);
                continue;
            }
            String scheme = location.getScheme();
            boolean bl = locationLocal = scheme == null || scheme.isEmpty() || scheme.toLowerCase().equals("file");
            if (locationLocal == allLocal) continue;
            if (firstChange) {
                firstChange = false;
                allLocal = locationLocal;
                continue;
            }
            logger.error((Object)"All locations must be either local or remote");
            throw new IllegalArgumentException("All locations must be either local or remote. locations: " + locations);
        }
        return allLocal;
    }

    protected DataProviderProperties getDataProviderPropertiesFromFile(File dpFile) {
        Properties props = this.loadPropertiesFile(dpFile);
        return new DataProviderProperties(props.getProperty(ORGANISATION_NAME_KEY, DEFAULT_ORGANISATION_NAME), props.getProperty(OFFICIAL_ADDRESS_KEY, DEFAULT_OFFICIAL_ADDRESS), props.getProperty(ORGANISATION_WEBSITE_KEY, DEFAULT_ORGANISATION_WEBSITE), props.getProperty(ORGANISATION_WEBSITE_URL_KEY, DEFAULT_ORGANISATION_WEBSITE_URL), props.getProperty(DIGITAL_LIBRARY_WEBSITE_KEY, DEFAULT_DIGITAL_LIBRARY_WEBSITE), props.getProperty(DIGITAL_LIBRARY_WEBSITE_URL_KEY, DEFAULT_DIGITAL_LIBRARY_WEBSITE_URL), props.getProperty(CONTACT_PERSON_KEY, DEFAULT_CONTACT_PERSON), props.getProperty(REMARKS_KEY, DEFAULT_REMARKS));
    }

    private Properties loadPropertiesFile(File dpFile) {
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(dpFile);){
            props.load(is);
        }
        catch (IOException e) {
            logger.error((Object)("Problem with file " + dpFile.getAbsolutePath()), (Throwable)e);
        }
        return props;
    }

    protected DataProviderProperties getDefaultDataProviderProperties() {
        return new DataProviderProperties(DEFAULT_ORGANISATION_NAME, DEFAULT_OFFICIAL_ADDRESS, DEFAULT_ORGANISATION_WEBSITE, DEFAULT_ORGANISATION_WEBSITE_URL, DEFAULT_DIGITAL_LIBRARY_WEBSITE, DEFAULT_DIGITAL_LIBRARY_WEBSITE_URL, DEFAULT_CONTACT_PERSON, DEFAULT_REMARKS);
    }

    @Override
    public String getRepresentationName() {
        return this.representationName;
    }

    @Override
    public List<URI> getLocations() {
        return this.locations;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Map<String, List<FilePaths>> scan() {
        HashMap<String, List<FilePaths>> paths = new HashMap<String, List<FilePaths>>();
        if (!this.local) {
            logger.warn((Object)"Location is not local. Scanning is not possible.");
            return paths;
        }
        for (URI location : this.locations) {
            this.collectPaths(Paths.get(location), paths, location);
            this.sortPaths(paths);
        }
        return paths;
    }

    private void sortPaths(Map<String, List<FilePaths>> paths) {
        for (List<FilePaths> list : paths.values()) {
            for (FilePaths fp : list) {
                fp.sort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectPaths(Path rootPath, Map<String, List<FilePaths>> paths, URI location) {
        if (rootPath == null) {
            return;
        }
        DirectoryStream<Path> dirStream = null;
        try {
            dirStream = Files.newDirectoryStream(rootPath);
            for (Path path : dirStream) {
                String providerId;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.collectPaths(path, paths, location);
                    continue;
                }
                String absolute = path.toAbsolutePath().toString().replace("\\", "/");
                if (absolute.endsWith((providerId = this.getResourceProviderId(absolute)) + PROPERTIES_EXTENSION)) continue;
                FilePaths providerPaths = this.getProviderPaths(Paths.get(location).toAbsolutePath().toString().replace("\\", "/"), providerId, paths);
                providerPaths.addPath(absolute);
                if (this.providersLocation.get(providerId) != null) continue;
                this.providersLocation.put(providerId, location);
            }
        }
        catch (IOException e) {
            logger.error((Object)("There was a problem with opening direcory " + rootPath.toString()), (Throwable)e);
        }
        finally {
            if (dirStream != null) {
                try {
                    dirStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)("There was a problem with closing direcory stream for " + rootPath.toString()), (Throwable)e);
                }
            }
        }
    }

    protected FilePaths getProviderPaths(String location, String providerId, Map<String, List<FilePaths>> paths) {
        if (paths.get(providerId) == null) {
            paths.put(providerId, new ArrayList());
        }
        for (FilePaths p : paths.get(providerId)) {
            if (!p.getLocation().equals(location)) continue;
            return p;
        }
        FilePaths fp = new FilePaths(location, providerId);
        if (this.usePathsFile()) {
            fp.useFile(location.replace("/", "_").replace(":", "_") + "_" + providerId);
        }
        paths.get(providerId).add(fp);
        return fp;
    }

    public URI getProvidersLocation(String providerId) {
        return this.providersLocation.get(providerId);
    }

    @Override
    public String getFilename(String location, String path) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get filename for location: " + location + ", path: " + path));
        }
        int pos = -1;
        if (path.startsWith(location)) {
            path = path.substring(location.length());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Path without location: " + path));
            }
            if ((pos = path.indexOf("/")) == -1) {
                pos = path.indexOf("\\");
            }
        } else {
            pos = path.lastIndexOf("/");
            if (pos == -1) {
                pos = path.lastIndexOf("\\");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning: " + path.substring(pos + 1)));
        }
        return path.substring(pos + 1);
    }

    @Override
    public int getFileCount(String localId) {
        return -1;
    }

    @Override
    public List<FilePaths> split(List<FilePaths> paths) {
        ArrayList<FilePaths> result = new ArrayList<FilePaths>();
        for (FilePaths fp : paths) {
            result.addAll(this.split(fp));
        }
        return result;
    }

    private List<FilePaths> split(FilePaths fp) {
        int size = fp.size();
        int count = size / 500;
        int rest = size % 500;
        ArrayList<FilePaths> result = new ArrayList<FilePaths>();
        if (size <= 500) {
            result.add(fp);
        } else {
            for (int i = 0; i < count; ++i) {
                FilePaths filePath = new FilePaths(fp.getLocation(), fp.getDataProvider());
                filePath.getFullPaths().addAll(fp.getFullPaths().subList(i * 500, (i + 1) * 500 < size ? (i + 1) * 500 : size));
                filePath.setIdentifier(String.valueOf(i * 500) + "_" + String.valueOf((i + 1) * 500 < size ? (i + 1) * 500 : size));
                result.add(filePath);
            }
            if (rest > 0) {
                FilePaths filePath = new FilePaths(fp.getLocation(), fp.getDataProvider());
                filePath.getFullPaths().addAll(fp.getFullPaths().subList(count * 500, size));
                filePath.setIdentifier(String.valueOf(count * 500) + "_" + String.valueOf(size));
                result.add(filePath);
            }
        }
        return result;
    }

    @Override
    public boolean usePathsFile() {
        return false;
    }

    @Override
    public Map<String, String> getReversedMapping() {
        return new HashMap<String, String>();
    }
}

