/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Cleaner {
    private static final Logger logger = Logger.getLogger(Cleaner.class);

    public void clean(String providerId, RecordServiceClient mcs, UISClient uis) {
        try {
            for (String line : Files.readAllLines(FileSystems.getDefault().getPath(".", providerId + ".txt"), Charset.forName("UTF-8"))) {
                String url;
                int pos;
                StringTokenizer st = new StringTokenizer(line, ";");
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if ((pos = (url = st.nextToken()).indexOf("/records/")) <= -1) continue;
                String id = url.substring(pos + "/records/".length());
                id = id.substring(0, id.indexOf("/"));
                mcs.deleteRecord(id);
                uis.deleteCloudId(id);
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordNotExistsException e) {
            logger.error((Object)"Error while cleaning ", (Throwable)e);
        }
        catch (MCSException e) {
            logger.error((Object)"Error while cleaning ", (Throwable)e);
        }
        catch (CloudException e) {
            logger.error((Object)"Error while cleaning ", (Throwable)e);
        }
    }

    public void cleanRecords(String providerId, RecordServiceClient mcs, UISClient uis) {
        try {
            for (String line : Files.readAllLines(FileSystems.getDefault().getPath(".", providerId + "_ids.txt"), Charset.forName("UTF-8"))) {
                String id = line.trim();
                logger.info((Object)("Cleaning record: " + id));
                mcs.deleteRecord(id);
                uis.deleteCloudId(id);
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordNotExistsException e) {
            logger.error((Object)"Error while cleaning records ", (Throwable)e);
        }
        catch (MCSException e) {
            logger.error((Object)"Error while cleaning records ", (Throwable)e);
        }
        catch (CloudException e) {
            logger.error((Object)"Error while cleaning records ", (Throwable)e);
        }
    }
}

