/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.migrator.provider.DefaultResourceProvider;
import java.io.File;

public class StandardResourceProvider
extends DefaultResourceProvider {
    private static final String DEFAULT_PROVIDER_ID = "data_provider";

    public StandardResourceProvider(String representationName, String mappingFile, String locations, String dataProviderId) {
        super(representationName, mappingFile, locations, dataProviderId);
    }

    @Override
    public String getLocalIdentifier(String location, String path, boolean duplicate) {
        if (duplicate) {
            return null;
        }
        if (location == null || path == null) {
            return null;
        }
        if (!path.startsWith(location)) {
            return null;
        }
        int pos = path.indexOf(this.getDataProviderId(path));
        if (pos == -1) {
            return null;
        }
        String local = path.substring(pos + this.getDataProviderId(path).length());
        if (local.startsWith("/") || local.startsWith("\\")) {
            local = local.substring(1);
        }
        if ((pos = local.indexOf("/")) == -1) {
            pos = local.indexOf("\\");
        }
        if (pos == -1) {
            return null;
        }
        return local.substring(0, pos);
    }

    @Override
    public String getResourceProviderId(String path) {
        return this.getDataProviderId(path);
    }

    @Override
    public String getDataProviderId(String path) {
        if (this.dataProviderId != null) {
            return this.dataProviderId;
        }
        return DEFAULT_PROVIDER_ID;
    }

    @Override
    public DataProviderProperties getDataProviderProperties(String path) {
        File dpFile;
        String id = this.getDataProviderId(path);
        if (id == null) {
            return this.getDefaultDataProviderProperties();
        }
        File f = new File(path);
        if (f.exists() && f.isFile() && f.getName().equals(id + ".properties")) {
            return this.getDataProviderPropertiesFromFile(f);
        }
        if (f.isDirectory() && (dpFile = new File(f, id + ".properties")).exists()) {
            return this.getDataProviderPropertiesFromFile(dpFile);
        }
        return this.getDefaultDataProviderProperties();
    }

    @Override
    public String getFilename(String location, String path) {
        if (path == null || location == null) {
            return null;
        }
        if (!path.startsWith(location)) {
            return null;
        }
        int pos = path.lastIndexOf("/");
        if (pos == -1) {
            pos = path.lastIndexOf("\\");
        }
        return path.substring(pos + 1);
    }

    @Override
    public int getFileCount(String localId) {
        return 1;
    }
}

