/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.migrator.provider.DefaultResourceProvider;
import java.io.File;
import org.apache.log4j.Logger;

public class FoodAndDrinkResourceProvider
extends DefaultResourceProvider {
    private static final String DATA_PROVIDERS_DIR = "users";
    private static final Logger logger = Logger.getLogger(FoodAndDrinkResourceProvider.class);

    public FoodAndDrinkResourceProvider(String representationName, String mappingFile, String locations, String dataProviderId) {
        super(representationName, mappingFile, locations, dataProviderId);
    }

    @Override
    public String getLocalIdentifier(String location, String path, boolean duplicate) {
        String local;
        if (duplicate) {
            return null;
        }
        String providerId = this.getResourceProviderId(path);
        if (path == null || path.isEmpty() || providerId == null || providerId.isEmpty()) {
            logger.warn((Object)"Either path or provider identifier is null or empty. Local record identifier cannot be retrieved.");
            return null;
        }
        int pos = path.indexOf(providerId);
        if (pos != -1 && ((local = path.substring(pos + providerId.length())).startsWith("/") || local.startsWith("\\"))) {
            return local.substring(1);
        }
        logger.warn((Object)"Path to the image file does not contain provider identifier. Local record identifier cannot be retrieved.");
        return null;
    }

    @Override
    public String getResourceProviderId(String path) {
        if (!path.contains(DATA_PROVIDERS_DIR)) {
            logger.error((Object)"No data providers directory found in resource path");
            return null;
        }
        int pos = path.indexOf(DATA_PROVIDERS_DIR);
        String rest = path.substring(pos + DATA_PROVIDERS_DIR.length());
        if (rest.startsWith("/") || rest.startsWith("\\")) {
            rest = rest.substring(1);
        }
        if ((pos = rest.indexOf("/")) == -1) {
            pos = rest.indexOf("\\");
        }
        return rest.substring(0, pos > -1 ? pos : rest.length());
    }

    @Override
    public String getDataProviderId(String path) {
        if (this.dataProviderId == null) {
            return this.getResourceProviderId(path);
        }
        return this.dataProviderId;
    }

    @Override
    public DataProviderProperties getDataProviderProperties(String path) {
        File dpFile;
        String id = this.getDataProviderId(path);
        if (id == null) {
            return this.getDefaultDataProviderProperties();
        }
        File f = new File(path);
        if (f.exists() && f.isFile() && f.getName().equals(id + ".properties")) {
            return this.getDataProviderPropertiesFromFile(f);
        }
        if (f.isDirectory() && (dpFile = new File(f, id + ".properties")).exists()) {
            return this.getDataProviderPropertiesFromFile(dpFile);
        }
        return this.getDefaultDataProviderProperties();
    }

    @Override
    public String getFilename(String location, String path) {
        String providerId = this.getResourceProviderId(path);
        int pos = path.indexOf(providerId);
        if (pos == -1) {
            return null;
        }
        return path.substring(pos);
    }

    @Override
    public int getFileCount(String localId) {
        return 1;
    }
}

