/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.processing;

import eu.europeana.cloud.migrator.ResourceMigratorApp;
import eu.europeana.cloud.migrator.processing.CommandResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CommandExecutor {
    private static final String WORKING_DIR_PARAM = "command.working.dir";
    private static final String COMMAND_PARAM = "command";
    private static final int BUFFER_SIZE = 1024;
    private List<String> commandTemplates = new ArrayList<String>();
    protected String workingDirectory;
    private static final Logger logger = Logger.getLogger(CommandExecutor.class);

    public CommandExecutor(String configFile) {
        this.loadConfig(ResourceMigratorApp.loadPropertiesFile(new File(configFile)));
    }

    private void loadConfig(Properties props) {
        this.workingDirectory = props.getProperty(WORKING_DIR_PARAM);
        if (this.workingDirectory == null || this.workingDirectory.isEmpty()) {
            this.workingDirectory = System.getProperty("java.io.tmpdir");
        }
        String command = null;
        int counter = 0;
        while ((command = props.getProperty("command." + String.valueOf(++counter))) != null) {
            this.commandTemplates.add(command);
        }
    }

    protected String prepareCommand(String command, List<String> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            command = command.replace("$" + (i + 1), parameters.get(i));
        }
        return command;
    }

    protected CommandResult runCommand(int index, List<String> parameters) {
        String command = this.getCommand(index);
        if ((command = this.prepareCommand(command, parameters)) == null) {
            CommandResult cr = new CommandResult();
            cr.setResult(false);
            return cr;
        }
        return this.runCommand(command);
    }

    private String getCommand(int index) {
        if (index < 0 || index >= this.commandTemplates.size()) {
            return null;
        }
        return this.commandTemplates.get(index);
    }

    protected CommandResult runCommand(String command) {
        CommandResult result = new CommandResult();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting execution of command: " + command));
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            final InputStream stderr = process.getErrorStream();
            new Thread("CmdExecutor-stderrReader"){

                @Override
                public void run() {
                    try {
                        this.readAndLog(stderr);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error getting process output", (Throwable)e);
                    }
                }

                private void readAndLog(InputStream in) throws IOException {
                    int read;
                    byte[] buffer = new byte[1024];
                    int offset = 0;
                    while ((read = in.read(buffer, offset, 1024 - offset)) != -1) {
                        if (read >= 0 && in.available() >= 1 && (offset += read) < 1024) continue;
                        if (offset > 0) {
                            logger.warn((Object)new String(buffer, 0, offset));
                        }
                        offset = 0;
                    }
                }
            }.start();
            String out = this.read(process.getInputStream());
            if (!out.isEmpty() && logger.isDebugEnabled()) {
                logger.debug((Object)("Command output: " + out));
            }
            result.setStdOut(out);
            int exitStatus = process.waitFor();
            if (exitStatus != 0) {
                logger.warn((Object)("Command executed unsuccessfully with exit status " + exitStatus + ": " + command));
                result.setResult(false);
                result.setExitStatus(exitStatus);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Object)("Command execution interrupted: " + command), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)("Command execution failed: " + command), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            if (result.getResult()) {
                logger.debug((Object)("Command: " + command + " executed successfully."));
            } else {
                logger.debug((Object)("Command: " + command + " executed with errors."));
            }
        }
        return result;
    }

    private String read(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((read = in.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, read);
        }
        return os.toString();
    }
}

