/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator;

import eu.europeana.cloud.migrator.ResourceMigrator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ResourceMigratorApp {
    private static final Logger logger = Logger.getLogger(ResourceMigratorApp.class);
    private static final String CLEAN = "clean";
    private static final String SIMULATE = "simulate";
    private static final String VERIFY = "verify";
    private static final String VERIFYLOCAL = "verifylocal";
    private static final String GRANT_PUBLIC_ACCESS = "grant";

    private static ArgumentParser prepareArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"ResourceMigratorApp").defaultHelp(true).description("Migrate files from specified location to Europeana Cloud.");
        parser.addArgument(new String[]{"-c", "--clean"}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).help("Clean previously added records.");
        parser.addArgument(new String[]{"-path"}).help("Only in Windows.");
        parser.addArgument(new String[]{"-g", "--grant"}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).help("Grant .");
        MutuallyExclusiveGroup group = parser.addMutuallyExclusiveGroup();
        group.addArgument(new String[]{"-v", "--verify"}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).help("Verify the migration from files point of view.");
        group.addArgument(new String[]{"-V", "--verifylocal"}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).help("Verify whether all local identifiers given in a mapping file were migrated. NOTE: works for selected resource providers only.");
        group.addArgument(new String[]{"-s", "--simulate"}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).help("Simulate migration to get the names of the files affected by the migration.");
        return parser;
    }

    public static void main(String[] args) {
        ArgumentParser parser = ResourceMigratorApp.prepareArgumentParser();
        Namespace ns = null;
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        ApplicationContext context = ResourceMigratorApp.getContext();
        if (context == null) {
            logger.error((Object)"Spring configuration files not found!");
            System.exit(-1);
        }
        ResourceMigrator migrator = (ResourceMigrator)context.getBean("migrator");
        if (ns.getBoolean(VERIFYLOCAL).booleanValue()) {
            migrator.verifyLocalIds();
        } else if (ns.getBoolean(VERIFY).booleanValue()) {
            migrator.verify();
        } else if (ns.getBoolean(GRANT_PUBLIC_ACCESS).booleanValue()) {
            migrator.grant(ns.getBoolean(SIMULATE));
        } else {
            migrator.migrate(ns.getBoolean(CLEAN), ns.getBoolean(SIMULATE));
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFile(File dpFile) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(dpFile);
            props.load(is);
        }
        catch (IOException e) {
            logger.error((Object)("Could not load properties file " + dpFile.getAbsolutePath()));
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Could not close input stream.", (Throwable)e);
            }
        }
        return props;
    }

    private static ApplicationContext getContext() {
        Properties config = ResourceMigratorApp.loadPropertiesFile(new File("config.properties"));
        if (config.isEmpty()) {
            return null;
        }
        try {
            String content = new String(Files.readAllBytes(FileSystems.getDefault().getPath(".", "spring-config.xml")));
            for (Object obj : config.keySet()) {
                String value = (String)config.get(obj);
                if (value == null) {
                    value = "";
                }
                String key = "${" + obj + "}";
                content = content.replace(key, value);
            }
            Files.write(FileSystems.getDefault().getPath(".", "spring-config-configured.xml"), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            return null;
        }
        return new FileSystemXmlApplicationContext("spring-config-configured.xml");
    }
}

