/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.migrator.processing.FileProcessor;
import eu.europeana.cloud.migrator.processing.FileProcessorFactory;
import eu.europeana.cloud.migrator.provider.Cleaner;
import eu.europeana.cloud.migrator.provider.FilePaths;
import eu.europeana.cloud.migrator.provider.ResourceProvider;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.RecordExistsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceMigrator {
    public static final String LINUX_SEPARATOR = "/";
    public static final String WINDOWS_SEPARATOR = "\\";
    public static final String TEXT_EXTENSION = ".txt";
    private static final String FILES_PART = "files";
    private static final Logger logger = Logger.getLogger(ResourceMigrator.class);
    private static final Map<String, String> mimeTypes = new HashMap<String, String>();
    private static final int DEFAULT_RETRIES = 10;
    private static final byte DEFAULT_POOL_SIZE = 10;
    private static final ExecutorService threadPool;
    private static final byte DEFAULT_PROVIDER_POOL_SIZE = 50;
    @Autowired
    private RecordServiceClient mcs;
    @Autowired
    private UISClient uis;
    @Autowired
    private FileServiceClient fsc;
    private ResourceProvider resourceProvider;
    private FileProcessor fileProcessor;
    protected Map<String, String> dataProvidersMapping;
    protected int threadsCount = 50;

    public ResourceMigrator(ResourceProvider resProvider, String dataProvidersMappingFile, String threadsCount, FileProcessorFactory fileProcessorFactory) throws IOException {
        this.resourceProvider = resProvider;
        this.dataProvidersMapping = this.readDataProvidersMapping(dataProvidersMappingFile);
        if (threadsCount != null && !threadsCount.isEmpty()) {
            try {
                this.threadsCount = Integer.valueOf(threadsCount);
                if (this.threadsCount < 0) {
                    this.threadsCount = 50;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fileProcessor = fileProcessorFactory.create();
    }

    private Map<String, String> readDataProvidersMapping(String dataProvidersMappingFile) throws IOException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        if (dataProvidersMappingFile == null || dataProvidersMappingFile.isEmpty()) {
            return mapping;
        }
        Path mappingPath = null;
        try {
            mappingPath = FileSystems.getDefault().getPath(".", dataProvidersMappingFile);
            if (!mappingPath.toFile().exists()) {
                mappingPath = FileSystems.getDefault().getPath(dataProvidersMappingFile, new String[0]);
            }
        }
        catch (InvalidPathException e) {
            mappingPath = FileSystems.getDefault().getPath(dataProvidersMappingFile, new String[0]);
        }
        if (mappingPath == null || !mappingPath.toFile().exists()) {
            throw new IOException("Mapping file cannot be found: " + dataProvidersMappingFile);
        }
        for (String line : Files.readAllLines(mappingPath, Charset.forName("UTF-8"))) {
            if (line == null) break;
            StringTokenizer tokenizer = new StringTokenizer(line, ";");
            String directory = tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : null;
            if (directory == null || directory.isEmpty()) {
                logger.warn((Object)("Directory name for data provider is missing (" + directory + "). Skipping line."));
                continue;
            }
            String identifier = tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : null;
            if (identifier == null || identifier.isEmpty()) continue;
            mapping.put(directory, identifier);
        }
        return mapping;
    }

    public void verifyLocalIds() {
        HashSet<String> uniqueIds = new HashSet<String>();
        uniqueIds.addAll(this.resourceProvider.getReversedMapping().values());
        if (uniqueIds.size() == 0) {
            return;
        }
        ExecutorService threadLocalIdPool = Executors.newFixedThreadPool(this.threadsCount);
        List results = null;
        ArrayList<LocalIdVerifier> tasks = new ArrayList<LocalIdVerifier>();
        int parts = this.threadsCount;
        int idsPerThread = uniqueIds.size() / this.threadsCount;
        if (idsPerThread == 0) {
            parts = 1;
            idsPerThread = uniqueIds.size();
        } else if (uniqueIds.size() % this.threadsCount > 0) {
            ++idsPerThread;
        }
        ArrayList localIds = new ArrayList(uniqueIds);
        for (int i = 0; i < parts; ++i) {
            int from = i * idsPerThread;
            int to = (i + 1) * idsPerThread > localIds.size() ? localIds.size() : (i + 1) * idsPerThread;
            String id = String.valueOf(from + "-" + to);
            logger.info((Object)("Starting local identifier verification task thread for part " + id + "..."));
            tasks.add(new LocalIdVerifier(localIds.subList(from, to), id));
        }
        if (tasks.size() == 0) {
            return;
        }
        try {
            results = threadLocalIdPool.invokeAll(tasks);
            for (Future result : results) {
                LocalIdVerificationResult localIdResult = (LocalIdVerificationResult)result.get();
                logger.info((Object)("Verification of local identifier part " + localIdResult.getIdentifier() + " performed successfully. Verification time: " + localIdResult.getTime() + " sec. Number of not migrated identifiers: " + localIdResult.getNotMigratedCount()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Verification processed interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Problem with verification task thread execution.", (Throwable)e);
        }
    }

    private String getPathFromMapping(Map<String, String> localIds, String localId) {
        if (localIds == null || localIds.size() == 0) {
            return null;
        }
        String result = null;
        for (Map.Entry<String, String> entry : localIds.entrySet()) {
            int pos;
            if (!entry.getValue().equals(localId)) continue;
            result = entry.getKey().substring(0, (pos = entry.getKey().lastIndexOf(LINUX_SEPARATOR)) != -1 ? pos : entry.getKey().length());
            break;
        }
        return result;
    }

    public boolean grant(boolean simulate) {
        int from;
        HashSet<String> uniqueIds = new HashSet<String>();
        uniqueIds.addAll(this.resourceProvider.getReversedMapping().values());
        if (uniqueIds.size() == 0) {
            return false;
        }
        ExecutorService threadLocalIdPool = Executors.newFixedThreadPool(this.threadsCount);
        List results = null;
        ArrayList<PublicAccessGranter> tasks = new ArrayList<PublicAccessGranter>();
        int parts = this.threadsCount;
        int idsPerThread = uniqueIds.size() / this.threadsCount;
        if (idsPerThread == 0) {
            parts = 1;
            idsPerThread = uniqueIds.size();
        } else if (uniqueIds.size() % this.threadsCount > 0) {
            ++idsPerThread;
        }
        ArrayList localIds = new ArrayList(uniqueIds);
        for (int i = 0; i < parts && (from = i * idsPerThread) < localIds.size(); ++i) {
            int to = (i + 1) * idsPerThread > localIds.size() ? localIds.size() : (i + 1) * idsPerThread;
            String id = String.valueOf(from + "-" + to);
            logger.info((Object)("Starting public access granter task thread for part " + id + "..."));
            tasks.add(new PublicAccessGranter(localIds.subList(from, to), id, simulate));
        }
        if (tasks.size() == 0) {
            return false;
        }
        try {
            results = threadLocalIdPool.invokeAll(tasks);
            for (Future result : results) {
                PublicAccessGranterResult granterResult = (PublicAccessGranterResult)result.get();
                logger.info((Object)("Public access granter part " + granterResult.getIdentifier() + " performed successfully. Granting time: " + granterResult.getTime() + " sec. Number of not granted identifiers: " + granterResult.getNotGrantedCount()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Granting processed interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Problem with granting task thread execution.", (Throwable)e);
        }
        return true;
    }

    public boolean migrate(boolean clean, boolean simulate) {
        boolean success = true;
        long start = System.currentTimeMillis();
        Map<String, List<FilePaths>> paths = this.resourceProvider.scan();
        logger.info((Object)("Scanning resource provider locations finished in " + String.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f) + " sec."));
        if (!clean && simulate) {
            this.summarize(paths);
            return true;
        }
        List results = null;
        ArrayList<ProviderMigrator> tasks = new ArrayList<ProviderMigrator>();
        for (String providerId : paths.keySet()) {
            if (clean) {
                logger.info((Object)("Cleaning " + providerId));
                this.clean(providerId);
            }
            if (simulate) continue;
            logger.info((Object)("Starting task thread for provider " + providerId + "..."));
            tasks.add(new ProviderMigrator(providerId, paths.get(providerId), null));
        }
        if (tasks.size() == 0) {
            return success;
        }
        try {
            results = threadPool.invokeAll(tasks);
            for (Future result : results) {
                MigrationResult providerResult = (MigrationResult)result.get();
                logger.info((Object)("Migration of provider " + providerResult.getProviderId() + " performed " + (providerResult.isSuccessful() != false ? "" : "un") + "successfully. Migration time: " + providerResult.getTime() + " sec."));
                success &= providerResult.isSuccessful().booleanValue();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Migration processed interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Problem with migration task thread execution.", (Throwable)e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void summarize(Map<String, List<FilePaths>> paths) {
        String summaryFile = "simulation" + System.currentTimeMillis() + TEXT_EXTENSION;
        try {
            Path dest = FileSystems.getDefault().getPath(".", summaryFile);
            String msg = "Found " + paths.size() + " data providers.\n";
            Files.write(dest, msg.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            for (Map.Entry<String, List<FilePaths>> entry : paths.entrySet()) {
                msg = "\nData provider " + entry.getKey();
                if (this.dataProvidersMapping.get(entry.getKey()) != null) {
                    msg = msg + " (mapped: " + this.dataProvidersMapping.get(entry.getKey()) + ")";
                }
                msg = msg + ": " + entry.getValue().size() + " locations\n";
                Files.write(dest, msg.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                for (FilePaths fp : entry.getValue()) {
                    BufferedReader reader = fp.getPathsReader();
                    try {
                        msg = "\nLocation: " + fp.getLocation() + " - " + fp.size() + " paths\n\n";
                        Files.write(dest, msg.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                        int counter = 1;
                        if (reader != null) {
                            String s;
                            while ((s = reader.readLine()) != null) {
                                Files.write(dest, String.valueOf(counter++ + ". " + s + "\n").getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                            }
                            continue;
                        }
                        for (String s : fp.getFullPaths()) {
                            Files.write(dest, String.valueOf(counter++ + ". " + s + "\n").getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Summary file " + summaryFile + " could not be saved."), (Throwable)e);
        }
    }

    private URI createRepresentationName(String providerId, String cloudId) {
        int retries = 10;
        String dataProviderId = this.getProviderId(providerId);
        while (retries-- > 0) {
            try {
                List representations;
                try {
                    representations = this.mcs.getRepresentations(cloudId, this.resourceProvider.getRepresentationName());
                }
                catch (RepresentationNotExistsException e) {
                    return this.mcs.createRepresentation(cloudId, this.resourceProvider.getRepresentationName(), dataProviderId);
                }
                for (Representation representation : representations) {
                    if (representation.isPersistent()) {
                        return null;
                    }
                    this.mcs.deleteRepresentation(cloudId, this.resourceProvider.getRepresentationName(), representation.getVersion());
                }
                return this.mcs.createRepresentation(cloudId, this.resourceProvider.getRepresentationName(), dataProviderId);
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while creating representation for record " + cloudId + ", provider " + dataProviderId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (ProviderNotExistsException e) {
                logger.error((Object)("Provider " + dataProviderId + " does not exist!"));
                break;
            }
            catch (RecordNotExistsException e) {
                logger.error((Object)("Record " + cloudId + " does not exist!"));
                break;
            }
            catch (MCSException e) {
                logger.error((Object)"Problem with creating representation name!");
            }
            catch (Exception e) {
                logger.error((Object)"Exception when creating representation occured.", (Throwable)e);
            }
        }
        logger.warn((Object)("All attempts to create representation failed. ProviderId: " + providerId + " CloudId: " + cloudId + " Representation: " + this.resourceProvider.getRepresentationName()));
        return null;
    }

    private String createRecord(String providerId, String localId) {
        int retries = 10;
        String dataProviderId = this.getProviderId(providerId);
        while (retries-- > 0) {
            try {
                CloudId cloudId = this.uis.createCloudId(dataProviderId, localId);
                if (cloudId == null) continue;
                return cloudId.getId();
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while creating record for provider " + dataProviderId + " and local id " + localId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (CloudException e) {
                if (e.getCause() instanceof RecordExistsException) {
                    try {
                        logger.info((Object)("Record Exists" + localId));
                        return this.uis.getCloudId(dataProviderId, localId).getId();
                    }
                    catch (ProcessingException e1) {
                        logger.warn((Object)("Error processing HTTP request while creating record for provider " + dataProviderId + ". Retries left: " + retries), (Throwable)e);
                        continue;
                    }
                    catch (CloudException e1) {
                        logger.warn((Object)("Record for provider " + dataProviderId + " with local id " + localId + " could not be created"), (Throwable)e1);
                        break;
                    }
                    catch (Exception e1) {
                        logger.info((Object)("Provider: " + providerId + " Local: " + localId), (Throwable)e);
                        continue;
                    }
                }
                logger.warn((Object)("Record for provider " + dataProviderId + " with local id " + localId + " could not be created"), (Throwable)e);
                break;
            }
            catch (Exception e) {
                logger.error((Object)"Exception when creating record occured.", (Throwable)e);
            }
        }
        logger.warn((Object)("All attempts to create record failed. ProviderId: " + providerId + " LocalId: " + localId));
        return null;
    }

    private String getRecord(String providerId, String localId) {
        int retries = 10;
        String dataProviderId = this.getProviderId(providerId);
        while (retries-- > 0) {
            try {
                CloudId cloudId = this.uis.getCloudId(dataProviderId, localId);
                if (cloudId == null) continue;
                return cloudId.getId();
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while getting record for provider " + dataProviderId + " and local id " + localId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (CloudException e) {
                if (!(e.getCause() instanceof RecordDoesNotExistException)) continue;
                return null;
            }
            catch (Exception e) {
                logger.error((Object)"Exception when getting record occured.", (Throwable)e);
            }
        }
        logger.warn((Object)("All attempts to get record failed. ProviderId: " + providerId + " LocalId: " + localId));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFilename(String location, String path, String version, String recordId) {
        if (location == null || path == null || version == null || recordId == null) {
            return null;
        }
        String mimeType = "";
        InputStream is = null;
        URI fullURI = null;
        try {
            if (this.resourceProvider.isLocal()) {
                try {
                    File localFile = new File(path);
                    fullURI = localFile.toURI();
                    mimeType = Files.probeContentType(localFile.toPath());
                }
                catch (IOException e) {
                    mimeType = this.mimeFromExtension(path);
                }
            } else {
                fullURI = new URI(path);
                mimeType = this.getContentType(fullURI.toURL());
            }
            if (mimeType == null) {
                mimeType = this.mimeFromExtension(path);
            }
            if (fullURI == null) {
                logger.error((Object)("URI for path " + path + " could not be created."));
                return null;
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)(path + " is not correct URI"), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)("Problem with file: " + path), (Throwable)e);
            return null;
        }
        int retries = 10;
        while (retries-- > 0) {
            try {
                URI result;
                String fileName = this.resourceProvider.getFilename(location, this.resourceProvider.isLocal() ? path : fullURI.toString());
                if (this.fileProcessor != null) {
                    File processed = this.fileProcessor.process(fullURI);
                    if (processed == null) {
                        logger.error((Object)("Problem with processing file: " + path));
                        String string = null;
                        return string;
                    }
                    processed.deleteOnExit();
                    is = new FileInputStream(processed);
                    fileName = this.changeExtension(fileName, processed.getName());
                    mimeType = this.mimeFromExtension(fileName);
                } else {
                    is = fullURI.toURL().openStream();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to upload file with name: " + fileName));
                }
                if ((result = this.fsc.uploadFile(recordId, this.resourceProvider.getRepresentationName(), version, fileName, is, mimeType)) == null) continue;
                String fileURL = result.toString();
                int i = fileURL.indexOf(FILES_PART);
                if (i == -1) {
                    String string = fileURL;
                    return string;
                }
                fileURL = fileURL.substring(0, i + FILES_PART.length() + 1);
                String string = fileURL = fileURL + fileName;
                return string;
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Processing HTTP request failed. Upload file: " + this.resourceProvider.getFilename(location, fullURI.toString()) + " for record id: " + recordId + ". Retries left: " + retries));
            }
            catch (SocketTimeoutException e) {
                logger.warn((Object)("Read time out. Upload file: " + this.resourceProvider.getFilename(location, fullURI.toString()) + " for record id: " + recordId + ". Retries left: " + retries));
            }
            catch (ConnectException e) {
                logger.error((Object)("Connection timeout. Upload file: " + this.resourceProvider.getFilename(location, fullURI.toString()) + " for record id: " + recordId + ". Retries left: " + retries));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Could not open input stream to file!", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Problem with detecting mime type from file (" + path + ")"), (Throwable)e);
            }
            catch (MCSException e) {
                logger.error((Object)"ECloud error when uploading file.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"ECloud error when uploading file.", (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Could not close stream.", (Throwable)e);
                }
            }
        }
        logger.warn((Object)("All attempts to upload file failed. Location: " + location + " Path: " + path + " Version: " + version + " RecordId: " + recordId));
        return null;
    }

    private String changeExtension(String fileName, String newFileName) {
        if (fileName == null || newFileName == null) {
            return null;
        }
        int i = fileName.lastIndexOf(46);
        int j = newFileName.lastIndexOf(46);
        if (i > 0 && j > 0) {
            return fileName.substring(0, i) + newFileName.substring(j, newFileName.length());
        }
        return fileName;
    }

    private String getContentType(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        if (this.isRedirect(connection.getResponseCode())) {
            String newUrl = connection.getHeaderField("Location");
            logger.warn((Object)("Original request URL: " + url + " redirected to: " + newUrl));
            return this.getContentType(new URL(newUrl));
        }
        return connection.getContentType();
    }

    private boolean isRedirect(int statusCode) {
        return statusCode != 200 && (statusCode == 302 || statusCode == 301 || statusCode == 303);
    }

    private String mimeFromExtension(String path) {
        int i = path.lastIndexOf(".");
        if (i == -1) {
            return "application/octet-stream";
        }
        return mimeTypes.get(path.substring(i + 1));
    }

    private String getProviderId(String providerId) {
        String mapped = this.dataProvidersMapping.get(providerId);
        if (mapped == null) {
            return providerId;
        }
        return mapped;
    }

    private synchronized String createProvider(String path) {
        String providerId = this.getProviderId(this.resourceProvider.getDataProviderId(path));
        DataProviderProperties providerProps = this.resourceProvider.getDataProviderProperties(path);
        int retries = 10;
        while (retries-- > 0) {
            try {
                this.uis.createProvider(providerId, providerProps);
                return providerId;
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while creating provider " + providerId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (CloudException e) {
                if (e.getCause() instanceof ProviderAlreadyExistsException) {
                    logger.warn((Object)("Provider " + providerId + " already exists."));
                    return providerId;
                }
                logger.error((Object)"Exception when creating provider occured.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Exception when creating provider occured.", (Throwable)e);
            }
        }
        logger.warn((Object)("All attempts to create data provider failed. Provider: " + providerId + " Path: " + path));
        return null;
    }

    private void removeProcessedPaths(String providerId, FilePaths paths) {
        try {
            ArrayList<String> processed = new ArrayList<String>();
            for (String line : Files.readAllLines(FileSystems.getDefault().getPath(".", providerId + TEXT_EXTENSION), Charset.forName("UTF-8"))) {
                StringTokenizer st = new StringTokenizer(line, ";");
                if (!st.hasMoreTokens()) continue;
                processed.add(st.nextToken());
            }
            paths.removeAll(processed);
        }
        catch (IOException e) {
            logger.warn((Object)("Progress file for provider " + providerId + " could not be opened. Returning all paths."));
        }
    }

    private boolean processProvider(String resourceProviderId, FilePaths providerPaths) {
        this.removeProcessedPaths(providerPaths.getIdentifier() != null ? providerPaths.getIdentifier() : resourceProviderId, providerPaths);
        boolean result = true;
        try {
            if (providerPaths.size() > 0) {
                String dataProviderId = this.retrieveDataProviderId(providerPaths);
                if (dataProviderId == null) {
                    logger.error((Object)"Cannot determine data provider.");
                    return false;
                }
                String propsFile = providerPaths.getLocation();
                if (!propsFile.endsWith(dataProviderId)) {
                    propsFile = propsFile + LINUX_SEPARATOR + dataProviderId;
                }
                if (this.createProvider(propsFile = propsFile + LINUX_SEPARATOR + dataProviderId + ".properties") == null) {
                    return false;
                }
                ArrayList<String> duplicates = new ArrayList<String>();
                result &= this.processPaths(providerPaths, false, duplicates);
                if (duplicates.size() > 0) {
                    FilePaths duplicatePaths = new FilePaths(providerPaths.getLocation(), providerPaths.getDataProvider());
                    duplicatePaths.setIdentifier(providerPaths.getIdentifier());
                    duplicatePaths.getFullPaths().addAll(duplicates);
                    result &= this.processPaths(duplicatePaths, true, null);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveDataProviderId(FilePaths providerPaths) {
        String path = null;
        BufferedReader reader = providerPaths.getPathsReader();
        if (reader != null) {
            try {
                path = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String string = path = providerPaths.size() > 0 ? providerPaths.getFullPaths().get(0) : null;
        }
        if (path == null) {
            return null;
        }
        return this.resourceProvider.getDataProviderId(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPaths(FilePaths fp, boolean duplicate, List<String> duplicates) throws IOException {
        if (fp == null) {
            return false;
        }
        String resourceProviderId = fp.getDataProvider();
        String location = fp.getLocation();
        String identifier = fp.getIdentifier();
        HashMap<String, String> cloudIds = new HashMap<String, String>();
        HashMap<String, String> versionIds = new HashMap<String, String>();
        HashMap processed = new HashMap();
        HashMap<String, Integer> fileCount = new HashMap<String, Integer>();
        int counter = 0;
        int errors = 0;
        int size = fp.size();
        if (size == 0) {
            return false;
        }
        String prevLocalId = null;
        try (BufferedReader reader = fp.getPathsReader();){
            while (true) {
                String fileAdded;
                String path;
                if ((int)((float)counter / (float)size * 100.0f) > (int)((float)(counter - 1) / (float)size * 100.0f)) {
                    logger.info((Object)("Resource provider: " + resourceProviderId + "." + (identifier.equals(resourceProviderId) ? "" : " Part: " + identifier + ".") + " Progress: " + counter + " of " + size + " (" + (int)((float)counter / (float)size * 100.0f) + "%). Errors: " + errors + ". Duplicates: " + duplicate));
                }
                if (reader == null) {
                    if (counter >= size) break;
                    path = fp.getFullPaths().get(counter);
                } else {
                    path = reader.readLine();
                    if (path == null) break;
                }
                ++counter;
                String localId = this.resourceProvider.getLocalIdentifier(location, path, duplicate);
                if (localId == null) {
                    if (!duplicate && this.resourceProvider.getLocalIdentifier(location, path, true) != null) {
                        duplicates.add(path);
                    }
                    logger.warn((Object)("Local identifier for path: " + path + " could not be obtained. Skipping path..."));
                    continue;
                }
                if (!duplicate && this.resourceProvider.getLocalIdentifier(location, path, true) != null) {
                    duplicates.add(path);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local identifier for path: " + path + ": " + localId));
                }
                if (!localId.equals(prevLocalId)) {
                    if (prevLocalId != null && cloudIds.get(prevLocalId) != null && versionIds.get(prevLocalId) != null && this.resourceProvider.getFileCount(prevLocalId) == ((Integer)fileCount.get(prevLocalId)).intValue()) {
                        URI persistent;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Record " + prevLocalId + " complete. Saving..."));
                        }
                        if ((persistent = this.persistVersion((String)cloudIds.get(prevLocalId), (String)versionIds.get(prevLocalId))) != null) {
                            if (!this.permitVersion((String)cloudIds.get(prevLocalId), (String)versionIds.get(prevLocalId))) {
                                logger.warn((Object)("Could not grant permissions to version " + (String)versionIds.get(prevLocalId) + " of record " + (String)cloudIds.get(prevLocalId) + ". Version is only available for current user."));
                            }
                            this.saveProgress(fp.getIdentifier() != null ? fp.getIdentifier() : resourceProviderId, (List)processed.get(versionIds.get(prevLocalId)), false, null);
                            ((List)processed.get(versionIds.get(prevLocalId))).clear();
                            processed.remove(versionIds.get(prevLocalId));
                            cloudIds.remove(prevLocalId);
                            versionIds.remove(prevLocalId);
                        }
                    }
                    prevLocalId = localId;
                }
                if (cloudIds.get(localId) == null) {
                    String cloudId = this.createRecord(this.resourceProvider.getDataProviderId(path), localId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Cloud identifier for path: " + path + ": " + cloudId));
                    }
                    if (cloudId == null) {
                        ++errors;
                        continue;
                    }
                    cloudIds.put(localId, cloudId);
                    URI uri = this.createRepresentationName(this.resourceProvider.getDataProviderId(path), cloudId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Representation for path: " + path + ": " + (uri != null ? uri.toString() : "null")));
                    }
                    if (uri == null) continue;
                    String verId = this.getVersionIdentifier(uri);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Version identifier for path: " + path + ": " + verId));
                    }
                    if (verId == null) {
                        ++errors;
                        continue;
                    }
                    versionIds.put(localId, verId);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Before creating file: \nLocation: " + location + "\nPath: " + path + "\nVersion: " + (String)versionIds.get(localId) + "\nCloudId: " + (String)cloudIds.get(localId)));
                }
                if ((fileAdded = this.createFilename(location, path, (String)versionIds.get(localId), (String)cloudIds.get(localId))) == null) {
                    prevLocalId = null;
                    continue;
                }
                if (processed.get(versionIds.get(localId)) == null) {
                    processed.put(versionIds.get(localId), new ArrayList());
                }
                ((List)processed.get(versionIds.get(localId))).add(path + ";" + fileAdded);
                fileCount.put(localId, fileCount.get(localId) != null ? (Integer)fileCount.get(localId) + 1 : 1);
            }
            if (prevLocalId != null && this.resourceProvider.getFileCount(prevLocalId) == ((Integer)fileCount.get(prevLocalId)).intValue()) {
                URI persistent;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Record " + prevLocalId + " complete. Saving..."));
                }
                if ((persistent = this.persistVersion((String)cloudIds.get(prevLocalId), (String)versionIds.get(prevLocalId))) != null) {
                    if (!this.permitVersion((String)cloudIds.get(prevLocalId), (String)versionIds.get(prevLocalId))) {
                        logger.warn((Object)("Could not grant permissions to version " + (String)versionIds.get(prevLocalId) + " of record " + (String)cloudIds.get(prevLocalId) + ". Version is only available for current user."));
                    }
                    this.saveProgress(fp.getIdentifier() != null ? fp.getIdentifier() : resourceProviderId, (List)processed.get(versionIds.get(prevLocalId)), false, null);
                    ((List)processed.get(versionIds.get(prevLocalId))).clear();
                    processed.remove(versionIds.get(prevLocalId));
                    cloudIds.remove(prevLocalId);
                    versionIds.remove(prevLocalId);
                }
            }
        }
        if (errors > 0) {
            logger.warn((Object)("Migration of " + resourceProviderId + " encoutered " + errors + " errors."));
        }
        return counter - errors == size;
    }

    private void saveProgress(String providerId, List<String> strings, boolean truncate, String prefix) {
        try {
            Path dest = FileSystems.getDefault().getPath(".", (prefix != null ? prefix : "") + providerId + TEXT_EXTENSION);
            if (truncate) {
                Path bkp = FileSystems.getDefault().getPath(".", (prefix != null ? prefix : "") + providerId + ".bkp");
                int c = 0;
                while (Files.exists(bkp, new LinkOption[0])) {
                    bkp = FileSystems.getDefault().getPath(".", (prefix != null ? prefix : "") + providerId + ".bkp" + String.valueOf(c++));
                }
                if (Files.exists(dest, new LinkOption[0])) {
                    Files.copy(dest, bkp, new CopyOption[0]);
                }
                Files.write(dest, strings, Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            } else {
                Files.write(dest, strings, Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Progress file " + (prefix != null ? prefix : "") + providerId + ".txt could not be saved."), (Throwable)e);
        }
    }

    private URI persistVersion(String cloudId, String version) {
        int retries = 10;
        while (retries-- > 0) {
            try {
                return this.mcs.persistRepresentation(cloudId, this.resourceProvider.getRepresentationName(), version);
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while persisting version: " + version + " for record: " + cloudId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (MCSException e) {
                logger.error((Object)("ECloud error when persisting version: " + version + " for record: " + cloudId), (Throwable)e);
                if (e.getCause() instanceof ConnectException) {
                    logger.warn((Object)("Connection timeout error when persisting version: " + version + " for record: " + cloudId + ". Retries left: " + retries));
                    continue;
                }
                if (!(e.getCause() instanceof SocketTimeoutException)) break;
                logger.warn((Object)("Read time out error when persisting version: " + version + " for record: " + cloudId + ". Retries left: " + retries));
            }
        }
        return null;
    }

    private boolean permitVersion(String cloudId, String version) {
        int retries = 10;
        while (retries-- > 0) {
            try {
                this.mcs.permitVersion(cloudId, this.resourceProvider.getRepresentationName(), version);
                return true;
            }
            catch (ProcessingException e) {
                logger.warn((Object)("Error processing HTTP request while granting permissions to version: " + version + " for record: " + cloudId + ". Retries left: " + retries), (Throwable)e);
            }
            catch (MCSException e) {
                logger.error((Object)("ECloud error when granting permissions to version: " + version + " for record: " + cloudId), (Throwable)e);
                if (e.getCause() instanceof ConnectException) {
                    logger.warn((Object)("Connection timeout error when granting permissions to version: " + version + " for record: " + cloudId + ". Retries left: " + retries));
                    continue;
                }
                if (!(e.getCause() instanceof SocketTimeoutException)) break;
                logger.warn((Object)("Read time out error when granting permissions to version: " + version + " for record: " + cloudId + ". Retries left: " + retries));
            }
        }
        return false;
    }

    private String getVersionIdentifier(URI uri) {
        String uriStr = uri.toString();
        int pos = uriStr.lastIndexOf(LINUX_SEPARATOR);
        if (pos != -1) {
            return uriStr.substring(pos + 1);
        }
        return null;
    }

    public void verify() {
        long start = System.currentTimeMillis();
        Map<String, List<FilePaths>> paths = this.resourceProvider.scan();
        logger.info((Object)("Scanning resource provider locations finished in " + String.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f) + " sec."));
        List results = null;
        ArrayList<ProviderVerifier> tasks = new ArrayList<ProviderVerifier>();
        for (String providerId : paths.keySet()) {
            logger.info((Object)("Starting verification task thread for provider " + providerId + "..."));
            tasks.add(new ProviderVerifier(providerId, paths.get(providerId), null));
        }
        if (tasks.size() == 0) {
            return;
        }
        try {
            results = threadPool.invokeAll(tasks);
            for (Future result : results) {
                VerificationResult providerResult = (VerificationResult)result.get();
                logger.info((Object)("Verification of provider " + providerResult.getProviderId() + " performed successfully. Verification time: " + providerResult.getTime() + " sec. Number of not migrated files: " + providerResult.getNotMigratedCount()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Verification processed interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Problem with verification task thread execution.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long verifyProvider(String resourceProviderId, FilePaths providerPaths) {
        BufferedReader reader = providerPaths.getPathsReader();
        String line = "";
        String localId = "";
        HashMap<String, String> cloudIds = new HashMap<String, String>();
        ArrayList<String> strings = new ArrayList<String>();
        HashSet<String> migratedLocalIds = new HashSet<String>();
        HashSet<String> notExistingLocalIds = new HashSet<String>();
        long count = 0L;
        int counter = 0;
        int total = providerPaths.size();
        String identifier = providerPaths.getIdentifier();
        try {
            block12: while (true) {
                try {
                    while (true) {
                        List representations;
                        if ((int)((float)counter / (float)total * 100.0f) > (int)((float)(counter - 1) / (float)total * 100.0f)) {
                            logger.info((Object)("Resource provider: " + resourceProviderId + "." + (identifier.equals(resourceProviderId) ? "" : " Part: " + identifier + ".") + " Progress: " + counter + " of " + total + " (" + (int)((float)counter / (float)total * 100.0f) + "%)."));
                        }
                        if (reader == null) {
                            if (counter >= total) break block12;
                            line = providerPaths.getFullPaths().get(counter);
                        } else {
                            line = reader.readLine();
                            if (line == null) break block12;
                        }
                        ++counter;
                        localId = this.resourceProvider.getLocalIdentifier(providerPaths.getLocation(), line, false);
                        if (localId == null) {
                            strings.add(line + " (no local id)");
                            continue;
                        }
                        if (migratedLocalIds.contains(localId)) continue;
                        if (cloudIds.get(localId) == null) {
                            if (notExistingLocalIds.contains(localId)) continue;
                            String cloudId = this.getRecord(this.resourceProvider.getDataProviderId(line), localId);
                            if (cloudId == null) {
                                strings.add(line + " (upload " + localId + ")");
                                notExistingLocalIds.add(localId.intern());
                                count += (long)(this.resourceProvider.getFileCount(localId) - 1);
                                continue;
                            }
                            cloudIds.put(localId, cloudId);
                        }
                        if ((representations = this.mcs.getRepresentations((String)cloudIds.get(localId), this.resourceProvider.getRepresentationName())) == null || representations.size() == 0) {
                            strings.add(line.intern());
                            continue;
                        }
                        boolean persistent = false;
                        int fileCount = 0;
                        for (Representation representation : representations) {
                            if (representation.isPersistent()) {
                                persistent = true;
                                break;
                            }
                            int size = representation.getFiles().size();
                            if (size <= fileCount) continue;
                            fileCount = size;
                        }
                        if (!persistent) {
                            if (fileCount == this.resourceProvider.getFileCount(localId)) {
                                strings.add(line + " (persist " + localId + ")");
                            } else {
                                strings.add(line + " (upload " + localId + ")");
                            }
                            count += (long)(this.resourceProvider.getFileCount(localId) - 1);
                        }
                        migratedLocalIds.add(localId.intern());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (RecordNotExistsException e) {
                    strings.add(line + " (upload " + localId + ")");
                    continue;
                }
                catch (RepresentationNotExistsException e) {
                    strings.add(line + " (upload " + localId + ")");
                    continue;
                }
                catch (MCSException e) {
                    logger.error((Object)"Problem with getting representation.");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            this.saveProgress(providerPaths.getIdentifier() != null ? providerPaths.getIdentifier() : resourceProviderId, strings, true, "verify_");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return (long)strings.size() + count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProgressFromThreads(String providerId, List<FilePaths> paths) {
        BufferedReader reader = null;
        try {
            Path dest = FileSystems.getDefault().getPath(".", providerId + TEXT_EXTENSION);
            if (Files.exists(dest, new LinkOption[0])) {
                Path bkp = FileSystems.getDefault().getPath(".", providerId + ".bkp");
                int c = 0;
                while (Files.exists(bkp, new LinkOption[0])) {
                    bkp = FileSystems.getDefault().getPath(".", providerId + ".bkp" + String.valueOf(c++));
                }
                Files.copy(dest, bkp, new CopyOption[0]);
                Files.delete(dest);
            }
            for (FilePaths fp : paths) {
                if (fp.getIdentifier() == null || fp.getIdentifier().equals(providerId)) continue;
                Path progressFile = FileSystems.getDefault().getPath(".", fp.getIdentifier() + TEXT_EXTENSION);
                try {
                    String line;
                    reader = Files.newBufferedReader(progressFile, Charset.forName("UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if (!line.endsWith("\n")) {
                            line = line + "\n";
                        }
                        Files.write(dest, line.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)("Problem with file " + progressFile.toAbsolutePath().toString()));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Progress file " + providerId + ".txt could not be saved."), (Throwable)e);
        }
    }

    public void clean(String providerId) {
        try {
            ArrayList<String> toSave = new ArrayList<String>();
            new Cleaner().cleanRecords(providerId, this.mcs, this.uis);
            block8: for (String line : Files.readAllLines(FileSystems.getDefault().getPath(".", providerId + TEXT_EXTENSION), Charset.forName("UTF-8"))) {
                String url;
                int pos;
                StringTokenizer st = new StringTokenizer(line, ";");
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if ((pos = (url = st.nextToken()).indexOf("/records/")) <= -1) continue;
                String id = url.substring(pos + "/records/".length());
                id = id.substring(0, id.indexOf(LINUX_SEPARATOR));
                int retries = 10;
                while (retries-- > 0) {
                    try {
                        this.mcs.deleteRecord(id);
                        this.uis.deleteCloudId(id);
                        continue block8;
                    }
                    catch (ProcessingException e) {
                        logger.warn((Object)("Error processing HTTP request while deleting record: " + id + ". Retries left: " + retries), (Throwable)e);
                        if (retries != 0) continue;
                        toSave.add(line);
                    }
                    catch (RecordNotExistsException e) {
                        continue block8;
                    }
                    catch (CloudException e) {
                        logger.warn((Object)"Could not delete record.", (Throwable)e);
                        if (retries != 0) continue;
                        toSave.add(line);
                    }
                    catch (MCSException e) {
                        logger.warn((Object)"Could not delete record.", (Throwable)e);
                        if (retries != 0) continue;
                        toSave.add(line);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Could not delete record.", (Throwable)e);
                        if (retries != 0) continue;
                        toSave.add(line);
                    }
                }
            }
            this.saveProgress(providerId, toSave, true, null);
        }
        catch (IOException e) {
            logger.error((Object)"Problem with file.", (Throwable)e);
        }
    }

    static {
        mimeTypes.put("jp2", "image/jp2");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("xml", "text/xml");
        threadPool = Executors.newFixedThreadPool(10);
    }

    private class PublicAccessGranterResult {
        String identifier;
        float time;
        long notGranted;

        PublicAccessGranterResult(long notGranted, float time, String identifier) {
            this.notGranted = notGranted;
            this.time = time;
            this.identifier = identifier;
        }

        long getNotGrantedCount() {
            return this.notGranted;
        }

        float getTime() {
            return this.time;
        }

        String getIdentifier() {
            return this.identifier;
        }
    }

    private class PublicAccessGranter
    implements Callable<PublicAccessGranterResult> {
        private List<String> localIds;
        private String identifier;
        private boolean simulate;

        PublicAccessGranter(List<String> localIds, String identifier, boolean simulate) {
            this.localIds = localIds;
            this.identifier = identifier;
            this.simulate = simulate;
        }

        @Override
        public PublicAccessGranterResult call() throws Exception {
            long start = System.currentTimeMillis();
            long notGranted = 0L;
            int counter = 0;
            int total = this.localIds.size();
            ArrayList<String> strings = new ArrayList<String>();
            ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, true, "grantaccess_" + this.identifier + "_");
            for (String localId : this.localIds) {
                if ((int)((float)counter / (float)total * 100.0f) > (int)((float)(counter - 1) / (float)total * 100.0f)) {
                    logger.info((Object)("Granting public access part " + this.identifier + " progress: " + counter + " of " + total + " (" + (int)((float)counter / (float)total * 100.0f) + "%)."));
                    if (!strings.isEmpty()) {
                        ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, false, "grantaccess_" + this.identifier + "_");
                        notGranted += (long)strings.size();
                        strings.clear();
                    }
                }
                ++counter;
                String cloudId = ResourceMigrator.this.getRecord(ResourceMigrator.this.resourceProvider.getDataProviderId(""), localId);
                if (cloudId == null) continue;
                List representations = null;
                try {
                    representations = ResourceMigrator.this.mcs.getRepresentations(cloudId, ResourceMigrator.this.resourceProvider.getRepresentationName());
                }
                catch (MCSException e) {
                    logger.warn((Object)e.getMessage());
                }
                if (representations == null || representations.isEmpty()) continue;
                boolean noPersistentVersion = true;
                for (Representation representation : representations) {
                    if (!representation.isPersistent()) continue;
                    noPersistentVersion = false;
                    if (this.accessible(representation)) continue;
                    if (!this.simulate) {
                        ResourceMigrator.this.mcs.permitVersion(cloudId, representation.getRepresentationName(), representation.getVersion());
                    }
                    strings.add(localId + ";no permissions for persistent version");
                    break;
                }
                if (!noPersistentVersion) continue;
                strings.add(localId + ";no persistent version");
            }
            if (!strings.isEmpty()) {
                ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, false, "grantaccess_" + this.identifier + "_");
                notGranted += (long)strings.size();
            }
            return new PublicAccessGranterResult(notGranted, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
        }

        private boolean accessible(Representation representation) throws IOException {
            URL url = new URL(representation.getAllVersionsUri() + ResourceMigrator.LINUX_SEPARATOR + representation.getVersion());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            connection.disconnect();
            return code != Response.Status.METHOD_NOT_ALLOWED.getStatusCode();
        }
    }

    private class LocalIdVerificationResult {
        String identifier;
        float time;
        long notMigrated;

        LocalIdVerificationResult(long notMigrated, float time, String identifier) {
            this.notMigrated = notMigrated;
            this.time = time;
            this.identifier = identifier;
        }

        long getNotMigratedCount() {
            return this.notMigrated;
        }

        float getTime() {
            return this.time;
        }

        String getIdentifier() {
            return this.identifier;
        }
    }

    private class LocalIdVerifier
    implements Callable<LocalIdVerificationResult> {
        private List<String> localIds;
        private String identifier;

        LocalIdVerifier(List<String> localIds, String identifier) {
            this.localIds = localIds;
            this.identifier = identifier;
        }

        @Override
        public LocalIdVerificationResult call() throws Exception {
            long start = System.currentTimeMillis();
            long notMigrated = 0L;
            int counter = 0;
            int total = this.localIds.size();
            ArrayList<String> strings = new ArrayList<String>();
            ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, true, "verifylocalids_" + this.identifier + "_");
            Iterator<String> i = this.localIds.iterator();
            while (i.hasNext()) {
                if ((int)((float)counter / (float)total * 100.0f) > (int)((float)(counter - 1) / (float)total * 100.0f)) {
                    logger.info((Object)("Local identifiers verification part " + this.identifier + " progress: " + counter + " of " + total + " (" + (int)((float)counter / (float)total * 100.0f) + "%)."));
                    if (strings.size() > 0) {
                        ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, false, "verifylocalids_" + this.identifier + "_");
                        notMigrated += (long)strings.size();
                        strings.clear();
                    }
                }
                ++counter;
                String localId = i.next();
                String cloudId = ResourceMigrator.this.getRecord(ResourceMigrator.this.resourceProvider.getDataProviderId(""), localId);
                if (cloudId == null) {
                    String path = ResourceMigrator.this.getPathFromMapping(ResourceMigrator.this.resourceProvider.getReversedMapping(), localId);
                    strings.add(localId + ";" + path);
                    continue;
                }
                List representations = null;
                try {
                    representations = ResourceMigrator.this.mcs.getRepresentations(cloudId, ResourceMigrator.this.resourceProvider.getRepresentationName());
                }
                catch (MCSException e) {
                    e.printStackTrace();
                }
                if (representations == null || representations.size() == 0) {
                    strings.add(localId + ";no representation");
                    continue;
                }
                boolean persistent = false;
                int fileCount = 0;
                for (Representation representation : representations) {
                    if (representation.isPersistent()) {
                        persistent = true;
                        break;
                    }
                    int size = representation.getFiles().size();
                    if (size <= fileCount) continue;
                    fileCount = size;
                }
                if (persistent) continue;
                if (fileCount == ResourceMigrator.this.resourceProvider.getFileCount(localId)) {
                    strings.add(localId + ";no persistent representation");
                    continue;
                }
                strings.add(localId + ";representation incomplete");
            }
            if (strings.size() > 0) {
                ResourceMigrator.this.saveProgress(ResourceMigrator.this.resourceProvider.getDataProviderId(""), strings, false, "verifylocalids_" + this.identifier + "_");
                notMigrated += (long)strings.size();
            }
            return new LocalIdVerificationResult(notMigrated, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
        }
    }

    private class VerificationResult {
        String providerId;
        String identifier;
        float time;
        long notMigrated;

        VerificationResult(long notMigrated, String providerId, float time, String identifier) {
            this.notMigrated = notMigrated;
            this.providerId = providerId;
            this.time = time;
            this.identifier = identifier;
        }

        String getProviderId() {
            return this.providerId;
        }

        long getNotMigratedCount() {
            return this.notMigrated;
        }

        float getTime() {
            return this.time;
        }

        String getIdentifier() {
            return this.identifier;
        }
    }

    private class ProviderVerifier
    implements Callable<VerificationResult> {
        private String providerId;
        private List<FilePaths> paths;
        private String identifier;
        private final ExecutorService threadProviderPool;

        ProviderVerifier(String providerId, List<FilePaths> paths, String identifier) {
            this.threadProviderPool = Executors.newFixedThreadPool(ResourceMigrator.this.threadsCount);
            this.providerId = providerId;
            this.paths = paths;
            this.identifier = identifier;
        }

        @Override
        public VerificationResult call() throws Exception {
            long start = System.currentTimeMillis();
            long notMigrated = 0L;
            List<FilePaths> split = ResourceMigrator.this.resourceProvider.split(this.paths);
            if (split.equals(this.paths)) {
                for (FilePaths fp : this.paths) {
                    notMigrated += ResourceMigrator.this.verifyProvider(this.providerId, fp);
                }
            } else {
                List results = null;
                ArrayList<ProviderVerifier> tasks = new ArrayList<ProviderVerifier>();
                for (FilePaths fp : split) {
                    logger.info((Object)("Starting verification task thread for file paths " + fp.getIdentifier() + "..."));
                    ArrayList<FilePaths> lst = new ArrayList<FilePaths>();
                    lst.add(fp);
                    tasks.add(new ProviderVerifier(this.providerId, lst, fp.getIdentifier()));
                }
                try {
                    results = this.threadProviderPool.invokeAll(tasks);
                    for (Future result : results) {
                        VerificationResult partResult = (VerificationResult)result.get();
                        logger.info((Object)("Verification of part " + partResult.getIdentifier() + " (" + partResult.getProviderId() + ") performed successfully. Verification time: " + partResult.getTime() + " sec. Number of not migrated files: " + partResult.getNotMigratedCount()));
                        notMigrated += partResult.getNotMigratedCount();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Verification processed interrupted.", (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error((Object)"Problem with verification task thread execution.", (Throwable)e);
                }
            }
            return new VerificationResult(notMigrated, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
        }
    }

    private class MigrationResult {
        Boolean success;
        String providerId;
        String identifier;
        float time;

        MigrationResult(Boolean success, String providerId, float time, String identifier) {
            this.success = success;
            this.providerId = providerId;
            this.time = time;
            this.identifier = identifier;
        }

        String getProviderId() {
            return this.providerId;
        }

        Boolean isSuccessful() {
            return this.success;
        }

        float getTime() {
            return this.time;
        }

        String getIdentifier() {
            return this.identifier;
        }
    }

    private class ProviderMigrator
    implements Callable<MigrationResult> {
        private String providerId;
        private List<FilePaths> paths;
        private String identifier;
        private final ExecutorService threadProviderPool;

        ProviderMigrator(String providerId, List<FilePaths> paths, String identifier) {
            this.threadProviderPool = Executors.newFixedThreadPool(ResourceMigrator.this.threadsCount);
            this.providerId = providerId;
            this.paths = paths;
            this.identifier = identifier;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public MigrationResult call() throws Exception {
            long start = System.currentTimeMillis();
            boolean success = true;
            List<FilePaths> split = ResourceMigrator.this.resourceProvider.split(this.paths);
            if (split.equals(this.paths)) {
                for (FilePaths fp : this.paths) {
                    success &= ResourceMigrator.this.processProvider(this.providerId, fp);
                }
                return new MigrationResult(success, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
            } else {
                List results = null;
                ArrayList<ProviderMigrator> tasks = new ArrayList<ProviderMigrator>();
                boolean mergeProgress = false;
                for (FilePaths fp : split) {
                    logger.info((Object)("Starting task thread for file paths " + fp.getIdentifier() + "..."));
                    ArrayList<FilePaths> lst = new ArrayList<FilePaths>();
                    lst.add(fp);
                    mergeProgress |= !fp.getIdentifier().equals(fp.getDataProvider());
                    tasks.add(new ProviderMigrator(this.providerId, lst, fp.getIdentifier()));
                }
                try {
                    results = this.threadProviderPool.invokeAll(tasks);
                    for (Future result : results) {
                        MigrationResult partResult = (MigrationResult)result.get();
                        logger.info((Object)("Migration of part " + partResult.getIdentifier() + " (" + partResult.getProviderId() + ") performed " + (partResult.isSuccessful() != false ? "" : "un") + "successfully. Migration time: " + partResult.getTime() + " sec."));
                        success &= partResult.isSuccessful().booleanValue();
                    }
                    if (!mergeProgress) return new MigrationResult(success, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
                    ResourceMigrator.this.saveProgressFromThreads(this.providerId, split);
                    return new MigrationResult(success, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Migration processed interrupted.", (Throwable)e);
                    return new MigrationResult(success, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
                }
                catch (ExecutionException e) {
                    logger.error((Object)"Problem with migration task thread execution.", (Throwable)e);
                }
            }
            return new MigrationResult(success, this.providerId, (float)(System.currentTimeMillis() - start) / 1000.0f, this.identifier);
        }
    }
}

