/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.migrator.provider.DefaultResourceProvider;
import eu.europeana.cloud.migrator.provider.FilePaths;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class EuropeanaNewspapersResourceProvider
extends DefaultResourceProvider {
    public static final String IMAGE_DIR = "image";
    private Map<String, String> reversedMapping = new HashMap<String, String>();
    private Map<String, String> duplicateMapping = new HashMap<String, String>();
    private Map<String, Integer> fileCounts = new HashMap<String, Integer>();
    private static final Logger logger = Logger.getLogger(EuropeanaNewspapersResourceProvider.class);

    public EuropeanaNewspapersResourceProvider(String representationName, String mappingFile, String locations, String dataProviderId) throws IOException {
        super(representationName, mappingFile, locations, dataProviderId);
        if (dataProviderId == null) {
            throw new IllegalArgumentException("Data provider identifier must be specified for Europeana Newspapers migration!");
        }
        this.readMappingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMappingFile() throws IOException {
        Path mappingPath = null;
        try {
            mappingPath = FileSystems.getDefault().getPath(".", this.mappingFile);
            if (!mappingPath.toFile().exists()) {
                mappingPath = FileSystems.getDefault().getPath(this.mappingFile, new String[0]);
            }
        }
        catch (InvalidPathException e) {
            mappingPath = FileSystems.getDefault().getPath(this.mappingFile, new String[0]);
            logger.info((Object)("Invalid Path exception. Mapping file " + this.mappingFile + " as absolute path: " + mappingPath));
        }
        if (mappingPath == null || !mappingPath.toFile().exists()) {
            throw new IOException("Mapping file cannot be found: " + this.mappingFile);
        }
        ArrayList<String> paths = new ArrayList<String>();
        try (BufferedReader reader = null;){
            String line;
            reader = Files.newBufferedReader(mappingPath, Charset.forName("UTF-8"));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, ";");
                String localId = tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : null;
                if (localId == null) {
                    logger.warn((Object)("Local identifier is null (" + localId + "). Skipping line."));
                    continue;
                }
                boolean duplicate = false;
                paths.clear();
                int count = 0;
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken().trim();
                    if (path.isEmpty()) continue;
                    if (this.reversedMapping.get(path) != null && !duplicate) {
                        logger.warn((Object)("File " + path + " already has a local id = " + this.reversedMapping.get(path) + ". New local id = " + localId));
                        duplicate = true;
                        for (String s : paths) {
                            this.reversedMapping.remove(s);
                            this.duplicateMapping.put(s, localId.intern());
                        }
                    }
                    if (duplicate) {
                        this.duplicateMapping.put(path, localId.intern());
                    } else {
                        this.reversedMapping.put(path.intern(), localId.intern());
                        paths.add(path.intern());
                    }
                    ++count;
                }
                this.fileCounts.put(localId.intern(), count);
            }
        }
    }

    @Override
    public String getResourceProviderId(String path) {
        if (!path.contains(IMAGE_DIR)) {
            logger.error((Object)"No image directory found in resource path.");
            return null;
        }
        int pos = path.indexOf(IMAGE_DIR);
        String rest = path.substring(pos + IMAGE_DIR.length());
        if (rest.startsWith("/") || rest.startsWith("\\")) {
            rest = rest.substring(1);
        }
        if ((pos = rest.indexOf("/")) == -1) {
            pos = rest.indexOf("\\");
        }
        return rest.substring(0, pos > -1 ? pos : rest.length());
    }

    @Override
    public String getDataProviderId(String path) {
        return this.dataProviderId;
    }

    @Override
    public DataProviderProperties getDataProviderProperties(String path) {
        File dpFile;
        String id = this.getDataProviderId(path);
        if (id == null) {
            throw new IllegalArgumentException("Data provider identifier must be specified for Europeana Newspapers migration!");
        }
        File f = new File(path);
        if (f.exists() && f.isFile() && f.getName().equals(id + ".properties")) {
            return this.getDataProviderPropertiesFromFile(f);
        }
        if (f.isDirectory() && (dpFile = new File(f, id + ".properties")).exists()) {
            return this.getDataProviderPropertiesFromFile(dpFile);
        }
        return this.getDefaultDataProviderProperties();
    }

    @Override
    public String getLocalIdentifier(String location, String path, boolean duplicate) {
        String localId;
        String localPath = this.getLocalPath(location, path);
        String string = localId = duplicate ? this.duplicateMapping.get(localPath) : this.reversedMapping.get(localPath);
        if (localId == null && !duplicate) {
            logger.warn((Object)("Local identifier for file " + localPath + " was not found in the mapping file!"));
        }
        return localId;
    }

    private String getLocalPath(String location, String path) {
        int i = path.indexOf(location);
        if (i == -1) {
            return path;
        }
        return path.substring(i + location.length() + 1);
    }

    @Override
    public int getFileCount(String localId) {
        Integer count = this.fileCounts.get(localId);
        if (count == null) {
            return -1;
        }
        return count;
    }

    @Override
    public List<FilePaths> split(List<FilePaths> paths) {
        ArrayList<FilePaths> result = new ArrayList<FilePaths>();
        for (FilePaths fp : paths) {
            result.addAll(this.split(fp, true));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilePaths> split(FilePaths fp, boolean year) {
        ArrayList<FilePaths> result = new ArrayList<FilePaths>();
        HashMap titlePaths = new HashMap();
        BufferedReader pathsReader = fp.getPathsReader();
        try {
            String path;
            while ((path = pathsReader.readLine()) != null) {
                int i = path.indexOf(fp.getLocation());
                i = path.indexOf(fp.getDataProvider(), i == -1 ? 0 : i + fp.getLocation().length() + 1);
                if (i == -1) {
                    result.add(fp);
                    ArrayList<FilePaths> arrayList = result;
                    return arrayList;
                }
                String title = path.substring(i + fp.getDataProvider().length() + 1);
                if ((i = title.indexOf("/")) == -1) {
                    result.add(fp);
                    ArrayList<FilePaths> e = result;
                    return e;
                }
                if (year) {
                    int j = title.indexOf("/", i + 1);
                    String yearStr = title.substring(i + 1, j);
                    i = yearStr.length() < 4 ? title.indexOf("/", j + 1) : j;
                }
                if (titlePaths.get(title = title.substring(0, i)) == null) {
                    titlePaths.put(title, new ArrayList());
                }
                ((List)titlePaths.get(title)).add(path);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Cannot read paths file for location " + fp.getLocation() + " and provider " + fp.getDataProvider()));
        }
        finally {
            if (pathsReader != null) {
                try {
                    pathsReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (titlePaths.size() == 1) {
            result.add(fp);
        } else {
            for (Map.Entry entry : titlePaths.entrySet()) {
                FilePaths filePaths = new FilePaths(fp.getLocation(), fp.getDataProvider());
                filePaths.setIdentifier(((String)entry.getKey()).replace("/", "_"));
                filePaths.useFile(filePaths.getIdentifier());
                filePaths.addPaths((List)entry.getValue());
                result.add(filePaths);
            }
        }
        return result;
    }

    @Override
    public boolean usePathsFile() {
        return true;
    }

    @Override
    public Map<String, String> getReversedMapping() {
        return this.reversedMapping;
    }
}

