/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.processing;

import eu.europeana.cloud.migrator.processing.CommandExecutor;
import eu.europeana.cloud.migrator.processing.FileProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JPEG2JP2000Converter
extends CommandExecutor
implements FileProcessor {
    private static final Logger logger = Logger.getLogger(JPEG2JP2000Converter.class);
    private static final int JPEG_TO_TIFF_COMMAND_ID = 0;
    private static final int TIFF_TO_JP2000_COMMAND_ID = 1;
    private static final String TIFF_EXTENSION = ".tiff";
    private static final String JP2000_EXTENSION = ".jp2";

    public JPEG2JP2000Converter(String configFile) {
        super(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File process(URI fileURI) {
        File outFolder = new File(this.workingDirectory);
        File tiff = null;
        File jp2 = null;
        try {
            tiff = File.createTempFile("convert", TIFF_EXTENSION, outFolder);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(Paths.get(fileURI).toAbsolutePath().toString().replace("\\", "/"));
            parameters.add(tiff.getAbsolutePath());
            if (!this.runCommand(0, parameters).getResult()) {
                logger.error((Object)"Error while converting jpeg to tiff.");
                File file = null;
                return file;
            }
            jp2 = File.createTempFile("convert", JP2000_EXTENSION, outFolder);
            parameters.clear();
            parameters.add(tiff.getAbsolutePath());
            parameters.add(jp2.getAbsolutePath());
            if (!this.runCommand(1, parameters).getResult()) {
                logger.error((Object)"Error while converting tiff to jp2000.");
                if (jp2 != null) {
                    jp2.delete();
                }
                File file = null;
                return file;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Problem while converting from JPEG to JP2000.", (Throwable)e);
        }
        finally {
            if (tiff != null) {
                tiff.delete();
            }
        }
        return jp2;
    }
}

