/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilePaths {
    private static final String prefix = "paths_";
    private String location;
    private String dataProvider;
    private String identifier;
    private List<String> paths;
    private boolean useFile = false;
    private String fileName = null;
    private int size = 0;

    public FilePaths(String location, String dataProvider) {
        this.location = location;
        this.dataProvider = dataProvider;
        this.paths = new ArrayList<String>();
        this.identifier = null;
    }

    public void useFile(String file) {
        this.useFile = true;
        this.fileName = file;
        this.clean();
    }

    private void clean() {
        if (!this.useFile || this.fileName == null) {
            return;
        }
        Path dest = FileSystems.getDefault().getPath(".", prefix + this.fileName + ".txt");
        try {
            if (dest.toFile().exists()) {
                Files.write(dest, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getFullPaths() {
        return this.paths;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public int size() {
        if (this.useFile) {
            return this.size;
        }
        return this.paths.size();
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            return this.dataProvider;
        }
        return this.identifier;
    }

    public void addPaths(List<String> pathsToAdd) {
        if (this.paths == null) {
            return;
        }
        for (String path : pathsToAdd) {
            this.addPath(path);
        }
    }

    public void addPath(String path) {
        if (this.useFile && this.fileName != null) {
            this.addPathToFile(path);
        } else {
            this.paths.add(path);
        }
    }

    private void addPathToFile(String path) {
        try {
            Path dest = FileSystems.getDefault().getPath(".", prefix + this.fileName + ".txt");
            Files.write(dest, String.valueOf(path + "\n").getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            ++this.size;
        }
        catch (IOException e) {
            System.out.println("Cannot store path " + path + "in file " + prefix + this.fileName + ".txt");
            e.printStackTrace();
        }
    }

    public BufferedReader getPathsReader() {
        if (this.useFile && this.fileName != null) {
            try {
                return Files.newBufferedReader(FileSystems.getDefault().getPath(".", prefix + this.fileName + ".txt"), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void sort() {
        if (!this.useFile && this.paths.size() > 0) {
            Collections.sort(this.paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<String> processed) {
        BufferedReader reader = this.getPathsReader();
        if (reader == null) {
            this.paths.removeAll(processed);
        } else {
            Path dest = FileSystems.getDefault().getPath(".", prefix + this.fileName + ".tmp");
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (processed.contains(line)) {
                        --this.size;
                        continue;
                    }
                    Files.write(dest, String.valueOf(line + "\n").getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            Path finalDest = FileSystems.getDefault().getPath(".", prefix + this.fileName + ".txt");
            try {
                if (dest.toFile().exists()) {
                    Files.move(dest, finalDest, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.write(finalDest, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
                }
                if (this.size < 0) {
                    this.size = 0;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

