/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.migrator;

import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.migrator.DefaultResourceProvider;
import java.io.File;
import org.apache.log4j.Logger;

public class RoyalArmoryResourceProvider
extends DefaultResourceProvider {
    private static final Logger logger = Logger.getLogger(RoyalArmoryResourceProvider.class);

    public RoyalArmoryResourceProvider(String representationName, String mappingFile, String locations, String dataProviderId) {
        super(representationName, mappingFile, locations, dataProviderId);
    }

    @Override
    public String getLocalIdentifier(String location, String path, boolean duplicate) {
        if (duplicate) {
            return null;
        }
        if (location == null || path == null) {
            return null;
        }
        String fileName = this.getFilename(location, path);
        if (fileName == null) {
            logger.warn((Object)"Path to the image file does not start with location path. Local record identifier cannot be retrieved.");
        }
        return fileName;
    }

    @Override
    public String getResourceProviderId(String path) {
        return this.getDataProviderId(path);
    }

    @Override
    public String getDataProviderId(String path) {
        if (this.dataProviderId == null) {
            throw new IllegalArgumentException("Data provider must be supplied!");
        }
        return this.dataProviderId;
    }

    @Override
    public DataProviderProperties getDataProviderProperties(String path) {
        File dpFile;
        String id = this.getDataProviderId(path);
        if (id == null) {
            return this.getDefaultDataProviderProperties();
        }
        File f = new File(path);
        if (f.exists() && f.isFile() && f.getName().equals(id + ".properties")) {
            return this.getDataProviderPropertiesFromFile(f);
        }
        if (f.isDirectory() && (dpFile = new File(f, id + ".properties")).exists()) {
            return this.getDataProviderPropertiesFromFile(dpFile);
        }
        return this.getDefaultDataProviderProperties();
    }

    @Override
    public String getFilename(String location, String path) {
        String local;
        int pos = path.indexOf(location);
        if (pos != -1 && ((local = path.substring(pos + location.length())).startsWith("/") || local.startsWith("\\"))) {
            return local.substring(1);
        }
        return null;
    }

    @Override
    public int getFileCount(String localId) {
        return 1;
    }
}

