/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.password;

import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bcrypt.LongPasswordStrategies;
import at.favre.lib.crypto.bcrypt.LongPasswordStrategy;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.jboss.logging.Logger;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.credential.PasswordCredentialModel;

public class BCryptPasswordHashProvider
implements PasswordHashProvider {
    private static final int HARDCODEDNROFITERATIONS = 13;
    private static final Logger LOG = Logger.getLogger(BCryptPasswordHashProvider.class);
    private final int defaultIterations;
    private final String providerId;
    private final String pepper;
    private final Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");

    public BCryptPasswordHashProvider(String providerId) {
        LOG.debug((Object)"BCryptPasswordHashProvider created");
        this.providerId = providerId;
        this.defaultIterations = this.isNumeric(System.getenv("BCRYPT_ITERATIONS")) ? Integer.parseInt(System.getenv("BCRYPT_ITERATIONS")) : 13;
        if (null == System.getenv("BCRYPT_PEPPER")) {
            throw new RuntimeException("Bcrypt pepper environment variable not found, exiting ...");
        }
        this.pepper = System.getenv("BCRYPT_PEPPER");
    }

    public boolean policyCheck(PasswordPolicy passwordPolicy, PasswordCredentialModel credentialModel) {
        LOG.debug((Object)"BCryptPasswordHashProvider policy check");
        int policyHashIterations = passwordPolicy.getHashIterations();
        if (policyHashIterations == -1) {
            policyHashIterations = this.defaultIterations;
        }
        return credentialModel.getPasswordCredentialData().getHashIterations() == policyHashIterations && this.providerId.equals(credentialModel.getPasswordCredentialData().getAlgorithm());
    }

    public PasswordCredentialModel encodedCredential(String rawPassword, int iterations) {
        String encodedPassword = this.encode(rawPassword, iterations);
        return PasswordCredentialModel.createFromValues((String)this.providerId, (byte[])new byte[0], (int)iterations, (String)encodedPassword);
    }

    public String encode(String rawPassword, int iterations) {
        int cost = iterations == -1 ? this.defaultIterations : iterations;
        String base64PepperedPw = this.pepperer(rawPassword);
        return BCrypt.with((BCrypt.Version)BCrypt.Version.VERSION_2Y, (LongPasswordStrategy)LongPasswordStrategies.truncate((BCrypt.Version)BCrypt.Version.VERSION_2Y)).hashToString(cost, base64PepperedPw.toCharArray());
    }

    public void close() {
    }

    public boolean verify(String rawPassword, PasswordCredentialModel credential) {
        LOG.debug((Object)"BCryptPasswordHashProvider verifying password ...");
        String hash = credential.getPasswordSecretData().getValue();
        String base64PepperedPw = this.pepperer(rawPassword);
        BCrypt.Result verifier = BCrypt.verifyer((BCrypt.Version)BCrypt.Version.VERSION_2Y, (LongPasswordStrategy)LongPasswordStrategies.truncate((BCrypt.Version)BCrypt.Version.VERSION_2Y)).verify(base64PepperedPw.toCharArray(), hash.toCharArray());
        return verifier.verified;
    }

    private String pepperer(String rawPassword) {
        LOG.debug((Object)"BCryptPasswordHashProvider adding pepper ...");
        String pepperedPassword = rawPassword + this.pepper;
        return new String(Base64.encodeBase64((byte[])pepperedPassword.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        return this.pattern.matcher(strNum).matches();
    }
}

