/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.keycloak;

import eu.europeana.apikey.config.KeycloakProperties;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.springframework.beans.factory.BeanInitializationException;

public class KeycloakTokenVerifier {
    private PublicKey publicKey;

    protected KeycloakTokenVerifier(String realmPublicKey) {
        this.generatePublicKey(realmPublicKey);
    }

    public KeycloakTokenVerifier(KeycloakProperties kcProperties) {
        this(kcProperties.getRealmPublicKey());
    }

    private void generatePublicKey(String realmPublicKey) {
        try {
            byte[] publicBytes = Base64.getDecoder().decode(realmPublicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new BeanInitializationException("Public key could not be prepared", (Throwable)e);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    AccessToken verifyToken(String tokenString) throws VerificationException {
        TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class);
        return (AccessToken)verifier.publicKey(this.publicKey).verify().getToken();
    }

    AccessToken retrieveUserToken(String tokenString) throws VerificationException {
        return (AccessToken)TokenVerifier.create((String)tokenString, AccessToken.class).getToken();
    }
}

