/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.keycloak;

import eu.europeana.apikey.keycloak.KeycloakTokenVerifier;
import java.io.Serializable;
import org.keycloak.adapters.springsecurity.KeycloakAuthenticationException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;

public class KeycloakSecurityContext
implements Serializable {
    private static final long serialVersionUID = 6611924880256064860L;
    private final transient Keycloak keycloak;
    private transient AccessToken accessToken;
    private final transient KeycloakTokenVerifier keycloakTokenVerifier;
    private String accessTokenString;

    KeycloakSecurityContext(Keycloak keycloak, AccessToken accessToken, String accessTokenString, KeycloakTokenVerifier keycloakTokenVerifier) {
        this.keycloak = keycloak;
        this.accessToken = accessToken;
        this.accessTokenString = accessTokenString;
        this.keycloakTokenVerifier = keycloakTokenVerifier;
    }

    AccessToken getAccessToken() {
        this.refreshToken();
        return this.accessToken;
    }

    private void refreshToken() {
        if (this.accessToken.isExpired()) {
            try {
                this.accessToken = this.keycloakTokenVerifier.verifyToken(this.keycloak.tokenManager().getAccessToken().getToken());
                this.accessTokenString = this.keycloak.tokenManager().getAccessToken().getToken();
            }
            catch (VerificationException e) {
                throw new KeycloakAuthenticationException("Access token verification failed...", (Throwable)e);
            }
        }
    }

    String getAccessTokenString() {
        this.refreshToken();
        return this.accessTokenString;
    }
}

