/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.keycloak;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.apikey.config.KeycloakProperties;
import eu.europeana.apikey.domain.ApiKey;
import eu.europeana.apikey.domain.ApiKeyRequest;
import eu.europeana.apikey.exception.KCClientExistsException;
import eu.europeana.apikey.exception.KCException;
import eu.europeana.apikey.exception.MissingKCClientException;
import eu.europeana.apikey.keycloak.KeycloakAuthenticationToken;
import eu.europeana.apikey.keycloak.KeycloakPrincipal;
import eu.europeana.apikey.keycloak.KeycloakSecurityContext;
import eu.europeana.apikey.keycloak.KeycloakTokenVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.adapters.springsecurity.KeycloakAuthenticationException;
import org.keycloak.adapters.springsecurity.account.KeycloakRole;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class KeycloakClientManager {
    private static final Logger LOG = LogManager.getLogger(KeycloakClientManager.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final KeycloakTokenVerifier keycloakTokenVerifier;
    private final KeycloakProperties kcProperties;
    private CloseableHttpClient httpClient;

    public KeycloakClientManager(KeycloakProperties kcProperties) {
        this.kcProperties = kcProperties;
        this.keycloakTokenVerifier = new KeycloakTokenVerifier(kcProperties.getRealmPublicKey());
    }

    @PostConstruct
    public void init() {
        this.httpClient = HttpClients.createDefault();
    }

    @PreDestroy
    public void clean() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOG.error("Closing http client failed", (Throwable)e);
        }
    }

    public KeycloakPrincipal<KeycloakSecurityContext> authenticateClient(String clientId, String clientSecret) {
        AccessTokenResponse accessTokenResponse;
        Keycloak keycloak = KeycloakBuilder.builder().realm(this.kcProperties.getRealm()).serverUrl(this.kcProperties.getAuthServerUrl()).clientId(clientId).clientSecret(clientSecret).grantType("client_credentials").build();
        try {
            LOG.debug("Retrieving access token for client {}...", (Object)clientId);
            accessTokenResponse = keycloak.tokenManager().getAccessToken();
            if (accessTokenResponse == null) {
                LOG.error("No access token retrieved for client {}!", (Object)clientId);
                return null;
            }
        }
        catch (RuntimeException e) {
            String message = String.format("Retrieving access token failed for client  %s", clientId);
            LOG.info(message);
            throw new AuthenticationServiceException(message, (Throwable)e);
        }
        try {
            LOG.debug("Verifying access token for client {}...", (Object)clientId);
            AccessToken accessToken = this.keycloakTokenVerifier.verifyToken(accessTokenResponse.getToken());
            if (accessToken != null) {
                return new KeycloakPrincipal(clientId, new KeycloakSecurityContext(keycloak, accessToken, accessTokenResponse.getToken(), this.keycloakTokenVerifier));
            }
        }
        catch (VerificationException e) {
            String message = String.format("Authentication failed for client %s", clientId);
            LOG.info(message);
            throw new KeycloakAuthenticationException(message, (Throwable)e);
        }
        LOG.error("Verifying access token failed for client {}!", (Object)clientId);
        return null;
    }

    public ClientRepresentation createClient(KeycloakSecurityContext securityContext, ApiKey key) throws EuropeanaApiException {
        if (this.clientExists(key.getApiKey(), securityContext.getAccessTokenString())) {
            throw new KCClientExistsException(key.getApiKey());
        }
        ClientRepresentation newClientRep = new ClientRepresentation();
        newClientRep.setClientId(key.getApiKey());
        newClientRep.setPublicClient(Boolean.valueOf(false));
        newClientRep.setProtocol("openid-connect");
        newClientRep.setName(String.format("%s (%s)", key.getAppName(), StringUtils.isBlank((CharSequence)key.getCompany()) ? "" : key.getCompany()));
        newClientRep.setDescription(String.format("%s %s (%s)", key.getFirstName(), key.getLastName(), key.getEmail()));
        newClientRep.setDirectAccessGrantsEnabled(Boolean.valueOf(false));
        newClientRep.setServiceAccountsEnabled(Boolean.valueOf(true));
        ArrayList<String> redirectUris = new ArrayList<String>();
        redirectUris.add("*");
        newClientRep.setRedirectUris(redirectUris);
        HttpPost httpPost = new HttpPost(KeycloakUriBuilder.fromUri((String)String.format("%s/admin/realms/%s/clients", this.kcProperties.getAuthServerUrl(), this.kcProperties.getRealm())).build(new Object[0]));
        this.addAuthorizationHeader(securityContext.getAccessTokenString(), (HttpRequestBase)httpPost);
        this.addRequestEntity(newClientRep, (HttpEntityEnclosingRequestBase)httpPost);
        this.sendClientRequestToKeycloak((HttpUriRequest)httpPost, HttpStatus.CREATED.value(), newClientRep);
        LOG.debug("Client with ID {} and client_id {} was created", (Object)newClientRep.getId(), (Object)newClientRep.getClientId());
        return this.getClientSecret(key.getApiKey(), securityContext);
    }

    public void updateClient(KeycloakSecurityContext securityContext, ApiKeyRequest apiKeyUpdate, String apiKey) throws EuropeanaApiException {
        ClientRepresentation clientRepresentation = this.getClientRepresentation(apiKey, securityContext);
        this.updateClient(this.updateClientRepresentation(clientRepresentation, apiKeyUpdate), securityContext);
    }

    private ClientRepresentation updateClientRepresentation(ClientRepresentation clientRepresentation, ApiKeyRequest apiKeyUpdate) {
        if (apiKeyUpdate == null) {
            return clientRepresentation;
        }
        String appNameClientId = StringUtils.isNotBlank((CharSequence)apiKeyUpdate.getAppName()) ? apiKeyUpdate.getAppName() : clientRepresentation.getClientId();
        String companySector = (StringUtils.isNotBlank((CharSequence)apiKeyUpdate.getCompany()) ? apiKeyUpdate.getCompany() : "N/A") + (String)(StringUtils.isNotBlank((CharSequence)apiKeyUpdate.getSector()) ? ", sector: " + apiKeyUpdate.getSector() : "");
        clientRepresentation.setName(String.format("%s (%s)", appNameClientId, companySector));
        clientRepresentation.setDescription(String.format("%s %s (%s)", apiKeyUpdate.getFirstName(), apiKeyUpdate.getLastName(), apiKeyUpdate.getEmail()));
        return clientRepresentation;
    }

    private void updateClient(ClientRepresentation clientRepresentation, KeycloakSecurityContext securityContext) throws EuropeanaApiException {
        HttpPut httpPut = new HttpPut(KeycloakUriBuilder.fromUri((String)String.format("%s/admin/realms/%s/clients/%s", this.kcProperties.getAuthServerUrl(), this.kcProperties.getRealm(), clientRepresentation.getId())).build(new Object[0]));
        this.addAuthorizationHeader(securityContext.getAccessTokenString(), (HttpRequestBase)httpPut);
        this.addRequestEntity(clientRepresentation, (HttpEntityEnclosingRequestBase)httpPut);
        this.sendClientRequestToKeycloak((HttpUriRequest)httpPut, HttpStatus.NO_CONTENT.value(), clientRepresentation);
    }

    public void deleteClient(KeycloakSecurityContext securityContext, String apiKey) throws EuropeanaApiException {
        ClientRepresentation clientRepresentation = this.getClientRepresentation(apiKey, securityContext);
        HttpDelete httpDelete = new HttpDelete(KeycloakUriBuilder.fromUri((String)String.format("%s/admin/realms/%s/clients/%s", this.kcProperties.getAuthServerUrl(), this.kcProperties.getRealm(), clientRepresentation.getId())).build(new Object[0]));
        this.addAuthorizationHeader(securityContext.getAccessTokenString(), (HttpRequestBase)httpDelete);
        this.sendClientRequestToKeycloak((HttpUriRequest)httpDelete, HttpStatus.NO_CONTENT.value(), clientRepresentation);
    }

    public void enableClient(String clientId, KeycloakSecurityContext securityContext) throws EuropeanaApiException {
        ClientRepresentation clientRepresentation = this.getClientRepresentation(clientId, securityContext);
        if (Boolean.FALSE.equals(clientRepresentation.isEnabled())) {
            clientRepresentation.setEnabled(Boolean.valueOf(true));
            this.updateClient(clientRepresentation, securityContext);
        } else {
            LOG.info("Client with id: {} and clientId: {} is already {}", (Object)clientRepresentation.getClientId(), (Object)clientRepresentation.getId(), (Object)"enabled");
        }
    }

    public void disableClient(String clientId, KeycloakSecurityContext securityContext) throws EuropeanaApiException {
        ClientRepresentation clientRepresentation = this.getClientRepresentation(clientId, securityContext);
        if (Boolean.TRUE.equals(clientRepresentation.isEnabled())) {
            clientRepresentation.setEnabled(Boolean.valueOf(false));
            this.updateClient(clientRepresentation, securityContext);
        } else {
            LOG.info("Client with id: {} and clientId: {} is already {}", (Object)clientRepresentation.getClientId(), (Object)clientRepresentation.getId(), (Object)"disabled");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ClientRepresentation> getClients(HttpGet httpGet) throws KCException {
        LOG.debug("Sending getClients to Keycloak...");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            LOG.debug("Received getClients from Keycloak");
            if (response.getStatusLine().getStatusCode() == HttpStatus.OK.value()) {
                InputStream is = response.getEntity().getContent();
                CollectionType mapCollectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, ClientRepresentation.class);
                List list = (List)this.mapper.readValue(is, (JavaType)mapCollectionType);
                return list;
            }
            String message = "Error communicating with Keycloak: received " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase();
            LOG.error(message);
            throw new KCException(message, HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        catch (IOException e) {
            LOG.error("Error communicating with Keycloak");
            throw new KCException("Error communicating with Keycloak", HttpStatus.INTERNAL_SERVER_ERROR.value(), (Throwable)e);
        }
    }

    private ClientRepresentation getClientSecret(String clientId, KeycloakSecurityContext securityContext) throws EuropeanaApiException {
        String secret;
        ClientRepresentation representation = this.getClientRepresentation(clientId, securityContext);
        HttpGet httpGet = new HttpGet(KeycloakUriBuilder.fromUri((String)String.format("%s/admin/realms/%s/clients/%s/client-secret", this.kcProperties.getAuthServerUrl(), this.kcProperties.getRealm(), representation.getId())).build(new Object[0]));
        this.addAuthorizationHeader(securityContext.getAccessTokenString(), (HttpRequestBase)httpGet);
        LOG.debug("Sending getClientSecret of {} to Keycloak...", (Object)clientId);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            LOG.debug("Received getClientSecret for {} from Keycloak", (Object)clientId);
            if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                String message = "Error communicating with Keycloak: received " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase();
                LOG.error(message);
                throw new KCException(message, HttpStatus.INTERNAL_SERVER_ERROR.value());
            }
            try (InputStream is = response.getEntity().getContent();){
                secret = ((CredentialRepresentation)this.mapper.readValue(is, CredentialRepresentation.class)).getValue();
            }
        }
        catch (IOException e) {
            LOG.error("Error communicating with Keycloak");
            throw new KCException("Error communicating with Keycloak", HttpStatus.INTERNAL_SERVER_ERROR.value(), (Throwable)e);
        }
        representation.setSecret(secret);
        return representation;
    }

    private ClientRepresentation getClientRepresentation(String clientId, KeycloakSecurityContext securityContext) throws EuropeanaApiException {
        HttpGet httpGet = this.prepareGetClientRequest(clientId, securityContext.getAccessTokenString());
        LOG.debug("Retrieving client representation for {}...", (Object)clientId);
        List clients = this.getClients(httpGet);
        if (clients == null || clients.isEmpty()) {
            LOG.error("Could not retrieve client with clientId {}", (Object)clientId);
            throw new MissingKCClientException(clientId);
        }
        return (ClientRepresentation)clients.get(0);
    }

    private void sendClientRequestToKeycloak(HttpUriRequest httpRequest, int expectedHttpStatus, ClientRepresentation clientRep) throws EuropeanaApiException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending {} request for API key {} (client {}) to Keycloak...", (Object)(httpRequest.getMethod() + " " + httpRequest.getURI().getPath()), (Object)clientRep.getClientId(), (Object)clientRep.getId());
        }
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            LOG.debug("Received response for client {} from Keycloak: {}", (Object)clientRep.getId(), (Object)response);
            if (response.getStatusLine().getStatusCode() != expectedHttpStatus) {
                String message = "Error communicating with Keycloak: received " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase();
                LOG.error(message);
                throw new KCException(message, HttpStatus.INTERNAL_SERVER_ERROR.value());
            }
        }
        catch (IOException e) {
            LOG.error("Error communicating with Keycloak");
            throw new KCException("Error communicating with Keycloak", HttpStatus.INTERNAL_SERVER_ERROR.value(), (Throwable)e);
        }
    }

    private void addRequestEntity(ClientRepresentation clientRepresentation, HttpEntityEnclosingRequestBase httpRequest) throws EuropeanaApiException {
        StringEntity entity;
        httpRequest.addHeader("Content-Type", "application/json");
        try {
            entity = new StringEntity(this.mapper.writeValueAsString((Object)clientRepresentation), "UTF-8");
        }
        catch (JsonProcessingException e) {
            String message = "Problem with creating client representation for the request";
            LOG.error(message);
            throw new KCException(message, HttpStatus.INTERNAL_SERVER_ERROR.value(), (Throwable)e);
        }
        httpRequest.setEntity((HttpEntity)entity);
    }

    public Collection<GrantedAuthority> getAuthorities(AccessToken token) {
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>();
        if (this.kcProperties.isUseResourceRoleMappings()) {
            token.getResourceAccess().forEach((s, access) -> {
                if (access != null) {
                    access.getRoles().forEach(role -> result.add((GrantedAuthority)new KeycloakRole(role)));
                }
            });
        } else {
            AccessToken.Access access2 = token.getRealmAccess();
            if (access2 != null) {
                access2.getRoles().forEach(s -> result.add((GrantedAuthority)new KeycloakRole(s)));
            }
        }
        return result;
    }

    public String checkifClientExists(String apiKey, KeycloakSecurityContext kcSecurityContext) throws EuropeanaApiException {
        HttpGet httpGet = this.prepareGetClientRequest(apiKey, kcSecurityContext.getAccessTokenString());
        LOG.debug("Checking if client with clientId {} exists...", (Object)apiKey);
        List clients = this.getClients(httpGet);
        if (clients != null && !clients.isEmpty()) {
            return ((ClientRepresentation)clients.get(0)).getId();
        }
        LOG.info("No client with clientId {} was found", (Object)apiKey);
        return null;
    }

    private boolean clientExists(String apiKey, String accessToken) throws EuropeanaApiException {
        HttpGet httpGet = this.prepareGetClientRequest(apiKey, accessToken);
        LOG.debug("Checking if client {} exists...", (Object)apiKey);
        List clients = this.getClients(httpGet);
        boolean result = clients != null && !clients.isEmpty();
        LOG.debug("Keycloak client with API key {} exists = {}", (Object)apiKey, (Object)result);
        return result;
    }

    private HttpGet prepareGetClientRequest(String apiKey, String accessToken) {
        HttpGet httpGet = new HttpGet(KeycloakUriBuilder.fromUri((String)String.format("%s/admin/realms/%s/clients", this.kcProperties.getAuthServerUrl(), this.kcProperties.getRealm())).queryParam("clientId", new Object[]{apiKey}).build(new Object[0]));
        this.addAuthorizationHeader(accessToken, (HttpRequestBase)httpGet);
        return httpGet;
    }

    public boolean isOwner(String apiKey, KeycloakAuthenticationToken keycloakAuthenticationToken) {
        if (apiKey == null || keycloakAuthenticationToken == null || keycloakAuthenticationToken.getCredentials() == null) {
            LOG.error("Could not check if supplied token owns Apikey '{}', because one or more of the Apikey, the token and / or the credentials found in the token are null", (Object)apiKey);
            return false;
        }
        return apiKey.equals(keycloakAuthenticationToken.getName());
    }

    public boolean isManagerClientAuthorized(KeycloakAuthenticationToken keycloakAuthenticationToken) {
        if (keycloakAuthenticationToken == null || keycloakAuthenticationToken.getCredentials() == null) {
            LOG.error("Could not check if supplied token was issued for a manager client, because either the token or the credentials found in there are null");
            return false;
        }
        Collection authorities = keycloakAuthenticationToken.getAuthorities();
        if (authorities == null || authorities.isEmpty()) {
            LOG.error("Could not check if supplied token was issued for a manager client, because no authorities could be found in the token");
            return false;
        }
        Optional<String> manager = authorities.stream().map(GrantedAuthority::getAuthority).filter("manage-clients"::equals).findFirst();
        return manager.isPresent();
    }

    private void addAuthorizationHeader(String accessToken, HttpRequestBase request) {
        request.addHeader("Authorization", "bearer " + accessToken);
    }
}

