/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.keycloak;

import eu.europeana.apikey.keycloak.KeycloakAuthenticationToken;
import eu.europeana.apikey.keycloak.KeycloakClientManager;
import eu.europeana.apikey.keycloak.KeycloakPrincipal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CustomKeycloakAuthenticationProvider
extends KeycloakAuthenticationProvider {
    private static final Logger LOG = LogManager.getLogger(CustomKeycloakAuthenticationProvider.class);
    private final KeycloakClientManager keycloakClientManager;

    public CustomKeycloakAuthenticationProvider(KeycloakClientManager keycloakClientManager) {
        this.keycloakClientManager = keycloakClientManager;
    }

    public Authentication authenticateAdminClient(String clientId, String clientSecret) {
        LOG.debug("Authenticating client {}", (Object)clientId);
        KeycloakPrincipal principal = this.keycloakClientManager.authenticateClient(clientId, clientSecret);
        if (principal != null) {
            return new KeycloakAuthenticationToken(principal, this.keycloakClientManager.getAuthorities(principal.getKeycloakSecurityContext().getAccessToken()));
        }
        LOG.info("Authentication for client {} failed!", (Object)clientId);
        return null;
    }

    public Authentication authenticate(Authentication authentication) {
        return this.authenticateAdminClient(authentication.getName(), authentication.getCredentials().toString());
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

