/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import eu.europeana.apikey.domain.View;
import eu.europeana.apikey.util.Tools;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Entity
@Table(name="apikey")
public class ApiKey {
    @Id
    @Column(name="apikey")
    @JsonProperty(value="apiKey")
    @JsonView(value={View.Public.class})
    private String apiKey;
    @Column(name="keycloakid")
    @JsonProperty(value="keycloakId")
    @JsonView(value={View.Public.class})
    private String keycloakId;
    @NotNull
    @Column(name="registrationdate")
    @JsonProperty(value="registrationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonView(value={View.Public.class})
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    private Date registrationDate;
    @Size(max=100)
    @Column(name="website")
    @JsonProperty(value="website")
    @JsonView(value={View.Public.class})
    private @Size(max=100) String website;
    @Column(name="activationdate")
    @JsonProperty(value="activationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @JsonView(value={View.Public.class})
    private Date activationDate;
    @NotNull
    @Size(max=255)
    @Column(name="appname")
    @JsonProperty(value="appName")
    @JsonView(value={View.Public.class})
    private @NotNull @Size(max=255) String appName;
    @NotNull
    @Size(max=100)
    @Column(name="company")
    @JsonProperty(value="company")
    @JsonView(value={View.Public.class})
    private @NotNull @Size(max=100) String company;
    @Size(max=255)
    @Column(name="sector")
    @JsonProperty(value="sector")
    @JsonView(value={View.Public.class})
    private @Size(max=255) String sector;
    @NotNull
    @Size(max=100)
    @Column(name="email")
    @JsonProperty(value="email")
    @JsonView(value={View.Public.class})
    protected @NotNull @Size(max=100) String email;
    @NotNull
    @Size(max=100)
    @Column(name="firstname")
    @JsonProperty(value="firstName")
    @JsonView(value={View.Public.class})
    private @NotNull @Size(max=100) String firstName;
    @NotNull
    @Size(max=100)
    @Column(name="lastname")
    @JsonProperty(value="lastName")
    @JsonView(value={View.Public.class})
    private @NotNull @Size(max=100) String lastName;
    @Column(name="deprecationdate")
    @JsonProperty(value="deprecationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @JsonView(value={View.Public.class})
    private Date deprecationDate;
    @Column(name="lastaccessdate")
    @JsonProperty(value="lastAccessDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @JsonView(value={View.Public.class})
    private Date lastAccessDate;
    @Size(max=255)
    @Column(name="comments")
    @JsonProperty(value="comments")
    @JsonView(value={View.Public.class})
    private @Size(max=255) String comments;

    public ApiKey() {
    }

    public ApiKey(String apiKey, String firstName, String lastName, String email, String appName, String company) {
        this.apiKey = apiKey;
        this.keycloakId = null;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.appName = appName;
        this.company = company;
        this.registrationDate = new Date();
    }

    public ApiKey(ApiKey copy) {
        this.apiKey = copy.apiKey;
        this.keycloakId = copy.keycloakId;
        this.registrationDate = copy.registrationDate;
        this.website = copy.website;
        this.activationDate = copy.activationDate;
        this.appName = copy.appName;
        this.company = copy.company;
        this.sector = copy.sector;
        this.email = copy.email;
        this.firstName = copy.firstName;
        this.lastName = copy.lastName;
        this.deprecationDate = copy.deprecationDate;
        this.lastAccessDate = copy.lastAccessDate;
        this.comments = copy.comments;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @JsonIgnore
    public String getKeycloakId() {
        return this.keycloakId;
    }

    public void setKeycloakId(String keycloakId) {
        this.keycloakId = keycloakId;
    }

    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Date getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(Date activationDate) {
        this.activationDate = activationDate;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Date getDeprecationDate() {
        return this.deprecationDate;
    }

    public void setDeprecationDate(Date deprecationDate) {
        this.deprecationDate = deprecationDate;
    }

    public Date getLastAccessDate() {
        return this.lastAccessDate;
    }

    public void setLastAccessDate(Date lastAccessDate) {
        this.lastAccessDate = lastAccessDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toString() {
        return "ApiKey { apikey = " + this.apiKey + ", keycloakId = " + this.keycloakId + ", firstName = " + Tools.nvl((String)this.firstName) + ", lastName = " + Tools.nvl((String)this.lastName) + ", email = " + Tools.nvl((String)this.email) + ", appName = " + Tools.nvl((String)this.appName) + ", website = " + Tools.nvl((String)this.website) + ", company = " + Tools.nvl((String)this.company) + ", sector = " + Tools.nvl((String)this.sector) + ", activationDate = " + Tools.nvl((Date)this.activationDate) + ", registrationDate = " + Tools.nvl((Date)this.registrationDate) + ", lastAccessDate = " + Tools.nvl((Date)this.lastAccessDate) + ", deprecationDate = " + Tools.nvl((Date)this.deprecationDate) + " }";
    }
}

