/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.apikey.controller;

import com.fasterxml.jackson.annotation.JsonView;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.apikey.captcha.CaptchaManager;
import eu.europeana.apikey.domain.ApiKey;
import eu.europeana.apikey.domain.ApiKeyRequest;
import eu.europeana.apikey.domain.View;
import eu.europeana.apikey.exception.ApiKeyDeprecatedException;
import eu.europeana.apikey.exception.ApiKeyExistsException;
import eu.europeana.apikey.exception.ApiKeyNotDeprecatedException;
import eu.europeana.apikey.exception.ApiKeyNotFoundException;
import eu.europeana.apikey.exception.CaptchaException;
import eu.europeana.apikey.exception.ForbiddenException;
import eu.europeana.apikey.exception.KCIdNotEmptyException;
import eu.europeana.apikey.exception.MissingDataException;
import eu.europeana.apikey.exception.MissingKeyException;
import eu.europeana.apikey.keycloak.CustomKeycloakAuthenticationProvider;
import eu.europeana.apikey.keycloak.KeycloakAuthenticationToken;
import eu.europeana.apikey.keycloak.KeycloakClientManager;
import eu.europeana.apikey.keycloak.KeycloakSecurityContext;
import eu.europeana.apikey.mail.MailService;
import eu.europeana.apikey.repos.ApiKeyRepo;
import eu.europeana.apikey.util.PassGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.keycloak.representations.idm.ClientRepresentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/apikey"})
public class ApiKeyController {
    private static final Logger LOG = LogManager.getLogger(ApiKeyController.class);
    private final ApiKeyRepo apiKeyRepo;
    private final CaptchaManager captchaManager;
    private final CustomKeycloakAuthenticationProvider customKeycloakAuthenticationProvider;
    private final KeycloakClientManager keycloakClientManager;
    private String message;
    @Autowired
    private MailService emailService;
    @Autowired
    @Qualifier(value="apikeyTemplate")
    private SimpleMailMessage apiKeyCreatedMsg;
    @Autowired
    @Qualifier(value="apikeyAndClientTemplate")
    private SimpleMailMessage apiKeyAndClientCreatedMsg;
    @Autowired
    @Qualifier(value="clientTemplate")
    private SimpleMailMessage clientAddedMsg;

    @Autowired
    public ApiKeyController(ApiKeyRepo apiKeyRepo, CaptchaManager captchaManager, CustomKeycloakAuthenticationProvider customKeycloakAuthenticationProvider, KeycloakClientManager keycloakClientManager) {
        this.apiKeyRepo = apiKeyRepo;
        this.captchaManager = captchaManager;
        this.customKeycloakAuthenticationProvider = customKeycloakAuthenticationProvider;
        this.keycloakClientManager = keycloakClientManager;
    }

    @CrossOrigin(maxAge=600L)
    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> createKey(@RequestBody ApiKeyRequest newKeyRequest) throws EuropeanaApiException {
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        LOG.debug("User {} creates new API key ... ", kcAuthToken.getPrincipal());
        ApiKeyRequest createApiKey = this.checkMandatoryFieldsAndTrim(newKeyRequest);
        this.checkKeyEmailAppNameExist(createApiKey.getEmail(), createApiKey.getAppName());
        return this.createApikey(createApiKey);
    }

    @CrossOrigin(maxAge=600L)
    @PostMapping(path={"/captcha"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> createCaptcha(HttpServletRequest httpServletRequest, @RequestBody ApiKeyRequest newKeyRequest) throws EuropeanaApiException {
        LOG.debug("Creating new API key secured by captcha...");
        ApiKeyRequest createApiKey = this.checkMandatoryFieldsAndTrim(newKeyRequest);
        this.checkKeyEmailAppNameExist(createApiKey.getEmail(), createApiKey.getAppName());
        String captchaToken = this.getAuthorizationHeader(httpServletRequest, "Bearer\\s+([^\\s]+)");
        if (captchaToken == null) {
            LOG.info("Missing or malformed Captcha token. Correct syntax header is: Authorization: Bearer CAPTCHA_TOKEN");
            throw new CaptchaException("Missing or malformed Captcha token. Correct syntax header is: Authorization: Bearer CAPTCHA_TOKEN");
        }
        if (!this.captchaManager.verifyCaptchaToken(captchaToken)) {
            LOG.info("Captcha verification failed.");
            throw new CaptchaException("Captcha verification failed.");
        }
        return this.createApikey(newKeyRequest);
    }

    @CrossOrigin(maxAge=600L)
    @PostMapping(path={"/keycloak"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> createKeyAndClient(@RequestBody ApiKeyRequest newKeyRequest) throws EuropeanaApiException {
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        LOG.debug("User {} creates new combined API key / KeyCloak Client pair ...", kcAuthToken.getPrincipal());
        ApiKeyRequest createApiKey = this.checkMandatoryFieldsAndTrim(newKeyRequest);
        this.checkKeyEmailAppNameExist(createApiKey.getEmail(), createApiKey.getAppName());
        ApiKey newKey = this.prepareNewApiKey(createApiKey);
        LOG.debug("New Apikey '{}' prepared; creating Client and retrieving its ID ...", (Object)newKey.getApiKey());
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)kcAuthToken.getCredentials();
        ClientRepresentation newClientRep = this.keycloakClientManager.createClient(securityContext, newKey);
        newKey.setKeycloakId(newClientRep.getId());
        LOG.debug("New Client with ID '{}' created linked to Apikey '{}'", (Object)newClientRep.getId(), (Object)newKey.getApiKey());
        this.apiKeyRepo.save((Object)newKey);
        LOG.debug("Apikey '{}' created", (Object)newKey.getApiKey());
        this.apiKeyAndClientCreatedMsg.setTo(newKey.getEmail());
        this.emailService.sendApiKeyAndClientEmail(this.apiKeyAndClientCreatedMsg, newKey.getFirstName(), newKey.getLastName(), newKey.getApiKey(), newClientRep.getSecret());
        return new ResponseEntity((Object)newKey, HttpStatus.CREATED);
    }

    @PostMapping(path={"/keycloak/{apiKey}"})
    public ResponseEntity<HttpStatus> addClient(@PathVariable(value="apiKey") String apiKey) throws EuropeanaApiException {
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        ApiKey existingApiKey = this.checkIfKeyExists(apiKey);
        LOG.debug("Verified that API key {} exists in database!", (Object)apiKey);
        if (StringUtils.isNotBlank((CharSequence)existingApiKey.getKeycloakId())) {
            LOG.error("There is already a Keycloak ID value assigned to Apikey {}", (Object)apiKey);
            throw new KCIdNotEmptyException(apiKey, existingApiKey.getKeycloakId());
        }
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)kcAuthToken.getCredentials();
        ClientRepresentation newClientRep = this.keycloakClientManager.createClient(securityContext, existingApiKey);
        String keycloakId = newClientRep.getId();
        LOG.debug("A Keycloak Client with id {} linked to Apikey {} has been created", (Object)keycloakId, (Object)apiKey);
        existingApiKey.setKeycloakId(keycloakId);
        this.apiKeyRepo.save((Object)existingApiKey);
        this.clientAddedMsg.setTo(existingApiKey.getEmail());
        this.emailService.sendApiKeyAndClientEmail(this.clientAddedMsg, existingApiKey.getFirstName(), existingApiKey.getLastName(), existingApiKey.getApiKey(), newClientRep.getSecret());
        LOG.info("API key {} was updated, keycloakId is {}", (Object)apiKey, (Object)existingApiKey.getKeycloakId());
        return new ResponseEntity(HttpStatus.CREATED);
    }

    ResponseEntity<Object> createApikey(ApiKeyRequest newKeyRequest) throws EuropeanaApiException {
        ApiKey newKey = this.prepareNewApiKey(newKeyRequest);
        this.apiKeyRepo.save((Object)newKey);
        LOG.debug("New Apikey {} created", (Object)newKey.getApiKey());
        this.apiKeyCreatedMsg.setTo(newKey.getEmail());
        this.emailService.sendApiKeyEmail(this.apiKeyCreatedMsg, newKey.getFirstName(), newKey.getLastName(), newKey.getApiKey());
        return new ResponseEntity((Object)newKey, HttpStatus.CREATED);
    }

    ApiKey prepareNewApiKey(ApiKeyRequest newKeyRequest) {
        String newPublicKey = this.generatePublicKey();
        ApiKey newKey = new ApiKey(newPublicKey, newKeyRequest.getFirstName(), newKeyRequest.getLastName(), newKeyRequest.getEmail(), newKeyRequest.getAppName(), newKeyRequest.getCompany());
        if (StringUtils.isNotEmpty((CharSequence)newKeyRequest.getWebsite())) {
            newKey.setWebsite(newKeyRequest.getWebsite());
        }
        if (StringUtils.isNotEmpty((CharSequence)newKeyRequest.getSector())) {
            newKey.setSector(newKeyRequest.getSector());
        }
        return newKey;
    }

    String getAuthorizationHeader(HttpServletRequest httpServletRequest, String valuePattern) {
        String authorization = httpServletRequest.getHeader("Authorization");
        if (authorization != null) {
            try {
                Pattern pattern = Pattern.compile(valuePattern);
                Matcher matcher = pattern.matcher(authorization);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (RuntimeException e) {
                LOG.error("Regex problem while parsing authorization header", (Throwable)e);
            }
        }
        return null;
    }

    @CrossOrigin(maxAge=600L)
    @JsonView(value={View.Public.class})
    @GetMapping(path={"/{apikey}"}, produces={"application/json"})
    public ApiKey read(@PathVariable(value="apikey") String apiKey) throws EuropeanaApiException {
        LOG.debug("Retrieving details for API key '{}' ...", (Object)apiKey);
        this.checkManagerOrOwnerCredentials(apiKey);
        return this.checkIfKeyExists(apiKey);
    }

    @CrossOrigin(maxAge=600L)
    @PutMapping(value={"/{apikey}"}, produces={"application/json"}, consumes={"application/json"})
    public ApiKey update(@PathVariable(value="apikey") String apiKey, @RequestBody ApiKeyRequest updateKeyRequest) throws EuropeanaApiException {
        ApiKeyRequest updateApiKey = this.checkMandatoryFieldsAndTrim(updateKeyRequest);
        ApiKey key = this.checkIfKeyExists(apiKey);
        this.checkKeyDeprecated(key);
        this.copyValuesToApiKey(key, updateApiKey);
        this.apiKeyRepo.save((Object)key);
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        String keyCloakId = this.keycloakClientManager.checkifClientExists(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
        if (StringUtils.isNotBlank((CharSequence)keyCloakId)) {
            this.keycloakClientManager.updateClient((KeycloakSecurityContext)kcAuthToken.getCredentials(), updateApiKey, apiKey);
            LOG.debug("User {} has updated Apikey '{}' and linked Client '{}'", kcAuthToken.getPrincipal(), (Object)apiKey, (Object)keyCloakId);
        } else {
            LOG.debug("User {} has updated API key '{}'", kcAuthToken.getPrincipal(), (Object)apiKey);
        }
        return key;
    }

    @CrossOrigin(maxAge=600L)
    @PutMapping(path={"/{apikey}/disable"})
    public ResponseEntity<Object> disable(@PathVariable(value="apikey") String apiKey) throws EuropeanaApiException {
        ApiKey key = this.checkIfKeyExists(apiKey);
        this.checkKeyDeprecated(key);
        key.setDeprecationDate(new DateTime(DateTimeZone.UTC).toDate());
        this.apiKeyRepo.save((Object)key);
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        String keyCloakId = this.keycloakClientManager.checkifClientExists(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
        if (StringUtils.isNotBlank((CharSequence)keyCloakId)) {
            this.keycloakClientManager.disableClient(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
            LOG.debug("User {} has disabled Apikey '{}' and linked Client '{}'", kcAuthToken.getPrincipal(), (Object)apiKey, (Object)keyCloakId);
        } else {
            LOG.debug("User {} has disabled API key '{}'", kcAuthToken.getPrincipal(), (Object)apiKey);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @CrossOrigin(maxAge=600L)
    @PutMapping(path={"/{apikey}/enable"})
    public ApiKey enable(@PathVariable(value="apikey") String apiKey) throws EuropeanaApiException {
        ApiKey key = this.checkIfKeyExists(apiKey);
        if (key.getDeprecationDate() == null) {
            this.message = String.format("API key %s is not deprecated!", apiKey);
            LOG.info(this.message);
            throw new ApiKeyNotDeprecatedException(apiKey);
        }
        key.setDeprecationDate(null);
        this.apiKeyRepo.save((Object)key);
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        String keyCloakId = this.keycloakClientManager.checkifClientExists(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
        if (StringUtils.isNotBlank((CharSequence)keyCloakId)) {
            this.keycloakClientManager.enableClient(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
            LOG.debug("User {} has enabled Apikey '{}' and linked Client '{}'", kcAuthToken.getPrincipal(), (Object)apiKey, (Object)keyCloakId);
        } else {
            LOG.debug("User {} has enabled API key '{}'", kcAuthToken.getPrincipal(), (Object)apiKey);
        }
        return key;
    }

    @CrossOrigin(maxAge=600L)
    @DeleteMapping(path={"/{apikey}"})
    public ResponseEntity<Object> delete(@PathVariable(value="apikey") String apiKey) throws EuropeanaApiException {
        KeycloakAuthenticationToken kcAuthToken = this.checkManagerCredentials();
        ApiKey keyToDelete = this.checkIfKeyExists(apiKey);
        LOG.warn("User {} is permanently deleting API key {}...", kcAuthToken.getPrincipal(), (Object)apiKey);
        this.apiKeyRepo.delete((Object)keyToDelete);
        String keyCloakId = this.keycloakClientManager.checkifClientExists(apiKey, (KeycloakSecurityContext)kcAuthToken.getCredentials());
        if (StringUtils.isNotBlank((CharSequence)keyCloakId)) {
            this.keycloakClientManager.deleteClient((KeycloakSecurityContext)kcAuthToken.getCredentials(), apiKey);
            LOG.debug("User {} has deleted Apikey '{}' and linked Client '{}'", kcAuthToken.getPrincipal(), (Object)apiKey, (Object)keyCloakId);
        } else {
            LOG.debug("User {} has deleted API key '{}'", kcAuthToken.getPrincipal(), (Object)apiKey);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @PostMapping(path={"/validate"})
    public ResponseEntity<Object> validate(HttpServletRequest httpServletRequest) throws EuropeanaApiException {
        String id = this.getAuthorizationHeader(httpServletRequest, "APIKEY\\s+([^\\s]+)");
        if (StringUtils.isBlank((CharSequence)id)) {
            LOG.info("Correct header syntax 'Authorization: APIKEY <your_key_here>'");
            throw new MissingKeyException("Correct header syntax 'Authorization: APIKEY <your_key_here>'");
        }
        LOG.debug("Validating API key {}...", (Object)id);
        Optional optionalApiKey = this.apiKeyRepo.findById((Object)id);
        if (optionalApiKey.isEmpty()) {
            this.message = String.format("API key %s is not registered", id);
            LOG.info(this.message);
            return new ResponseEntity((Object)this.message, HttpStatus.UNAUTHORIZED);
        }
        this.checkKeyDeprecated((ApiKey)optionalApiKey.get());
        Date now = new DateTime(DateTimeZone.UTC).toDate();
        if (null == ((ApiKey)optionalApiKey.get()).getActivationDate()) {
            ((ApiKey)optionalApiKey.get()).setActivationDate(now);
        }
        ((ApiKey)optionalApiKey.get()).setLastAccessDate(now);
        this.apiKeyRepo.save((Object)((ApiKey)optionalApiKey.get()));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    protected void copyValuesToApiKey(ApiKey apiKey, ApiKeyRequest keyRequest) {
        if (null != keyRequest.getFirstName()) {
            apiKey.setFirstName(keyRequest.getFirstName());
        }
        if (null != keyRequest.getLastName()) {
            apiKey.setLastName(keyRequest.getLastName());
        }
        if (null != keyRequest.getEmail()) {
            apiKey.setEmail(keyRequest.getEmail());
        }
        if (null != keyRequest.getWebsite()) {
            apiKey.setWebsite(keyRequest.getWebsite());
        }
        if (null != keyRequest.getAppName()) {
            apiKey.setAppName(keyRequest.getAppName());
        }
        if (null != keyRequest.getCompany()) {
            apiKey.setCompany(keyRequest.getCompany());
        }
        if (null != keyRequest.getSector()) {
            apiKey.setSector(keyRequest.getSector());
        }
    }

    protected KeycloakAuthenticationToken checkManagerCredentials() throws ForbiddenException {
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        if (!this.keycloakClientManager.isManagerClientAuthorized(token)) {
            this.message = String.format("Client %s is not authorised to manage API keys", token.getName());
            LOG.info(this.message);
            throw new ForbiddenException();
        }
        return token;
    }

    protected void checkManagerOrOwnerCredentials(String id) throws ForbiddenException {
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        if (!this.keycloakClientManager.isManagerClientAuthorized(token) && !this.keycloakClientManager.isOwner(id, token)) {
            throw new ForbiddenException();
        }
    }

    protected ApiKeyRequest checkMandatoryFieldsAndTrim(ApiKeyRequest apiKeyUpdate) throws MissingDataException {
        String retval = "Required parameter(s): ";
        ArrayList<String> missingList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)apiKeyUpdate.getFirstName())) {
            missingList.add("'firstName'");
        }
        if (StringUtils.isBlank((CharSequence)apiKeyUpdate.getLastName())) {
            missingList.add("'lastName'");
        }
        if (StringUtils.isBlank((CharSequence)apiKeyUpdate.getEmail())) {
            missingList.add("'email'");
        }
        if (StringUtils.isBlank((CharSequence)apiKeyUpdate.getAppName())) {
            missingList.add("'appName'");
        }
        if (StringUtils.isBlank((CharSequence)apiKeyUpdate.getCompany())) {
            missingList.add("'company'");
        }
        if (!missingList.isEmpty()) {
            this.message = "Missing parameter. " + retval + missingList + " not provided";
            LOG.info(this.message);
            throw new MissingDataException(this.message);
        }
        if (!EmailValidator.getInstance().isValid(apiKeyUpdate.getEmail())) {
            this.message = String.format("Email %s is not properly formatted.", apiKeyUpdate.getEmail());
            LOG.info(this.message);
            throw new MissingDataException(this.message);
        }
        return this.trim(apiKeyUpdate);
    }

    private ApiKeyRequest trim(ApiKeyRequest apiKeyRequest) {
        return new ApiKeyRequest(apiKeyRequest.getFirstName().trim(), apiKeyRequest.getLastName().trim(), apiKeyRequest.getEmail().trim(), apiKeyRequest.getAppName().trim(), apiKeyRequest.getCompany().trim(), StringUtils.isBlank((CharSequence)apiKeyRequest.getSector()) ? apiKeyRequest.getSector() : apiKeyRequest.getSector().trim(), StringUtils.isBlank((CharSequence)apiKeyRequest.getWebsite()) ? apiKeyRequest.getWebsite() : apiKeyRequest.getWebsite().trim());
    }

    protected ApiKey checkIfKeyExists(String id) throws ApiKeyNotFoundException {
        Optional optionalApiKey = this.apiKeyRepo.findById((Object)id);
        if (optionalApiKey.isEmpty()) {
            this.message = String.format("API key %s is not registered", id);
            LOG.info(this.message);
            throw new ApiKeyNotFoundException(id);
        }
        return (ApiKey)optionalApiKey.get();
    }

    protected void checkKeyDeprecated(ApiKey key) throws ApiKeyDeprecatedException {
        if (key.getDeprecationDate() != null && key.getDeprecationDate().before(new Date())) {
            this.message = String.format("API key %s is deprecated", key);
            LOG.info(this.message);
            throw new ApiKeyDeprecatedException(key.getApiKey());
        }
    }

    protected void checkKeyEmailAppNameExist(String email, String appName) throws ApiKeyExistsException {
        List apiKeyList = this.apiKeyRepo.findByEmailAndAppName(email, appName);
        if (!apiKeyList.isEmpty()) {
            LOG.info(String.format("There already is an API key registered with application name %s and email %s.", email, appName));
            throw new ApiKeyExistsException(email, appName);
        }
    }

    protected String generatePublicKey() {
        String id;
        PassGenerator pg = new PassGenerator();
        while (this.apiKeyRepo.findById((Object)(id = pg.generate(RandomUtils.nextInt((int)8, (int)13)))).isPresent()) {
        }
        return id;
    }
}

